/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <gio/gio.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER (dvb_id_bus_terrestrial_scanner_get_type ())
#define DVB_ID_BUS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, DVBIDBusTerrestrialScanner))
#define DVB_IS_ID_BUS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER))
#define DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, DVBIDBusTerrestrialScannerIface))

typedef struct _DVBIDBusTerrestrialScanner DVBIDBusTerrestrialScanner;
typedef struct _DVBIDBusTerrestrialScannerIface DVBIDBusTerrestrialScannerIface;
typedef struct _DVBIDBusTerrestrialScannerDBusProxy DVBIDBusTerrestrialScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusTerrestrialScannerDBusProxyClass;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;
typedef struct _DVBTerrestrialScannerPrivate DVBTerrestrialScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBIDBusTerrestrialScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusTerrestrialScanner* self);
	void (*Destroy) (DVBIDBusTerrestrialScanner* self);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusTerrestrialScanner* self, const char* path);
	gboolean (*WriteChannelsToFile) (DVBIDBusTerrestrialScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
	void (*AddScanningData) (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
	gboolean (*AddScanningDataFromFile) (DVBIDBusTerrestrialScanner* self, const char* path);
};

struct _DVBIDBusTerrestrialScannerDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

/**
     * An abstract class responsible for scanning for new channels
     */
struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
	GeeHashMap* transport_streams;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
};

struct _DVBTerrestrialScanner {
	DVBScanner parent_instance;
	DVBTerrestrialScannerPrivate * priv;
};

struct _DVBTerrestrialScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_terrestrial_scanner_parent_class = NULL;
static DVBIDBusTerrestrialScannerIface* dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = NULL;

GType dvb_id_bus_terrestrial_scanner_get_type (void);
void dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self);
void dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self);
gboolean dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path);
gboolean dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
void dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
gboolean dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path);
void dvb_id_bus_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_introspect (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection);
static void _dbus_dvb_id_bus_terrestrial_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_terrestrial_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection);
GType dvb_id_bus_terrestrial_scanner_dbus_proxy_get_type (void);
DVBIDBusTerrestrialScanner* dvb_id_bus_terrestrial_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_finished (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_DBUS_PROXY_DUMMY_PROPERTY
};
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Run (DVBIDBusTerrestrialScanner* self);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy (DVBIDBusTerrestrialScanner* self);
static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path);
static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init (DVBIDBusTerrestrialScannerIface* iface);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_scanner_get_type (void);
GType dvb_scanned_item_get_type (void);
GType dvb_channel_get_type (void);
GType dvb_channel_list_get_type (void);
GType dvb_terrestrial_scanner_get_type (void);
enum  {
	DVB_TERRESTRIAL_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key);
GType dvb_dvb_src_bandwidth_get_type (void);
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth);
GType dvb_dvb_src_hierarchy_get_type (void);
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy);
GType dvb_dvb_src_modulation_get_type (void);
DVBDvbSrcModulation dvb_get_modulation_val (const char* constellation);
GType dvb_dvb_src_code_rate_get_type (void);
DVBDvbSrcCodeRate dvb_get_code_rate_val (const char* code_rate_string);
GType dvb_dvb_src_guard_get_type (void);
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard);
GType dvb_dvb_src_transmission_mode_get_type (void);
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const char* transmode);
static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBTerrestrialChannel* dvb_terrestrial_channel_new (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type);
GType dvb_terrestrial_channel_get_type (void);
static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base);
GType dvb_dvb_src_inversion_get_type (void);
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
void dvb_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_terrestrial_scanner_introspect (DVBTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
void dvb_scanner_Run (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const char* path);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const char* path);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_terrestrial_scanner_dbus_path_vtable = {_dvb_id_bus_terrestrial_scanner_dbus_unregister, dvb_id_bus_terrestrial_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_terrestrial_scanner_dbus_vtable = {dvb_id_bus_terrestrial_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_terrestrial_scanner_dbus_path_vtable = {_dvb_terrestrial_scanner_dbus_unregister, dvb_terrestrial_scanner_dbus_message};
static const _DBusObjectVTable _dvb_terrestrial_scanner_dbus_vtable = {dvb_terrestrial_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->WriteAllChannelsToFile (self, path);
}


gboolean dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, guint* channel_sids, int channel_sids_length1, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, channel_sids, channel_sids_length1, path);
}


void dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
}


/* 0-3
 0, 6, 7, 8
 "2k", "8k"
 "1/2", "2/3", "3/4", ..., "8/9"
 QPSK, QAM16, QAM64
 4, 8, 16, 32
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


void _dvb_id_bus_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_introspect (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Terrestrial\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"hierarchy\" type=\"u\" direction=\"in\"/>\n    <arg name=\"bandwidth\" type=\"u\" direction=\"in\"/>\n    <arg name=\"transmode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_hp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_lp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"constellation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"guard\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Terrestrial") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_terrestrial_scanner_Run (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_terrestrial_scanner_Destroy (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path;
	const char* _tmp1_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp1_);
	result = dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	path = (g_free (path), NULL);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp2_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint* channel_sids;
	int channel_sids_length1;
	guint* _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	char* path;
	const char* _tmp6_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "aus")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_sids = NULL;
	channel_sids_length1 = 0;
	_tmp3_ = g_new (guint, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		dbus_uint32_t _tmp5_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (guint, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = _tmp5_;
	}
	channel_sids_length1 = _tmp3__length1;
	dbus_message_iter_next (&iter);
	channel_sids = _tmp3_;
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp6_);
	result = dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (self, channel_sids, channel_sids_length1, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	channel_sids = (g_free (channel_sids), NULL);
	path = (g_free (path), NULL);
	_tmp7_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp7_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency;
	dbus_uint32_t _tmp8_;
	guint hierarchy;
	dbus_uint32_t _tmp9_;
	guint bandwidth;
	dbus_uint32_t _tmp10_;
	char* transmode;
	const char* _tmp11_;
	char* code_rate_hp;
	const char* _tmp12_;
	char* code_rate_lp;
	const char* _tmp13_;
	char* constellation;
	const char* _tmp14_;
	guint guard;
	dbus_uint32_t _tmp15_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuussssu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	frequency = _tmp8_;
	hierarchy = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	hierarchy = _tmp9_;
	bandwidth = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	bandwidth = _tmp10_;
	transmode = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	transmode = g_strdup (_tmp11_);
	code_rate_hp = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	code_rate_hp = g_strdup (_tmp12_);
	code_rate_lp = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	code_rate_lp = g_strdup (_tmp13_);
	constellation = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	constellation = g_strdup (_tmp14_);
	guard = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	guard = _tmp15_;
	dvb_id_bus_terrestrial_scanner_AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	transmode = (g_free (transmode), NULL);
	code_rate_hp = (g_free (code_rate_hp), NULL);
	code_rate_lp = (g_free (code_rate_lp), NULL);
	constellation = (g_free (constellation), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path;
	const char* _tmp16_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp17_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp16_);
	result = dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	path = (g_free (path), NULL);
	_tmp17_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp17_);
	return reply;
}


DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "Run")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "Destroy")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "WriteAllChannelsToFile")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_WriteAllChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "WriteChannelsToFile")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "AddScanningData")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "AddScanningDataFromFile")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp18_;
	dbus_uint32_t _tmp19_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp18_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp18_);
	_tmp19_ = freq_left;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp19_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_terrestrial_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_terrestrial_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp20_;
	dbus_uint32_t _tmp21_;
	const char* _tmp22_;
	const char* _tmp23_;
	const char* _tmp24_;
	dbus_bool_t _tmp25_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp20_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp20_);
	_tmp21_ = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp21_);
	_tmp22_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp22_);
	_tmp23_ = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp23_);
	_tmp24_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp24_);
	_tmp25_ = scrambled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp25_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_terrestrial_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_channel_added, connection);
}


static void dvb_id_bus_terrestrial_scanner_base_init (DVBIDBusTerrestrialScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_type_set_qdata (DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_terrestrial_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_terrestrial_scanner_get_type (void) {
	static GType dvb_id_bus_terrestrial_scanner_type_id = 0;
	if (dvb_id_bus_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusTerrestrialScannerIface), (GBaseInitFunc) dvb_id_bus_terrestrial_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_terrestrial_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusTerrestrialScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_terrestrial_scanner_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_terrestrial_scanner_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_terrestrial_scanner_dbus_proxy_get_type);
	}
	return dvb_id_bus_terrestrial_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusTerrestrialScannerDBusProxy, dvb_id_bus_terrestrial_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init));
DVBIDBusTerrestrialScanner* dvb_id_bus_terrestrial_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusTerrestrialScanner* self;
	self = g_object_new (dvb_id_bus_terrestrial_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Terrestrial", NULL);
	return self;
}


static GObject* dvb_id_bus_terrestrial_scanner_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_terrestrial_scanner_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_terrestrial_scanner_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp26_;
	guint freq_left;
	dbus_uint32_t _tmp27_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	frequency = _tmp26_;
	freq_left = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	freq_left = _tmp27_;
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_finished (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp28_;
	guint sid;
	dbus_uint32_t _tmp29_;
	const char* name;
	const char* _tmp30_;
	const char* network;
	const char* _tmp31_;
	const char* type;
	const char* _tmp32_;
	gboolean scrambled;
	dbus_bool_t _tmp33_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uusssb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	frequency = _tmp28_;
	sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp29_);
	dbus_message_iter_next (&iter);
	sid = _tmp29_;
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp30_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp30_);
	network = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp31_);
	dbus_message_iter_next (&iter);
	network = g_strdup (_tmp31_);
	type = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp32_);
	dbus_message_iter_next (&iter);
	type = g_strdup (_tmp32_);
	scrambled = FALSE;
	dbus_message_iter_get_basic (&iter, &_tmp33_);
	dbus_message_iter_next (&iter);
	scrambled = _tmp33_;
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
}


DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "FrequencyScanned")) {
			_dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "Finished")) {
			_dbus_handle_dvb_id_bus_terrestrial_scanner_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "ChannelAdded")) {
			_dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_terrestrial_scanner_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_terrestrial_scanner_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_class_init (DVBIDBusTerrestrialScannerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_terrestrial_scanner_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_terrestrial_scanner_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_terrestrial_scanner_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_terrestrial_scanner_dbus_proxy_set_property;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_init (DVBIDBusTerrestrialScannerDBusProxy* self) {
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Run (DVBIDBusTerrestrialScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy (DVBIDBusTerrestrialScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp34_;
	gboolean _result;
	dbus_bool_t _tmp35_;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "WriteAllChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp34_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp34_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp35_);
	dbus_message_iter_next (&_iter);
	_result = _tmp35_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, guint* channel_sids, int channel_sids_length1, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _tmp36_;
	DBusMessageIter _tmp37_;
	int _tmp38_;
	const char* _tmp40_;
	gboolean _result;
	dbus_bool_t _tmp41_;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp36_ = channel_sids;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "u", &_tmp37_);
	for (_tmp38_ = 0; _tmp38_ < channel_sids_length1; _tmp38_++) {
		dbus_uint32_t _tmp39_;
		_tmp39_ = *_tmp36_;
		dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_UINT32, &_tmp39_);
		_tmp36_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp37_);
	_tmp40_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp41_);
	dbus_message_iter_next (&_iter);
	_result = _tmp41_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp42_;
	dbus_uint32_t _tmp43_;
	dbus_uint32_t _tmp44_;
	const char* _tmp45_;
	const char* _tmp46_;
	const char* _tmp47_;
	const char* _tmp48_;
	dbus_uint32_t _tmp49_;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp42_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp42_);
	_tmp43_ = hierarchy;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp43_);
	_tmp44_ = bandwidth;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp44_);
	_tmp45_ = transmode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp45_);
	_tmp46_ = code_rate_hp;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp46_);
	_tmp47_ = code_rate_lp;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp47_);
	_tmp48_ = constellation;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	_tmp49_ = guard;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp49_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp50_;
	gboolean _result;
	dbus_bool_t _tmp51_;
	if (((DVBIDBusTerrestrialScannerDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp50_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp50_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp51_);
	dbus_message_iter_next (&_iter);
	_result = _tmp51_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init (DVBIDBusTerrestrialScannerIface* iface) {
	iface->Run = dvb_id_bus_terrestrial_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy;
	iface->WriteAllChannelsToFile = dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBTerrestrialScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device) {
	return dvb_terrestrial_scanner_construct (DVB_TYPE_TERRESTRIAL_SCANNER, device);
}


/**
          * See enums in MpegTsEnums
          */
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVBTerrestrialScanner * self;
	GstStructure* tuning_params;
	const GstStructure* _tmp0_;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (transmode != NULL);
	g_return_if_fail (code_rate_hp != NULL);
	g_return_if_fail (code_rate_lp != NULL);
	g_return_if_fail (constellation != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "hierarchy", G_TYPE_UINT, hierarchy, "bandwidth", G_TYPE_UINT, bandwidth, "transmission-mode", G_TYPE_STRING, transmode, "code-rate-hp", G_TYPE_STRING, code_rate_hp, "code-rate-lp", G_TYPE_STRING, code_rate_lp, "constellation", G_TYPE_STRING, constellation, "guard-interval", G_TYPE_UINT, guard, NULL);
	_tmp0_ = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0_ = tuning_params, (_tmp0_ == NULL) ? NULL : gst_structure_copy (_tmp0_)));
	(tuning_params == NULL) ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL));
}


static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path) {
	DVBTerrestrialScanner * self;
	gboolean result;
	GError * _inner_error_;
	GFile* datafile;
	char* contents;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("TerrestrialScanner.vala:84: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = dvb_utils_read_file_contents (datafile, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		_tmp1_ = NULL;
		contents = (_tmp1_ = _tmp0_, contents = (g_free (contents), NULL), _tmp1_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("TerrestrialScanner.vala:90: Could not read %s: %s", e->message, path);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (contents == NULL) {
		result = FALSE;
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		return result;
	}
	/* line looks like:
	 T freq bw fec_hi fec_lo mod transmission-mode guard-interval hierarchy*/
	{
		char** _tmp2_;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		_tmp2_ = NULL;
		line_collection = _tmp2_ = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp2_);
		for (line_it = 0; line_it < _vala_array_length (_tmp2_); line_it = line_it + 1) {
			const char* _tmp19_;
			char* line;
			_tmp19_ = NULL;
			line = (_tmp19_ = line_collection[line_it], (_tmp19_ == NULL) ? NULL : g_strdup (_tmp19_));
			{
				char* _tmp4_;
				const char* _tmp3_;
				char** _tmp6_;
				gint cols_size;
				gint cols_length1;
				char** _tmp5_;
				char** cols;
				gint cols_length;
				guint freq;
				guint hierarchy;
				const char* _tmp9_;
				gint _tmp8__length1;
				char** _tmp8_;
				char** _tmp7_;
				char* _tmp10_;
				char* bandwidth_str;
				guint bandwidth;
				const char* _tmp11_;
				char* transmode;
				const char* _tmp12_;
				char* code_rate_hp;
				const char* _tmp13_;
				char* code_rate_lp;
				const char* _tmp14_;
				char* constellation;
				const char* _tmp17_;
				gint _tmp16__length1;
				char** _tmp16_;
				char** _tmp15_;
				char* _tmp18_;
				char* guard_str;
				guint guard;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				line = (_tmp4_ = (_tmp3_ = g_strchug (line), (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_)), line = (g_free (line), NULL), _tmp4_);
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp6_ = NULL;
				_tmp5_ = NULL;
				cols = (_tmp6_ = _tmp5_ = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = _vala_array_length (_tmp5_), cols_size = cols_length1, _tmp6_);
				cols_length = 0;
				while (TRUE) {
					if (!(cols[cols_length] != NULL)) {
						break;
					}
					cols_length++;
				}
				cols_length++;
				if (cols_length < 9) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				hierarchy = (guint) 0;
				if (_vala_strcmp0 (cols[8], "1") == 0) {
					hierarchy = (guint) 1;
				} else {
					if (_vala_strcmp0 (cols[8], "2") == 0) {
						hierarchy = (guint) 2;
					} else {
						if (_vala_strcmp0 (cols[8], "4") == 0) {
							hierarchy = (guint) 3;
						}
					}
				}
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				_tmp7_ = NULL;
				_tmp10_ = NULL;
				bandwidth_str = (_tmp10_ = (_tmp9_ = (_tmp8_ = _tmp7_ = g_strsplit (cols[2], "MHz", 0), _tmp8__length1 = _vala_array_length (_tmp7_), _tmp8_)[0], (_tmp9_ == NULL) ? NULL : g_strdup (_tmp9_)), _tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL), _tmp10_);
				bandwidth = (guint) atoi (bandwidth_str);
				_tmp11_ = NULL;
				transmode = (_tmp11_ = cols[6], (_tmp11_ == NULL) ? NULL : g_strdup (_tmp11_));
				_tmp12_ = NULL;
				code_rate_hp = (_tmp12_ = cols[3], (_tmp12_ == NULL) ? NULL : g_strdup (_tmp12_));
				_tmp13_ = NULL;
				code_rate_lp = (_tmp13_ = cols[4], (_tmp13_ == NULL) ? NULL : g_strdup (_tmp13_));
				_tmp14_ = NULL;
				constellation = (_tmp14_ = cols[5], (_tmp14_ == NULL) ? NULL : g_strdup (_tmp14_));
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				_tmp18_ = NULL;
				guard_str = (_tmp18_ = (_tmp17_ = (_tmp16_ = _tmp15_ = g_strsplit (cols[7], "/", 0), _tmp16__length1 = _vala_array_length (_tmp15_), _tmp16_)[1], (_tmp17_ == NULL) ? NULL : g_strdup (_tmp17_)), _tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL), _tmp18_);
				guard = (guint) atoi (guard_str);
				dvb_id_bus_terrestrial_scanner_AddScanningData ((DVBIDBusTerrestrialScanner*) self, freq, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				bandwidth_str = (g_free (bandwidth_str), NULL);
				transmode = (g_free (transmode), NULL);
				code_rate_hp = (g_free (code_rate_hp), NULL);
				code_rate_lp = (g_free (code_rate_lp), NULL);
				constellation = (g_free (constellation), NULL);
				guard_str = (g_free (guard_str), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
	contents = (g_free (contents), NULL);
	return result;
}


static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	GstElement* dvbsrc;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp0_;
	char* constellation;
	guint guard;
	const char* _tmp1_;
	char* transmode;
	self = (DVBTerrestrialScanner*) base;
	g_debug ("TerrestrialScanner.vala:142: Setting up pipeline for DVB-T scan");
	dvbsrc = gst_bin_get_by_name (GST_BIN (DVB_SCANNER (self)->pipeline), "dvbsrc");
	dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, "frequency");
	bandwidth = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "bandwidth", &bandwidth);
	g_object_set ((GObject*) dvbsrc, "bandwidth", dvb_get_bandwidth_val (bandwidth), NULL);
	hierarchy = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "hierarchy", &hierarchy);
	g_object_set ((GObject*) dvbsrc, "hierarchy", dvb_get_hierarchy_val (hierarchy), NULL);
	_tmp0_ = NULL;
	constellation = (_tmp0_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "constellation"), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	g_object_set ((GObject*) dvbsrc, "modulation", dvb_get_modulation_val (constellation), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-hp")), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-lp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-lp")), NULL);
	guard = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "guard-interval", &guard);
	g_object_set ((GObject*) dvbsrc, "guard", dvb_get_guard_interval_val (guard), NULL);
	_tmp1_ = NULL;
	transmode = (_tmp1_ = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "transmission-mode"), (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	g_object_set ((GObject*) dvbsrc, "trans-mode", dvb_get_transmission_mode_val (transmode), NULL);
	(dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBTerrestrialScanner * self;
	DVBScannedItem* result;
	guint freq;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	result = dvb_scanned_item_new (freq);
	return result;
}


static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	DVBChannel* result;
	self = (DVBTerrestrialScanner*) base;
	result = (DVBChannel*) dvb_terrestrial_channel_new ();
	return result;
}


static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBTerrestrialScanner * self;
	DVBTerrestrialChannel* _tmp0_;
	DVBTerrestrialChannel* tc;
	guint freq;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp1_;
	char* constellation;
	guint guard;
	const char* _tmp2_;
	char* transmode;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_TERRESTRIAL_CHANNEL (channel)) {
		return;
	}
	_tmp0_ = NULL;
	tc = (_tmp0_ = DVB_TERRESTRIAL_CHANNEL (channel), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	/* structure doesn't contain information about inversion
	 set it to auto*/
	dvb_terrestrial_channel_set_Inversion (tc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) tc, freq);
	bandwidth = 0U;
	gst_structure_get_uint (delivery, "bandwidth", &bandwidth);
	dvb_terrestrial_channel_set_Bandwidth (tc, dvb_get_bandwidth_val (bandwidth));
	hierarchy = 0U;
	gst_structure_get_uint (delivery, "hierarchy", &hierarchy);
	dvb_terrestrial_channel_set_Hierarchy (tc, dvb_get_hierarchy_val (hierarchy));
	_tmp1_ = NULL;
	constellation = (_tmp1_ = gst_structure_get_string (delivery, "constellation"), (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	dvb_terrestrial_channel_set_Constellation (tc, dvb_get_modulation_val (constellation));
	dvb_terrestrial_channel_set_CodeRateHP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-hp")));
	dvb_terrestrial_channel_set_CodeRateLP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-lp")));
	guard = 0U;
	gst_structure_get_uint (delivery, "guard-interval", &guard);
	dvb_terrestrial_channel_set_GuardInterval (tc, dvb_get_guard_interval_val (guard));
	_tmp2_ = NULL;
	transmode = (_tmp2_ = gst_structure_get_string (delivery, "transmission-mode"), (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	dvb_terrestrial_channel_set_TransmissionMode (tc, dvb_get_transmission_mode_val (transmode));
	(tc == NULL) ? NULL : (tc = (g_object_unref (tc), NULL));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


void _dvb_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_terrestrial_scanner_introspect (DVBTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Terrestrial\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"hierarchy\" type=\"u\" direction=\"in\"/>\n    <arg name=\"bandwidth\" type=\"u\" direction=\"in\"/>\n    <arg name=\"transmode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_hp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_lp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"constellation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"guard\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_terrestrial_scanner_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_terrestrial_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_terrestrial_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_terrestrial_scanner_dbus_register_object (connection, path, object);
}


static void dvb_terrestrial_scanner_class_init (DVBTerrestrialScannerClass * klass) {
	dvb_terrestrial_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_terrestrial_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_terrestrial_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_terrestrial_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_terrestrial_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_TERRESTRIAL_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_terrestrial_scanner_dbus_vtable));
}


static void dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init (DVBIDBusTerrestrialScannerIface * iface) {
	dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_terrestrial_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_terrestrial_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
}


static void dvb_terrestrial_scanner_instance_init (DVBTerrestrialScanner * self) {
}


GType dvb_terrestrial_scanner_get_type (void) {
	static GType dvb_terrestrial_scanner_type_id = 0;
	if (dvb_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialScanner), 0, (GInstanceInitFunc) dvb_terrestrial_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_terrestrial_scanner_info = { (GInterfaceInitFunc) dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_terrestrial_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBTerrestrialScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_terrestrial_scanner_type_id, DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, &dvb_id_bus_terrestrial_scanner_info);
	}
	return dvb_terrestrial_scanner_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



