/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define DVB_TYPE_CONFIG_STORE (dvb_config_store_get_type ())
#define DVB_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStore))
#define DVB_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CONFIG_STORE))
#define DVB_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStoreIface))

typedef struct _DVBConfigStore DVBConfigStore;
typedef struct _DVBConfigStoreIface DVBConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

struct _DVBConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBConfigStore* self);
	gboolean (*add_device_group) (DVBConfigStore* self, DVBDeviceGroup* dev_group);
	gboolean (*remove_device_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
	gboolean (*add_device_to_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	gboolean (*remove_device_from_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	gboolean (*update_from_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
};



GType dvb_device_group_get_type (void);
GType dvb_device_get_type (void);
GType dvb_config_store_get_type (void);
GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self);
gboolean dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group);
gboolean dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup);
gboolean dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
gboolean dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
gboolean dvb_config_store_update_from_group (DVBConfigStore* self, DVBDeviceGroup* devgroup);



GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->get_all_device_groups (self);
}


gboolean dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_group (self, dev_group);
}


gboolean dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_group (self, devgroup);
}


gboolean dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_to_group (self, dev, devgroup);
}


gboolean dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_from_group (self, dev, devgroup);
}


gboolean dvb_config_store_update_from_group (DVBConfigStore* self, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->update_from_group (self, devgroup);
}


static void dvb_config_store_base_init (DVBConfigStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_config_store_get_type (void) {
	static GType dvb_config_store_type_id = 0;
	if (dvb_config_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBConfigStoreIface), (GBaseInitFunc) dvb_config_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_config_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBConfigStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_config_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_config_store_type_id;
}




