/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_CHANNELLISTREADER_H__
#define __SRC_CHANNELLISTREADER_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "src/Device.h"
#include "src/ChannelList.h"

G_BEGIN_DECLS


#define DVB_TYPE_CHANNEL_LIST_READER (dvb_channel_list_reader_get_type ())
#define DVB_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST_READER, DVBChannelListReader))
#define DVB_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST_READER, DVBChannelListReaderClass))
#define DVB_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST_READER))
#define DVB_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST_READER))
#define DVB_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST_READER, DVBChannelListReaderClass))

typedef struct _DVBChannelListReader DVBChannelListReader;
typedef struct _DVBChannelListReaderClass DVBChannelListReaderClass;
typedef struct _DVBChannelListReaderPrivate DVBChannelListReaderPrivate;

struct _DVBChannelListReader {
	GObject parent_instance;
	DVBChannelListReaderPrivate * priv;
};

struct _DVBChannelListReaderClass {
	GObjectClass parent_class;
};


DVBChannelListReader* dvb_channel_list_reader_construct (GType object_type, GFile* file, DVBAdapterType type, guint group_id);
DVBChannelListReader* dvb_channel_list_reader_new (GFile* file, DVBAdapterType type, guint group_id);
DVBChannelList* dvb_channel_list_reader_read (DVBChannelListReader* self, GError** error);
GFile* dvb_channel_list_reader_get_ChannelFile (DVBChannelListReader* self);
DVBAdapterType dvb_channel_list_reader_get_Type (DVBChannelListReader* self);
guint dvb_channel_list_reader_get_GroupId (DVBChannelListReader* self);
GType dvb_channel_list_reader_get_type (void);


G_END_DECLS

#endif
