#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))

#include <src/Recorder.h>
#include <gee/hashmap.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gst/gst.h>
#include <time.h>
#include <gee/collection.h>
#include <gee/hashset.h>
#include "src/ChannelList.h"
#include "src/RecordingsStore.h"
#include "src/Channel.h"
#include "src/Factory.h"
#include "src/TimersStore.h"
#include "src/ChangeType.h"
#include "src/Utils.h"
#include "src/Schedule.h"
#include "src/Event.h"
#include "src/Manager.h"
#include "src/EPGStore.h"

typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



struct _DVBRecordingThreadPrivate {
	DVBDevice* _device;
	DVBEPGScanner* _epgscanner;
	GstElement* pipeline;
	char* sid;
	GeeMap* recordings;
};

#define DVB_RECORDING_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDING_THREAD, DVBRecordingThreadPrivate))
enum  {
	DVB_RECORDING_THREAD_DUMMY_PROPERTY,
	DVB_RECORDING_THREAD_DEVICE,
	DVB_RECORDING_THREAD_EPGSCANNER,
	DVB_RECORDING_THREAD_COUNT
};
#define DVB_RECORDING_THREAD_DVBBASEBIN_NAME "dvbbasebin"
static void dvb_recording_thread_reset (DVBRecordingThread* self);
static void _g_slist_free_g_free (GSList* self);
static void _dvb_recording_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void _dvb_recording_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static GstElement* dvb_recording_thread_add_new_filesink (DVBRecordingThread* self, const char* sink_name, const char* location);
static GstElement* dvb_recording_thread_add_new_queue (DVBRecordingThread* self, const char* queue_name);
static void dvb_recording_thread_on_dvbbasebin_pad_added (DVBRecordingThread* self, GstElement* elem, GstPad* pad);
static void dvb_recording_thread_bus_watch_func (DVBRecordingThread* self, GstBus* bus, GstMessage* message);
static void dvb_recording_thread_on_eit_structure (DVBRecordingThread* self, const GstStructure* structure);
static void dvb_recording_thread_set_device (DVBRecordingThread* self, DVBDevice* value);
static void dvb_recording_thread_set_epgscanner (DVBRecordingThread* self, DVBEPGScanner* value);
static GObject * dvb_recording_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_recording_thread_parent_class = NULL;
static void dvb_recording_thread_finalize (GObject* obj);
struct _DVBRecorderPrivate {
	DVBDeviceGroup* _DeviceGroup;
	gboolean have_check_timers_timeout;
	GStaticRecMutex __lock_timers;
	GeeHashMap* timers;
};

#define DVB_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDER, DVBRecorderPrivate))
enum  {
	DVB_RECORDER_DUMMY_PROPERTY,
	DVB_RECORDER_DEVICE_GROUP
};
#define DVB_RECORDER_CHECK_TIMERS_INTERVAL 5
static guint32 dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self);
static guint32 dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid);
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id);
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1);
static guint32* dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, int* result_length1);
static guint* dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, int* result_length1);
static guint dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id);
static char* dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id);
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1);
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id);
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static void _dvb_recorder_on_recording_stopped_dvb_recording_thread_recording_stopped (DVBRecordingThread* _sender, DVBRecording* rec, DVBTimer* timer, gpointer self);
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1);
static void _g_slist_free_g_object_unref (GSList* self);
static gboolean dvb_recorder_check_timers (DVBRecorder* self);
static void dvb_recorder_on_recording_stopped (DVBRecorder* self, DVBRecordingThread* recthread, DVBRecording* recording, DVBTimer* timer);
static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value);
static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_recorder_parent_class = NULL;
void _dvb_recorder_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_recorder_introspect (DVBRecorder* self, DBusConnection* connection, DBusMessage* message);
static DVBIDBusRecorderIface* dvb_recorder_dvb_id_bus_recorder_parent_iface = NULL;
static void dvb_recorder_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_recorder_dbus_path_vtable = {_dvb_recorder_dbus_unregister, dvb_recorder_dbus_message};
static const _DBusObjectVTable _dvb_recorder_dbus_vtable = {dvb_recorder_dbus_register_object};

static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

DVBRecordingThread* dvb_recording_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner) {
	GParameter * __params;
	GParameter * __params_it;
	DVBRecordingThread * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	__params_it->name = "epgscanner";
	g_value_init (&__params_it->value, DVB_TYPE_EPG_SCANNER);
	g_value_set_object (&__params_it->value, epgscanner);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBRecordingThread* dvb_recording_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner) {
	return dvb_recording_thread_construct (DVB_TYPE_RECORDING_THREAD, device, epgscanner);
}


static void dvb_recording_thread_reset (DVBRecordingThread* self) {
	GstElement* _tmp0;
	g_return_if_fail (self != NULL);
	if (self->priv->pipeline != NULL) {
		GstBus* bus;
		g_debug ("Recorder.vala:41: Stopping pipeline");
		bus = gst_element_get_bus (self->priv->pipeline);
		gst_bus_remove_signal_watch (bus);
		gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
		(bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL));
	}
	_tmp0 = NULL;
	self->priv->pipeline = (_tmp0 = NULL, (self->priv->pipeline == NULL) ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL)), _tmp0);
	gee_map_clear (self->priv->recordings);
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


void dvb_recording_thread_stop_recording (DVBRecordingThread* self, DVBTimer* timer) {
	GError * inner_error;
	char* sink_name;
	GstElement* sink;
	char* location;
	DVBRecording* rec;
	struct tm _tmp10 = {0};
	struct tm _tmp9 = {0};
	time_t _tmp7 = {0};
	time_t _tmp5 = {0};
	struct tm _tmp6 = {0};
	struct tm _tmp8 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	inner_error = NULL;
	sink_name = g_strdup_printf ("sink_%u", dvb_timer_get_ChannelSid (timer));
	sink = gst_bin_get_by_name ((GST_BIN (self->priv->pipeline)), sink_name);
	location = NULL;
	g_object_get ((GObject*) sink, "location", &location, NULL);
	if (dvb_recording_thread_get_count (self) > 1) {
		GstElement* dvbbasebin;
		char* programs;
		char** _tmp1;
		gint programs_arr_size;
		gint programs_arr_length1;
		char** _tmp0;
		char** programs_arr;
		char* channel_sid_string;
		GSList* new_programs_list;
		GString* new_programs;
		/* Still have other recordings,
		 just remove sid from program-numbers*/
		dvbbasebin = gst_bin_get_by_name ((GST_BIN (self->priv->pipeline)), DVB_RECORDING_THREAD_DVBBASEBIN_NAME);
		if (dvbbasebin == NULL) {
			g_critical ("Recorder.vala:63: No element with name %s", DVB_RECORDING_THREAD_DVBBASEBIN_NAME);
			(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
			sink_name = (g_free (sink_name), NULL);
			(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
			location = (g_free (location), NULL);
			return;
		}
		programs = NULL;
		g_object_get ((GObject*) dvbbasebin, "program-numbers", &programs, NULL);
		_tmp1 = NULL;
		_tmp0 = NULL;
		programs_arr = (_tmp1 = _tmp0 = g_strsplit (programs, ":", 0), programs_arr_length1 = _vala_array_length (_tmp0), programs_arr_size = programs_arr_length1, _tmp1);
		channel_sid_string = g_strdup_printf ("%u", dvb_timer_get_ChannelSid (timer));
		new_programs_list = NULL;
		{
			gint i;
			i = 0;
			for (; i < programs_arr_length1; i++) {
				const char* _tmp2;
				char* val;
				_tmp2 = NULL;
				val = (_tmp2 = programs_arr[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
				if (_vala_strcmp0 (val, channel_sid_string) != 0) {
					const char* _tmp3;
					_tmp3 = NULL;
					new_programs_list = g_slist_prepend (new_programs_list, (_tmp3 = val, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)));
				}
				val = (g_free (val), NULL);
			}
		}
		new_programs = g_string_new ((const char*) g_slist_nth_data (new_programs_list, (guint) 0));
		{
			gint i;
			i = 1;
			for (; i < g_slist_length (new_programs_list); i++) {
				char* _tmp4;
				_tmp4 = NULL;
				g_string_append (new_programs, _tmp4 = g_strconcat (":", (const char*) g_slist_nth_data (new_programs_list, (guint) i), NULL));
				_tmp4 = (g_free (_tmp4), NULL);
			}
		}
		gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
		g_object_set ((GObject*) dvbbasebin, "program-numbers", new_programs->str, NULL);
		gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
		(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
		programs = (g_free (programs), NULL);
		programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
		channel_sid_string = (g_free (channel_sid_string), NULL);
		(new_programs_list == NULL) ? NULL : (new_programs_list = (_g_slist_free_g_free (new_programs_list), NULL));
		(new_programs == NULL) ? NULL : (new_programs = (g_string_free (new_programs, TRUE), NULL));
	}
	rec = (DVBRecording*) gee_map_get (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_timer_get_Id (timer)));
	dvb_recording_set_Length (rec, dvb_utils_difftime ((_tmp9 = (localtime_r ((_tmp7 = (time (&_tmp5), _tmp5), &_tmp7), &_tmp6), _tmp6), &_tmp9), (_tmp10 = (dvb_recording_get_StartTime (rec, &_tmp8), _tmp8), &_tmp10)));
	{
		dvb_recording_save_to_disk (rec, &inner_error);
		if (inner_error != NULL) {
			goto __catch9_g_error;
			goto __finally9;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical ("Recorder.vala:96: Could not save recording: %s", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally9:
	if (inner_error != NULL) {
		sink_name = (g_free (sink_name), NULL);
		(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
		location = (g_free (location), NULL);
		(rec == NULL) ? NULL : (rec = (g_object_unref (rec), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	gee_map_remove (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_timer_get_Id (timer)));
	if (dvb_recording_thread_get_count (self) == 0) {
		/* No more active recordings*/
		dvb_recording_thread_reset (self);
	}
	g_signal_emit_by_name (self, "recording-stopped", rec, timer);
	sink_name = (g_free (sink_name), NULL);
	(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	location = (g_free (location), NULL);
	(rec == NULL) ? NULL : (rec = (g_object_unref (rec), NULL));
}


static void _dvb_recording_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_recording_thread_bus_watch_func (self, _sender, message);
}


static void _dvb_recording_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_recording_thread_on_dvbbasebin_pad_added (self, _sender, pad);
}


void dvb_recording_thread_start_recording (DVBRecordingThread* self, DVBTimer* timer, GFile* location) {
	guint channel_sid;
	char* _tmp0;
	char* sink_name;
	DVBRecording* recording;
	struct tm _tmp10 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	g_return_if_fail (location != NULL);
	channel_sid = dvb_timer_get_ChannelSid (timer);
	_tmp0 = NULL;
	self->priv->sid = (_tmp0 = g_strdup_printf ("%u", channel_sid), self->priv->sid = (g_free (self->priv->sid), NULL), _tmp0);
	sink_name = g_strdup_printf ("sink_%u", channel_sid);
	g_debug ("Recorder.vala:114: Starting recording of channel %u", channel_sid);
	if (self->priv->pipeline == NULL) {
		GstElement* dvbbasebin;
		DVBChannel* channel;
		GstElement* _tmp1;
		GstBus* bus;
		GstElement* _tmp2;
		char* queue_name;
		GstElement* queue;
		char* _tmp3;
		GstElement* _tmp4;
		GstElement* filesink;
		gboolean _tmp5;
		/* Setup new pipeline*/
		dvbbasebin = gst_element_factory_make ("dvbbasebin", DVB_RECORDING_THREAD_DVBBASEBIN_NAME);
		if (dvbbasebin == NULL) {
			g_critical ("Recorder.vala:123: Could not create dvbbasebin element");
			(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
			sink_name = (g_free (sink_name), NULL);
			return;
		}
		channel = dvb_channel_list_get (dvb_device_get_Channels (self->priv->_device), channel_sid);
		dvb_channel_setup_dvb_source (channel, dvbbasebin);
		_tmp1 = NULL;
		self->priv->pipeline = (_tmp1 = (GstElement*) ((GstPipeline*) gst_pipeline_new ("recording")), (self->priv->pipeline == NULL) ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL)), _tmp1);
		bus = gst_element_get_bus (self->priv->pipeline);
		gst_bus_add_signal_watch (bus);
		g_signal_connect_object (bus, "message", (GCallback) _dvb_recording_thread_bus_watch_func_gst_bus_message, self, 0);
		g_signal_connect_object (dvbbasebin, "pad-added", (GCallback) _dvb_recording_thread_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
		g_object_set ((GObject*) dvbbasebin, "program-numbers", self->priv->sid, NULL);
		g_object_set ((GObject*) dvbbasebin, "adapter", dvb_device_get_Adapter (self->priv->_device), NULL);
		g_object_set ((GObject*) dvbbasebin, "frontend", dvb_device_get_Frontend (self->priv->_device), NULL);
		/* don't use add_many because of problems with ownership transfer    */
		_tmp2 = NULL;
		gst_bin_add ((GST_BIN (self->priv->pipeline)), (_tmp2 = dvbbasebin, (_tmp2 == NULL) ? NULL : gst_object_ref (_tmp2)));
		queue_name = g_strdup_printf ("queue_%u", channel_sid);
		queue = dvb_recording_thread_add_new_queue (self, queue_name);
		_tmp3 = NULL;
		_tmp4 = NULL;
		filesink = (_tmp4 = dvb_recording_thread_add_new_filesink (self, sink_name, _tmp3 = g_file_get_path (location)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
		_tmp5 = FALSE;
		if (queue != NULL) {
			_tmp5 = filesink != NULL;
		} else {
			_tmp5 = FALSE;
		}
		if (_tmp5) {
			if (!gst_element_link (queue, filesink)) {
				g_critical ("Recorder.vala:151: Could not link queue and filesink");
				(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
				(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
				(bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL));
				queue_name = (g_free (queue_name), NULL);
				(queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL));
				(filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL));
				sink_name = (g_free (sink_name), NULL);
				return;
			}
			g_debug ("Recorder.vala:155: Starting pipeline");
			gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
		}
		(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
		(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
		(bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL));
		queue_name = (g_free (queue_name), NULL);
		(queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL));
		(filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL));
	} else {
		GstElement* dvbbasebin;
		char* queue_name;
		GstElement* queue;
		char* _tmp6;
		GstElement* _tmp7;
		GstElement* filesink;
		gboolean _tmp8;
		/* Use current pipeline and add new filesink*/
		dvbbasebin = gst_bin_get_by_name ((GST_BIN (self->priv->pipeline)), DVB_RECORDING_THREAD_DVBBASEBIN_NAME);
		if (dvbbasebin == NULL) {
			g_critical ("Recorder.vala:163: No element with name %s", DVB_RECORDING_THREAD_DVBBASEBIN_NAME);
			(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
			sink_name = (g_free (sink_name), NULL);
			return;
		}
		queue_name = g_strdup_printf ("queue_%u", channel_sid);
		queue = dvb_recording_thread_add_new_queue (self, queue_name);
		_tmp6 = NULL;
		_tmp7 = NULL;
		filesink = (_tmp7 = dvb_recording_thread_add_new_filesink (self, sink_name, _tmp6 = g_file_get_path (location)), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
		_tmp8 = FALSE;
		if (queue != NULL) {
			_tmp8 = filesink != NULL;
		} else {
			_tmp8 = FALSE;
		}
		if (_tmp8) {
			char* programs;
			char* _tmp9;
			if (!gst_element_link (queue, filesink)) {
				g_critical ("Recorder.vala:174: Could not link queue and filesink");
				(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
				queue_name = (g_free (queue_name), NULL);
				(queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL));
				(filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL));
				sink_name = (g_free (sink_name), NULL);
				return;
			}
			programs = NULL;
			gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
			g_object_get ((GObject*) dvbbasebin, "program-numbers", &programs, NULL);
			_tmp9 = NULL;
			g_object_set ((GObject*) dvbbasebin, "program-numbers", _tmp9 = g_strdup_printf ("%s:%s", programs, self->priv->sid), NULL);
			_tmp9 = (g_free (_tmp9), NULL);
			gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
			programs = (g_free (programs), NULL);
		}
		(dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL));
		queue_name = (g_free (queue_name), NULL);
		(queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL));
		(filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL));
	}
	recording = dvb_recording_new ();
	dvb_recording_set_Name (recording, NULL);
	dvb_recording_set_Description (recording, NULL);
	dvb_recording_set_Id (recording, dvb_timer_get_Id (timer));
	dvb_recording_set_ChannelSid (recording, dvb_timer_get_ChannelSid (timer));
	dvb_recording_set_StartTime (recording, (_tmp10 = dvb_timer_get_start_time_time (timer), &_tmp10));
	dvb_recording_set_Location (recording, location);
	gee_map_set (self->priv->recordings, GUINT_TO_POINTER ((guint) dvb_recording_get_Id (recording)), recording);
	dvb_recordings_store_add (dvb_recordings_store_get_instance (), recording);
	sink_name = (g_free (sink_name), NULL);
	(recording == NULL) ? NULL : (recording = (g_object_unref (recording), NULL));
}


static GstElement* dvb_recording_thread_add_new_filesink (DVBRecordingThread* self, const char* sink_name, const char* location) {
	GstElement* filesink;
	GstElement* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink_name != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	filesink = gst_element_factory_make ("filesink", sink_name);
	if (filesink == NULL) {
		GstElement* _tmp0;
		g_critical ("Recorder.vala:203: Could not create filesink element");
		_tmp0 = NULL;
		return (_tmp0 = NULL, (filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL)), _tmp0);
	}
	g_object_set ((GObject*) filesink, "location", location, NULL);
	_tmp1 = NULL;
	if (!gst_bin_add ((GST_BIN (self->priv->pipeline)), (_tmp1 = filesink, (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)))) {
		GstElement* _tmp2;
		g_critical ("Recorder.vala:208: Could not add filesink sink %s", sink_name);
		_tmp2 = NULL;
		return (_tmp2 = NULL, (filesink == NULL) ? NULL : (filesink = (gst_object_unref (filesink), NULL)), _tmp2);
	}
	g_debug ("Recorder.vala:211: Filesink %s added to pipeline", sink_name);
	return filesink;
}


static GstElement* dvb_recording_thread_add_new_queue (DVBRecordingThread* self, const char* queue_name) {
	GstElement* queue;
	GstElement* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (queue_name != NULL, NULL);
	queue = gst_element_factory_make ("queue", queue_name);
	if (queue == NULL) {
		GstElement* _tmp0;
		g_critical ("Recorder.vala:218: Could not create queue element");
		_tmp0 = NULL;
		return (_tmp0 = NULL, (queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL)), _tmp0);
	}
	g_object_set ((GObject*) queue, "max-size-buffers", 0, NULL);
	/*queue.set ("max-size-time", 0);*/
	_tmp1 = NULL;
	if (!gst_bin_add ((GST_BIN (self->priv->pipeline)), (_tmp1 = queue, (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)))) {
		GstElement* _tmp2;
		g_critical ("Recorder.vala:225: Could not add queue element to pipeline %s", queue_name);
		_tmp2 = NULL;
		return (_tmp2 = NULL, (queue == NULL) ? NULL : (queue = (gst_object_unref (queue), NULL)), _tmp2);
	}
	g_debug ("Recorder.vala:229: Queue %s added to pipeline", queue_name);
	return queue;
}


static void dvb_recording_thread_on_dvbbasebin_pad_added (DVBRecordingThread* self, GstElement* elem, GstPad* pad) {
	char* _tmp0;
	char* program;
	char* _tmp1;
	gboolean _tmp2;
	char* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0 = NULL;
	g_debug ("Recorder.vala:234: Pad %s added", _tmp0 = gst_object_get_name ((GstObject*) pad));
	_tmp0 = (g_free (_tmp0), NULL);
	program = g_strconcat ("program_", self->priv->sid, NULL);
	_tmp1 = NULL;
	if ((_tmp2 = _vala_strcmp0 (_tmp1 = gst_object_get_name ((GstObject*) pad), program) == 0, _tmp1 = (g_free (_tmp1), NULL), _tmp2)) {
		char* sink_name;
		GstElement* sink;
		sink_name = g_strconcat ("queue_", self->priv->sid, NULL);
		sink = gst_bin_get_by_name ((GST_BIN (self->priv->pipeline)), sink_name);
		if (sink == NULL) {
			g_critical ("Recorder.vala:241: No element with name %s", sink_name);
		} else {
			GstPad* _tmp3;
			GstPad* sinkpad;
			GstPadLinkReturn rc;
			_tmp3 = NULL;
			sinkpad = (_tmp3 = gst_element_get_pad (sink, "sink"), (_tmp3 == NULL) ? NULL : gst_object_ref (_tmp3));
			rc = gst_pad_link (pad, sinkpad);
			if (rc != GST_PAD_LINK_OK) {
				g_critical ("Recorder.vala:247: Could not link pads");
			}
			g_debug ("Recorder.vala:249: Src pad %s linked with sink pad %s", program, sink_name);
			(sinkpad == NULL) ? NULL : (sinkpad = (gst_object_unref (sinkpad), NULL));
		}
		sink_name = (g_free (sink_name), NULL);
		(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	}
	_tmp4 = NULL;
	self->priv->sid = (_tmp4 = NULL, self->priv->sid = (g_free (self->priv->sid), NULL), _tmp4);
	program = (g_free (program), NULL);
}


static void dvb_recording_thread_bus_watch_func (DVBRecordingThread* self, GstBus* bus, GstMessage* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			const char* _tmp0;
			char* structure_name;
			_tmp0 = NULL;
			structure_name = (_tmp0 = gst_structure_get_name (message->structure), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
			if (_vala_strcmp0 (structure_name, "dvb-read-failure") == 0) {
				g_critical ("Recorder.vala:262: Could not read from DVB device");
				dvb_recording_thread_reset (self);
				g_signal_emit_by_name (self, "recording-aborted");
			} else {
				if (_vala_strcmp0 (structure_name, "eit") == 0) {
					dvb_recording_thread_on_eit_structure (self, message->structure);
				}
			}
			structure_name = (g_free (structure_name), NULL);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror;
			char* debug_text;
			char* _tmp4;
			char* _tmp3;
			GError* _tmp2;
			GError* _tmp1;
			gerror = NULL;
			debug_text = NULL;
			_tmp4 = NULL;
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			(gst_message_parse_error (message, &_tmp1, &_tmp3), gerror = (_tmp2 = _tmp1, (gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL)), _tmp2));
			debug_text = (_tmp4 = _tmp3, debug_text = (g_free (debug_text), NULL), _tmp4);
			g_critical ("Recorder.vala:275: Error tuning: %s; %s", gerror->message, debug_text);
			dvb_recording_thread_reset (self);
			g_signal_emit_by_name (self, "recording-aborted");
			(gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL));
			debug_text = (g_free (debug_text), NULL);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void dvb_recording_thread_on_eit_structure (DVBRecordingThread* self, const GstStructure* structure) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	if (self->priv->_epgscanner != NULL) {
		dvb_epg_scanner_on_eit_structure (self->priv->_epgscanner, structure);
	}
	/* Find name and description for recordings*/
	{
		GeeCollection* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _rec_it;
		/* Find name and description for recordings*/
		_tmp0 = NULL;
		_tmp1 = NULL;
		_rec_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_values (self->priv->recordings))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
		/* Find name and description for recordings*/
		while (gee_iterator_next (_rec_it)) {
			DVBRecording* rec;
			/* Find name and description for recordings*/
			rec = (DVBRecording*) gee_iterator_get (_rec_it);
			if (dvb_recording_get_Name (rec) == NULL) {
				DVBChannel* chan;
				DVBSchedule* _tmp2;
				DVBSchedule* sched;
				DVBEvent* event;
				chan = dvb_channel_list_get (dvb_device_get_Channels (self->priv->_device), dvb_recording_get_ChannelSid (rec));
				_tmp2 = NULL;
				sched = (_tmp2 = dvb_channel_get_Schedule (chan), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2));
				event = dvb_schedule_get_running_event (sched);
				if (event != NULL) {
					char* _tmp3;
					g_debug ("Recorder.vala:298: Found running event for active recording");
					dvb_recording_set_Name (rec, event->name);
					_tmp3 = NULL;
					dvb_recording_set_Description (rec, _tmp3 = g_strdup_printf ("%s\n%s", event->description, event->extended_description));
					_tmp3 = (g_free (_tmp3), NULL);
				}
				(chan == NULL) ? NULL : (chan = (g_object_unref (chan), NULL));
				(sched == NULL) ? NULL : (sched = (g_object_unref (sched), NULL));
				(event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL));
			}
			(rec == NULL) ? NULL : (rec = (g_object_unref (rec), NULL));
		}
		(_rec_it == NULL) ? NULL : (_rec_it = (g_object_unref (_rec_it), NULL));
	}
}


DVBDevice* dvb_recording_thread_get_device (DVBRecordingThread* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_device;
}


static void dvb_recording_thread_set_device (DVBRecordingThread* self, DVBDevice* value) {
	DVBDevice* _tmp2;
	DVBDevice* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_device = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_device == NULL) ? NULL : (self->priv->_device = (g_object_unref (self->priv->_device), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "device");
}


DVBEPGScanner* dvb_recording_thread_get_epgscanner (DVBRecordingThread* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_epgscanner;
}


static void dvb_recording_thread_set_epgscanner (DVBRecordingThread* self, DVBEPGScanner* value) {
	DVBEPGScanner* _tmp2;
	DVBEPGScanner* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_epgscanner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_epgscanner == NULL) ? NULL : (self->priv->_epgscanner = (g_object_unref (self->priv->_epgscanner), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "epgscanner");
}


guint dvb_recording_thread_get_count (DVBRecordingThread* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return (guint) gee_map_get_size (self->priv->recordings);
}


static GObject * dvb_recording_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBRecordingThreadClass * klass;
	GObjectClass * parent_class;
	DVBRecordingThread * self;
	klass = DVB_RECORDING_THREAD_CLASS (g_type_class_peek (DVB_TYPE_RECORDING_THREAD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDING_THREAD (obj);
	{
		GeeMap* _tmp0;
		_tmp0 = NULL;
		self->priv->recordings = (_tmp0 = (GeeMap*) gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->recordings == NULL) ? NULL : (self->priv->recordings = (g_object_unref (self->priv->recordings), NULL)), _tmp0);
	}
	return obj;
}


static void dvb_recording_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecordingThread * self;
	gpointer boxed;
	self = DVB_RECORDING_THREAD (object);
	switch (property_id) {
		case DVB_RECORDING_THREAD_DEVICE:
		g_value_set_object (value, dvb_recording_thread_get_device (self));
		break;
		case DVB_RECORDING_THREAD_EPGSCANNER:
		g_value_set_object (value, dvb_recording_thread_get_epgscanner (self));
		break;
		case DVB_RECORDING_THREAD_COUNT:
		g_value_set_uint (value, dvb_recording_thread_get_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecordingThread * self;
	self = DVB_RECORDING_THREAD (object);
	switch (property_id) {
		case DVB_RECORDING_THREAD_DEVICE:
		dvb_recording_thread_set_device (self, g_value_get_object (value));
		break;
		case DVB_RECORDING_THREAD_EPGSCANNER:
		dvb_recording_thread_set_epgscanner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_thread_class_init (DVBRecordingThreadClass * klass) {
	dvb_recording_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingThreadPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recording_thread_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recording_thread_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_recording_thread_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recording_thread_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_THREAD_DEVICE, g_param_spec_object ("device", "device", "device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_THREAD_EPGSCANNER, g_param_spec_object ("epgscanner", "epgscanner", "epgscanner", DVB_TYPE_EPG_SCANNER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_THREAD_COUNT, g_param_spec_uint ("count", "count", "count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("recording_stopped", DVB_TYPE_RECORDING_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, DVB_TYPE_RECORDING, DVB_TYPE_TIMER);
	g_signal_new ("recording_aborted", DVB_TYPE_RECORDING_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void dvb_recording_thread_instance_init (DVBRecordingThread * self) {
	self->priv = DVB_RECORDING_THREAD_GET_PRIVATE (self);
}


static void dvb_recording_thread_finalize (GObject* obj) {
	DVBRecordingThread * self;
	self = DVB_RECORDING_THREAD (obj);
	(self->priv->_device == NULL) ? NULL : (self->priv->_device = (g_object_unref (self->priv->_device), NULL));
	(self->priv->_epgscanner == NULL) ? NULL : (self->priv->_epgscanner = (g_object_unref (self->priv->_epgscanner), NULL));
	(self->priv->pipeline == NULL) ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL));
	self->priv->sid = (g_free (self->priv->sid), NULL);
	(self->priv->recordings == NULL) ? NULL : (self->priv->recordings = (g_object_unref (self->priv->recordings), NULL));
	G_OBJECT_CLASS (dvb_recording_thread_parent_class)->finalize (obj);
}


GType dvb_recording_thread_get_type (void) {
	static GType dvb_recording_thread_type_id = 0;
	if (dvb_recording_thread_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recording_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingThread), 0, (GInstanceInitFunc) dvb_recording_thread_instance_init, NULL };
		dvb_recording_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingThread", &g_define_type_info, 0);
	}
	return dvb_recording_thread_type_id;
}


DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev) {
	GParameter * __params;
	GParameter * __params_it;
	DVBRecorder * self;
	g_return_val_if_fail (dev != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "DeviceGroup";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE_GROUP);
	g_value_set_object (&__params_it->value, dev);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev) {
	return dvb_recorder_construct (DVB_TYPE_RECORDER, dev);
}


/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         * 
         * Add a new timer
         */
static guint32 dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DVBRecorder * self;
	guint32 timer_id;
	DVBChannel* _tmp1;
	DVBTimer* _tmp2;
	DVBTimer* new_timer;
	guint32 _tmp3;
	self = (DVBRecorder*) base;
	g_debug ("Recorder.vala:357: Adding new timer: channel: %u, start: %d-%d-%d %d:%d, duration: %u", channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	if (!dvb_channel_list_contains (dvb_device_group_get_Channels (self->priv->_DeviceGroup), channel)) {
		g_debug ("Recorder.vala:362: No channel %u for device group %u", channel, dvb_device_group_get_Id (self->priv->_DeviceGroup));
		return (guint32) 0;
	}
	timer_id = dvb_recordings_store_get_next_id (dvb_recordings_store_get_instance ());
	/* TODO Get name for timer*/
	_tmp1 = NULL;
	_tmp2 = NULL;
	new_timer = (_tmp2 = dvb_timer_new (timer_id, dvb_channel_get_Sid (_tmp1 = dvb_channel_list_get (dvb_device_group_get_Channels (self->priv->_DeviceGroup), channel)), start_year, start_month, start_day, start_hour, start_minute, duration, NULL), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
	return (_tmp3 = dvb_recorder_add_timer (self, new_timer), (new_timer == NULL) ? NULL : (new_timer = (g_object_unref (new_timer), NULL)), _tmp3);
}


static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self) {
	return dvb_recorder_check_timers (self);
}


guint32 dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer) {
	guint32 timer_id;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (new_timer != NULL, 0U);
	if (dvb_timer_has_expired (new_timer)) {
		return (guint32) 0;
	}
	timer_id = (guint32) 0;
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		gboolean has_conflict;
		gint conflict_count;
		has_conflict = FALSE;
		conflict_count = 0;
		/* Check for conflicts*/
		{
			GeeSet* _tmp1;
			GeeIterator* _tmp2;
			GeeIterator* _key_it;
			/* Check for conflicts*/
			_tmp1 = NULL;
			_tmp2 = NULL;
			_key_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = gee_map_get_keys ((GeeMap*) self->priv->timers))), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
			/* Check for conflicts*/
			while (gee_iterator_next (_key_it)) {
				guint32 key;
				DVBTimer* _tmp3;
				gboolean _tmp4;
				/* Check for conflicts*/
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				_tmp3 = NULL;
				if ((_tmp4 = dvb_timer_conflicts_with (_tmp3 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (key)), new_timer), (_tmp3 == NULL) ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)), _tmp4)) {
					conflict_count++;
					if (conflict_count >= dvb_device_group_get_size (self->priv->_DeviceGroup)) {
						char* _tmp6;
						DVBTimer* _tmp5;
						_tmp6 = NULL;
						_tmp5 = NULL;
						g_debug ("Recorder.vala:392: Timer is conflicting with another timer: %s", _tmp6 = dvb_timer_to_string (_tmp5 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (key))));
						_tmp6 = (g_free (_tmp6), NULL);
						(_tmp5 == NULL) ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL));
						has_conflict = TRUE;
						break;
					}
				}
			}
			(_key_it == NULL) ? NULL : (_key_it = (g_object_unref (_key_it), NULL));
		}
		if (!has_conflict) {
			gboolean _tmp7;
			gee_map_set ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (dvb_timer_get_Id (new_timer)), new_timer);
			dvb_timers_store_add_timer_to_device_group (dvb_factory_get_timers_store (), new_timer, self->priv->_DeviceGroup);
			g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", dvb_timer_get_Id (new_timer), (guint) DVB_CHANGE_TYPE_ADDED);
			_tmp7 = FALSE;
			if (gee_map_get_size ((GeeMap*) self->priv->timers) == 1) {
				_tmp7 = !self->priv->have_check_timers_timeout;
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				g_debug ("Recorder.vala:407: Creating new check timers");
				g_timeout_add_seconds ((guint) DVB_RECORDER_CHECK_TIMERS_INTERVAL, _dvb_recorder_check_timers_gsource_func, self);
				self->priv->have_check_timers_timeout = TRUE;
			}
			timer_id = dvb_timer_get_Id (new_timer);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return timer_id;
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         */
static guint32 dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid) {
	DVBRecorder * self;
	DVBEPGStore* epgstore;
	DVBEvent* event;
	struct tm start;
	guint32 _tmp1;
	self = (DVBRecorder*) base;
	epgstore = dvb_factory_get_epg_store ();
	event = dvb_epg_store_get_event (epgstore, event_id, channel_sid);
	if (event == NULL) {
		guint32 _tmp0;
		g_debug ("Recorder.vala:431: Could not find event with id %u", event_id);
		return (_tmp0 = (guint32) 0, (event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL)), _tmp0);
	}
	start = dvb_event_get_local_start_time (event);
	return (_tmp1 = dvb_id_bus_recorder_AddTimer ((DVBIDBusRecorder*) self, channel_sid, start.tm_year + 1900, start.tm_mon + 1, start.tm_mday, start.tm_hour, start.tm_min, event->duration / 60), (event == NULL) ? NULL : (event = (dvb_event_unref (event), NULL)), _tmp1);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id) {
	DVBRecorder * self;
	gboolean val;
	self = (DVBRecorder*) base;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
			if (dvb_id_bus_recorder_IsTimerActive ((DVBIDBusRecorder*) self, timer_id)) {
				DVBTimer* timer;
				/* Abort recording*/
				timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				dvb_recorder_stop_recording (self, timer);
				(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
			}
			gee_map_remove ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			dvb_timers_store_remove_timer_from_device_group (dvb_factory_get_timers_store (), (guint) timer_id, self->priv->_DeviceGroup);
			g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
			val = TRUE;
		} else {
			val = FALSE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return val;
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1) {
	DVBRecorder * self;
	gint timer_arr_size;
	gint timer_arr_length1;
	guint32* timer_arr;
	guint32* _tmp5;
	self = (DVBRecorder*) base;
	timer_arr = (timer_arr_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		guint32* _tmp1;
		gint _tmp0;
		gint i;
		_tmp1 = NULL;
		timer_arr = (_tmp1 = g_new0 (guint32, _tmp0 = gee_map_get_size ((GeeMap*) self->priv->timers)), timer_arr = (g_free (timer_arr), NULL), timer_arr_length1 = _tmp0, timer_arr_size = timer_arr_length1, _tmp1);
		i = 0;
		{
			GeeSet* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _key_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_key_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = gee_map_get_keys ((GeeMap*) self->priv->timers))), (_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_key_it)) {
				guint32 key;
				DVBTimer* _tmp4;
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				_tmp4 = NULL;
				timer_arr[i] = dvb_timer_get_Id (_tmp4 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (key)));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL));
				i++;
			}
			(_key_it == NULL) ? NULL : (_key_it = (g_object_unref (_key_it), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	_tmp5 = NULL;
	return (_tmp5 = timer_arr, *result_length1 = timer_arr_length1, _tmp5);
}


/**
         * @timer_id: Timer's id
         * @returns: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         */
static guint32* dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, int* result_length1) {
	DVBRecorder * self;
	gint val_size;
	gint val_length1;
	guint32* val;
	guint32* _tmp5;
	self = (DVBRecorder*) base;
	val = (val_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
			guint32* _tmp2;
			gint _tmp1;
			DVBTimer* _tmp0;
			_tmp2 = NULL;
			_tmp0 = NULL;
			val = (_tmp2 = dvb_timer_get_start_time (_tmp0 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)), &_tmp1), val = (g_free (val), NULL), val_length1 = _tmp1, val_size = val_length1, _tmp2);
			(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		} else {
			guint32* _tmp4;
			guint* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			val = (_tmp4 = (_tmp3 = g_new0 (guint, 0), _tmp3), val = (g_free (val), NULL), val_length1 = 0, val_size = val_length1, _tmp4);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	_tmp5 = NULL;
	return (_tmp5 = val, *result_length1 = val_length1, _tmp5);
}


/**
         * @timer_id: Timer's id
         * @returns: Same as dvb_recorder_GetStartTime()
         */
static guint* dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, int* result_length1) {
	DVBRecorder * self;
	gint val_size;
	gint val_length1;
	guint* val;
	guint* _tmp5;
	self = (DVBRecorder*) base;
	val = (val_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
			guint* _tmp2;
			gint _tmp1;
			DVBTimer* _tmp0;
			_tmp2 = NULL;
			_tmp0 = NULL;
			val = (_tmp2 = dvb_timer_get_end_time (_tmp0 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)), &_tmp1), val = (g_free (val), NULL), val_length1 = _tmp1, val_size = val_length1, _tmp2);
			(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		} else {
			guint* _tmp4;
			guint* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			val = (_tmp4 = (_tmp3 = g_new0 (guint, 0), _tmp3), val = (g_free (val), NULL), val_length1 = 0, val_size = val_length1, _tmp4);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	_tmp5 = NULL;
	return (_tmp5 = val, *result_length1 = val_length1, _tmp5);
}


/**
         * @timer_id: Timer's id
         * @returns: Duration in seconds or 0 if there's no timer with
         * the given id
         */
static guint dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id) {
	DVBRecorder * self;
	guint val;
	self = (DVBRecorder*) base;
	val = (guint) 0;
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
			DVBTimer* _tmp0;
			_tmp0 = NULL;
			val = dvb_timer_get_Duration (_tmp0 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id)));
			(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return val;
}


/**
         * @timer_id: Timer's id
         * @returns: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         */
static char* dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id) {
	DVBRecorder * self;
	char* name;
	self = (DVBRecorder*) base;
	name = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		if (gee_map_contains ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id))) {
			DVBTimer* t;
			char* _tmp2;
			const char* _tmp1;
			DVBChannel* _tmp0;
			t = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			name = (_tmp2 = (_tmp1 = dvb_channel_get_Name (_tmp0 = dvb_channel_list_get (dvb_device_group_get_Channels (self->priv->_DeviceGroup), dvb_timer_get_ChannelSid (t))), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), name = (g_free (name), NULL), _tmp2);
			(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
			(t == NULL) ? NULL : (t = (g_object_unref (t), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return name;
}


/**
         * @returns: The currently active timers
         */
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1) {
	DVBRecorder * self;
	guint32* _tmp1;
	gint val_size;
	gint val_length1;
	gint _tmp0;
	guint32* val;
	gint i;
	guint32* _tmp2;
	self = (DVBRecorder*) base;
	_tmp1 = NULL;
	val = (_tmp1 = g_new0 (guint32, _tmp0 = gee_collection_get_size ((GeeCollection*) self->active_timers)), val_length1 = _tmp0, val_size = val_length1, _tmp1);
	i = 0;
	{
		GeeIterator* _timer_id_it;
		_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->active_timers);
		while (gee_iterator_next (_timer_id_it)) {
			guint32 timer_id;
			DVBTimer* timer;
			timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
			timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			val[i] = dvb_timer_get_Id (timer);
			i++;
			(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
		}
		(_timer_id_it == NULL) ? NULL : (_timer_id_it = (g_object_unref (_timer_id_it), NULL));
	}
	_tmp2 = NULL;
	return (_tmp2 = val, *result_length1 = val_length1, _tmp2);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id) {
	DVBRecorder * self;
	self = (DVBRecorder*) base;
	return gee_collection_contains ((GeeCollection*) self->active_timers, GUINT_TO_POINTER (timer_id));
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DVBRecorder * self;
	gboolean val;
	self = (DVBRecorder*) base;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		{
			GeeSet* _tmp0;
			GeeIterator* _tmp1;
			GeeIterator* _key_it;
			_tmp0 = NULL;
			_tmp1 = NULL;
			_key_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_keys ((GeeMap*) self->priv->timers))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
			while (gee_iterator_next (_key_it)) {
				guint32 key;
				DVBTimer* _tmp2;
				gboolean _tmp3;
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				_tmp2 = NULL;
				if ((_tmp3 = dvb_timer_is_in_range (_tmp2 = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (key)), start_year, start_month, start_day, start_hour, start_minute, duration), (_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)), _tmp3)) {
					val = TRUE;
				}
				break;
			}
			(_key_it == NULL) ? NULL : (_key_it = (g_object_unref (_key_it), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return val;
}


void dvb_recorder_stop (DVBRecorder* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _timer_id_it;
		_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->active_timers);
		while (gee_iterator_next (_timer_id_it)) {
			guint32 timer_id;
			DVBTimer* timer;
			timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
			timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			dvb_recorder_stop_recording (self, timer);
			(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
		}
		(_timer_id_it == NULL) ? NULL : (_timer_id_it = (g_object_unref (_timer_id_it), NULL));
	}
}


static void _dvb_recorder_on_recording_stopped_dvb_recording_thread_recording_stopped (DVBRecordingThread* _sender, DVBRecording* rec, DVBTimer* timer, gpointer self) {
	dvb_recorder_on_recording_stopped (self, _sender, rec, timer);
}


/**
         * Start recording of specified timer
         */
void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBChannel* channel;
	guint* _tmp2;
	gint _tmp1_length1;
	guint* _tmp1;
	gint _tmp0;
	GFile* _tmp3;
	GFile* location;
	gboolean create_new_thread;
	DVBRecordingThread* recthread;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	channel = dvb_channel_list_get (dvb_device_group_get_Channels (self->priv->_DeviceGroup), dvb_timer_get_ChannelSid (timer));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	location = (_tmp3 = (_tmp2 = (_tmp1 = dvb_timer_get_start_time (timer, &_tmp0), _tmp1_length1 = _tmp0, _tmp1), dvb_recorder_create_recording_dirs (self, channel, _tmp2, _tmp0)), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
	if (location == NULL) {
		(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
		(location == NULL) ? NULL : (location = (g_object_unref (location), NULL));
		return;
	}
	create_new_thread = TRUE;
	recthread = NULL;
	/* Check if there's already an active recording on the
	 same transport stream*/
	{
		GeeIterator* _timer_id_it;
		/* Check if there's already an active recording on the
		 same transport stream*/
		_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->active_timers);
		/* Check if there's already an active recording on the
		 same transport stream*/
		while (gee_iterator_next (_timer_id_it)) {
			guint32 timer_id;
			DVBTimer* other_timer;
			DVBChannel* other_channel;
			/* Check if there's already an active recording on the
			 same transport stream*/
			timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
			other_timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			other_channel = dvb_channel_list_get (dvb_device_group_get_Channels (self->priv->_DeviceGroup), dvb_timer_get_ChannelSid (other_timer));
			if (dvb_channel_on_same_transport_stream (channel, other_channel)) {
				DVBRecordingThread* _tmp4;
				g_debug ("Recorder.vala:619: Using already active RecordingThread");
				_tmp4 = NULL;
				recthread = (_tmp4 = (DVBRecordingThread*) gee_map_get (self->active_recording_threads, other_timer), (recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL)), _tmp4);
				create_new_thread = FALSE;
			}
			(other_timer == NULL) ? NULL : (other_timer = (g_object_unref (other_timer), NULL));
			(other_channel == NULL) ? NULL : (other_channel = (g_object_unref (other_channel), NULL));
		}
		(_timer_id_it == NULL) ? NULL : (_timer_id_it = (g_object_unref (_timer_id_it), NULL));
	}
	if (create_new_thread) {
		DVBEPGScanner* epgscanner;
		DVBDevice* free_device;
		DVBRecordingThread* _tmp5;
		g_debug ("Recorder.vala:626: Creating new RecordingThread");
		/* Stop epgscanner before starting recording*/
		epgscanner = dvb_manager_get_epg_scanner (dvb_manager_get_instance (), self->priv->_DeviceGroup);
		if (epgscanner != NULL) {
			dvb_epg_scanner_stop (epgscanner);
		}
		free_device = dvb_device_group_get_next_free_device (self->priv->_DeviceGroup);
		if (free_device == NULL) {
			g_critical ("Recorder.vala:635: All devices are busy");
			(epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL));
			(free_device == NULL) ? NULL : (free_device = (g_object_unref (free_device), NULL));
			(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
			(location == NULL) ? NULL : (location = (g_object_unref (location), NULL));
			(recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL));
			return;
		}
		_tmp5 = NULL;
		recthread = (_tmp5 = dvb_recording_thread_new (free_device, epgscanner), (recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL)), _tmp5);
		g_signal_connect_object (recthread, "recording-stopped", (GCallback) _dvb_recorder_on_recording_stopped_dvb_recording_thread_recording_stopped, self, 0);
		(epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL));
		(free_device == NULL) ? NULL : (free_device = (g_object_unref (free_device), NULL));
	}
	/* FIXME
	recthread.recording_aborted += this.on_recording_aborted;*/
	if (recthread == NULL) {
		g_critical ("Recorder.vala:646: Could not create recording thread");
		(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
		(location == NULL) ? NULL : (location = (g_object_unref (location), NULL));
		(recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL));
		return;
	}
	dvb_recording_thread_start_recording (recthread, timer, location);
	gee_collection_add ((GeeCollection*) self->active_timers, GUINT_TO_POINTER (dvb_timer_get_Id (timer)));
	gee_map_set (self->active_recording_threads, timer, recthread);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-started", dvb_timer_get_Id (timer));
	(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
	(location == NULL) ? NULL : (location = (g_object_unref (location), NULL));
	(recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL));
}


/**
         * Stop recording of specified timer
         */
void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBRecordingThread* recthread;
	guint32 timer_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	recthread = (DVBRecordingThread*) gee_map_get (self->active_recording_threads, timer);
	dvb_recording_thread_stop_recording (recthread, timer);
	timer_id = dvb_timer_get_Id (timer);
	gee_collection_remove ((GeeCollection*) self->active_timers, GUINT_TO_POINTER (timer_id));
	gee_map_remove ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
	(recthread == NULL) ? NULL : (recthread = (g_object_unref (recthread), NULL));
}


/**
         * @returns: File on success, NULL otherwise
         * 
         * Create directories and set location of recording
         */
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1) {
	GError * inner_error;
	char* channel_name;
	char* time;
	GFile* _tmp0;
	GFile* _tmp1;
	GFile* dir;
	char* attributes;
	GFileInfo* info;
	GFile* _tmp11;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	inner_error = NULL;
	channel_name = dvb_utils_remove_nonalphanums (dvb_channel_get_Name (channel));
	time = g_strdup_printf ("%u-%u-%u_%u-%u", start[0], start[1], start[2], start[3], start[4]);
	_tmp0 = NULL;
	_tmp1 = NULL;
	dir = (_tmp1 = g_file_get_child (_tmp0 = g_file_get_child (dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup), channel_name), time), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
	if (!g_file_query_exists (dir, NULL)) {
		{
			dvb_utils_mkdirs (dir, &inner_error);
			if (inner_error != NULL) {
				goto __catch10_g_error;
				goto __finally10;
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				char* _tmp2;
				GFile* _tmp3;
				_tmp2 = NULL;
				g_error ("Recorder.vala:690: Could not create directory %s: %s", _tmp2 = g_file_get_path (dir), e->message);
				_tmp2 = (g_free (_tmp2), NULL);
				_tmp3 = NULL;
				return (_tmp3 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), channel_name = (g_free (channel_name), NULL), time = (g_free (time), NULL), (dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL)), _tmp3);
			}
		}
		__finally10:
		if (inner_error != NULL) {
			channel_name = (g_free (channel_name), NULL);
			time = (g_free (time), NULL);
			(dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return NULL;
		}
	}
	attributes = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	info = NULL;
	{
		GFileInfo* _tmp4;
		GFileInfo* _tmp5;
		_tmp4 = g_file_query_info (dir, attributes, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch11_g_error;
			goto __finally11;
		}
		_tmp5 = NULL;
		info = (_tmp5 = _tmp4, (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp5);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GFile* _tmp6;
			g_critical ("Recorder.vala:702: Could not retrieve attributes: %s", e->message);
			_tmp6 = NULL;
			return (_tmp6 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), channel_name = (g_free (channel_name), NULL), time = (g_free (time), NULL), (dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL)), attributes = (g_free (attributes), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp6);
		}
	}
	__finally11:
	if (inner_error != NULL) {
		channel_name = (g_free (channel_name), NULL);
		time = (g_free (time), NULL);
		(dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL));
		attributes = (g_free (attributes), NULL);
		(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	if (g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_STANDARD_TYPE) != G_FILE_TYPE_DIRECTORY) {
		char* _tmp7;
		GFile* _tmp8;
		_tmp7 = NULL;
		g_critical ("Recorder.vala:708: %s is not a directory", _tmp7 = g_file_get_path (dir));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp8 = NULL;
		return (_tmp8 = NULL, channel_name = (g_free (channel_name), NULL), time = (g_free (time), NULL), (dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL)), attributes = (g_free (attributes), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp8);
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE)) {
		char* _tmp9;
		GFile* _tmp10;
		_tmp9 = NULL;
		g_critical ("Recorder.vala:713: Cannot write to %s", _tmp9 = g_file_get_path (dir));
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp10 = NULL;
		return (_tmp10 = NULL, channel_name = (g_free (channel_name), NULL), time = (g_free (time), NULL), (dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL)), attributes = (g_free (attributes), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp10);
	}
	_tmp11 = NULL;
	return (_tmp11 = g_file_get_child (dir, "001.mpeg"), channel_name = (g_free (channel_name), NULL), time = (g_free (time), NULL), (dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL)), attributes = (g_free (attributes), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp11);
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static gboolean dvb_recorder_check_timers (DVBRecorder* self) {
	GSList* ended_recordings;
	gboolean val;
	GSList* deleteable_items;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("Recorder.vala:721: Checking timers");
	ended_recordings = NULL;
	{
		GeeIterator* _timer_id_it;
		_timer_id_it = gee_iterable_iterator ((GeeIterable*) self->active_timers);
		while (gee_iterator_next (_timer_id_it)) {
			guint32 timer_id;
			DVBTimer* timer;
			timer_id = GPOINTER_TO_UINT (gee_iterator_get (_timer_id_it));
			timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			if (dvb_timer_is_end_due (timer)) {
				DVBTimer* _tmp0;
				_tmp0 = NULL;
				ended_recordings = g_slist_prepend (ended_recordings, (_tmp0 = timer, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)));
			}
			(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
		}
		(_timer_id_it == NULL) ? NULL : (_timer_id_it = (g_object_unref (_timer_id_it), NULL));
	}
	{
		gint i;
		/* Delete timers of recordings that have ended*/
		i = 0;
		for (; i < g_slist_length (ended_recordings); i++) {
			DVBTimer* _tmp1;
			DVBTimer* timer;
			_tmp1 = NULL;
			timer = (_tmp1 = (DVBTimer*) g_slist_nth_data (ended_recordings, (guint) i), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			dvb_recorder_stop_recording (self, timer);
			(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
		}
	}
	val = FALSE;
	/* Store items we want to delete in here*/
	deleteable_items = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_timers);
	{
		gboolean _tmp7;
		{
			GeeSet* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _key_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_key_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = gee_map_get_keys ((GeeMap*) self->priv->timers))), (_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_key_it)) {
				guint32 key;
				DVBTimer* timer;
				char* _tmp4;
				gboolean _tmp5;
				key = GPOINTER_TO_UINT (gee_iterator_get (_key_it));
				timer = (DVBTimer*) gee_map_get ((GeeMap*) self->priv->timers, GUINT_TO_POINTER (key));
				_tmp4 = NULL;
				g_debug ("Recorder.vala:747: Checking timer: %s", _tmp4 = dvb_timer_to_string (timer));
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp5 = FALSE;
				if (dvb_timer_is_start_due (timer)) {
					_tmp5 = !gee_collection_contains ((GeeCollection*) self->active_timers, GUINT_TO_POINTER (dvb_timer_get_Id (timer)));
				} else {
					_tmp5 = FALSE;
				}
				/* Check if we should start new recording and if we didn't
				 start it before*/
				if (_tmp5) {
					dvb_recorder_start_recording (self, timer);
				} else {
					if (dvb_timer_has_expired (timer)) {
						char* _tmp6;
						_tmp6 = NULL;
						g_debug ("Recorder.vala:755: Removing expired timer: %s", _tmp6 = dvb_timer_to_string (timer));
						_tmp6 = (g_free (_tmp6), NULL);
						deleteable_items = g_slist_prepend (deleteable_items, GUINT_TO_POINTER (key));
					}
				}
				(timer == NULL) ? NULL : (timer = (g_object_unref (timer), NULL));
			}
			(_key_it == NULL) ? NULL : (_key_it = (g_object_unref (_key_it), NULL));
		}
		{
			gint i;
			/* Delete items from this.timers using this.DeleteTimer*/
			i = 0;
			for (; i < g_slist_length (deleteable_items); i++) {
				dvb_id_bus_recorder_DeleteTimer ((DVBIDBusRecorder*) self, GPOINTER_TO_UINT (g_slist_nth_data (deleteable_items, (guint) i)));
			}
		}
		_tmp7 = FALSE;
		if (gee_map_get_size ((GeeMap*) self->priv->timers) == 0) {
			_tmp7 = gee_collection_get_size ((GeeCollection*) self->active_timers) == 0;
		} else {
			_tmp7 = FALSE;
		}
		if (_tmp7) {
			/* We don't have any timers and no recording is in progress*/
			g_debug ("Recorder.vala:767: No timers left and no recording in progress");
			self->priv->have_check_timers_timeout = FALSE;
			val = FALSE;
		} else {
			/* We still have timers*/
			g_debug ("Recorder.vala:772: %d timers and %d active recordings left", gee_map_get_size ((GeeMap*) self->priv->timers), gee_collection_get_size ((GeeCollection*) self->active_timers));
			val = TRUE;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_timers);
	return (_tmp8 = val, (ended_recordings == NULL) ? NULL : (ended_recordings = (_g_slist_free_g_object_unref (ended_recordings), NULL)), (deleteable_items == NULL) ? NULL : (deleteable_items = (g_slist_free (deleteable_items), NULL)), _tmp8);
}


/**
         * Add recording to RecordinsStore and let the world now
         */
static void dvb_recorder_on_recording_stopped (DVBRecorder* self, DVBRecordingThread* recthread, DVBRecording* recording, DVBTimer* timer) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (recthread != NULL);
	g_return_if_fail (recording != NULL);
	g_return_if_fail (timer != NULL);
	g_debug ("Recorder.vala:787: Recording of channel %u stopped after %lli seconds", dvb_recording_get_ChannelSid (recording), dvb_recording_get_Length (recording));
	if (dvb_recording_thread_get_count (recthread) == 0) {
		DVBEPGScanner* epgscanner;
		gee_map_remove (self->active_recording_threads, timer);
		/* Start epgscanner again after recording ended*/
		epgscanner = dvb_manager_get_epg_scanner (dvb_manager_get_instance (), self->priv->_DeviceGroup);
		if (epgscanner != NULL) {
			dvb_epg_scanner_start (epgscanner);
		}
		(epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL));
	}
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-finished", dvb_recording_get_Id (recording));
}


DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_DeviceGroup;
}


static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp2;
	DVBDeviceGroup* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_DeviceGroup = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_DeviceGroup == NULL) ? NULL : (self->priv->_DeviceGroup = (g_object_unref (self->priv->_DeviceGroup), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "DeviceGroup");
}


static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBRecorderClass * klass;
	GObjectClass * parent_class;
	DVBRecorder * self;
	klass = DVB_RECORDER_CLASS (g_type_class_peek (DVB_TYPE_RECORDER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDER (obj);
	{
		GeeMap* _tmp1;
		GeeSet* _tmp2;
		GeeHashMap* _tmp3;
		_tmp1 = NULL;
		self->active_recording_threads = (_tmp1 = (GeeMap*) gee_hash_map_new (DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, DVB_TYPE_RECORDING_THREAD, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->active_recording_threads == NULL) ? NULL : (self->active_recording_threads = (g_object_unref (self->active_recording_threads), NULL)), _tmp1);
		_tmp2 = NULL;
		self->active_timers = (_tmp2 = (GeeSet*) gee_hash_set_new (G_TYPE_UINT, NULL, NULL, g_direct_hash, g_direct_equal), (self->active_timers == NULL) ? NULL : (self->active_timers = (g_object_unref (self->active_timers), NULL)), _tmp2);
		_tmp3 = NULL;
		self->priv->timers = (_tmp3 = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->timers == NULL) ? NULL : (self->priv->timers = (g_object_unref (self->priv->timers), NULL)), _tmp3);
		self->priv->have_check_timers_timeout = FALSE;
		dvb_recordings_store_restore_from_dir (dvb_recordings_store_get_instance (), dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup));
	}
	return obj;
}


static void dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	gpointer boxed;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		g_value_set_object (value, dvb_recorder_get_DeviceGroup (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		dvb_recorder_set_DeviceGroup (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _dvb_recorder_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_recorder_introspect (DVBRecorder* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Recorder\">\n  <method name=\"AddTimer\">\n    <arg name=\"channel\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_year\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"i\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"i\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddTimerForEPGEvent\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_sid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"DeleteTimer\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetEndTime\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetActiveTimers\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"IsTimerActive\">\n    <arg name=\"timer_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"HasTimer\">\n    <arg name=\"start_year\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_month\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_day\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_hour\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_minute\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"RecordingStarted\">\n    <arg name=\"timer_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"RecordingFinished\">\n    <arg name=\"recording_id\" type=\"u\"/>\n  </signal>\n  <signal name=\"Changed\">\n    <arg name=\"timer_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_recorder_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_recorder_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_recorder_dbus_path_vtable, object);
	}
	dvb_id_bus_recorder_dbus_register_object (connection, path, object);
}


static void dvb_recorder_class_init (DVBRecorderClass * klass) {
	dvb_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecorderPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recorder_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recorder_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_recorder_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recorder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_DEVICE_GROUP, g_param_spec_object ("DeviceGroup", "DeviceGroup", "DeviceGroup", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_type_set_qdata (DVB_TYPE_RECORDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_recorder_dbus_vtable));
}


static void dvb_recorder_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface * iface) {
	dvb_recorder_dvb_id_bus_recorder_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddTimer = dvb_recorder_real_AddTimer;
	iface->AddTimerForEPGEvent = dvb_recorder_real_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_recorder_real_DeleteTimer;
	iface->GetTimers = dvb_recorder_real_GetTimers;
	iface->GetStartTime = dvb_recorder_real_GetStartTime;
	iface->GetEndTime = dvb_recorder_real_GetEndTime;
	iface->GetDuration = dvb_recorder_real_GetDuration;
	iface->GetChannelName = dvb_recorder_real_GetChannelName;
	iface->GetActiveTimers = dvb_recorder_real_GetActiveTimers;
	iface->IsTimerActive = dvb_recorder_real_IsTimerActive;
	iface->HasTimer = dvb_recorder_real_HasTimer;
}


static void dvb_recorder_instance_init (DVBRecorder * self) {
	self->priv = DVB_RECORDER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_timers);
}


static void dvb_recorder_finalize (GObject* obj) {
	DVBRecorder * self;
	self = DVB_RECORDER (obj);
	(self->priv->_DeviceGroup == NULL) ? NULL : (self->priv->_DeviceGroup = (g_object_unref (self->priv->_DeviceGroup), NULL));
	(self->active_recording_threads == NULL) ? NULL : (self->active_recording_threads = (g_object_unref (self->active_recording_threads), NULL));
	(self->active_timers == NULL) ? NULL : (self->active_timers = (g_object_unref (self->active_timers), NULL));
	g_static_rec_mutex_free (&self->priv->__lock_timers);
	(self->priv->timers == NULL) ? NULL : (self->priv->timers = (g_object_unref (self->priv->timers), NULL));
	G_OBJECT_CLASS (dvb_recorder_parent_class)->finalize (obj);
}


GType dvb_recorder_get_type (void) {
	static GType dvb_recorder_type_id = 0;
	if (dvb_recorder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecorder), 0, (GInstanceInitFunc) dvb_recorder_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recorder_info = { (GInterfaceInitFunc) dvb_recorder_dvb_id_bus_recorder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_recorder_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecorder", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recorder_type_id, DVB_TYPE_ID_BUS_RECORDER, &dvb_id_bus_recorder_info);
	}
	return dvb_recorder_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}



static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}



