/* Timer.c generated by valac 0.9.7, the Vala compiler
 * generated from Timer.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;
typedef struct _DVBTimerPrivate DVBTimerPrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBTimer {
	GObject parent_instance;
	DVBTimerPrivate * priv;
};

struct _DVBTimerClass {
	GObjectClass parent_class;
};

struct _DVBTimerPrivate {
	guint32 _Id;
	DVBChannel* _Channel;
	guint _Duration;
	GstElement* _sink;
	guint _EventID;
	struct tm starttime;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_timer_parent_class = NULL;

GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
#define DVB_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TIMER, DVBTimerPrivate))
enum  {
	DVB_TIMER_DUMMY_PROPERTY,
	DVB_TIMER_ID,
	DVB_TIMER_CHANNEL,
	DVB_TIMER_DURATION,
	DVB_TIMER_SINK,
	DVB_TIMER_EVENT_ID
};
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_timer_set_EventID (DVBTimer* self, guint value);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
static void dvb_timer_update_epg_event (DVBTimer* self);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_timer_get_overlap (time_t this_start, time_t this_end, time_t other_start, time_t other_end);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
gboolean dvb_timer_is_start_due (DVBTimer* self);
gboolean dvb_timer_has_expired (DVBTimer* self);
gboolean dvb_timer_is_end_due (DVBTimer* self);
char* dvb_timer_to_string (DVBTimer* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_timer_get_Duration (DVBTimer* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
guint32 dvb_timer_get_Id (DVBTimer* self);
static void dvb_timer_set_Id (DVBTimer* self, guint32 value);
static void dvb_timer_set_Channel (DVBTimer* self, DVBChannel* value);
GstElement* dvb_timer_get_sink (DVBTimer* self);
void dvb_timer_set_sink (DVBTimer* self, GstElement* value);
guint dvb_timer_get_EventID (DVBTimer* self);
static void dvb_timer_finalize (GObject* obj);
static void dvb_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration) {
	DVBTimer * self;
	g_return_val_if_fail (channel != NULL, NULL);
	self = (DVBTimer*) g_object_new (object_type, "Id", id, "Channel", channel, NULL);
	dvb_timer_set_EventID (self, (guint) 0);
	dvb_timer_set_Duration (self, duration);
	dvb_timer_set_start_time (self, year, month, day, hour, minute);
	return self;
}


DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration) {
	return dvb_timer_construct (DVB_TYPE_TIMER, id, channel, year, month, day, hour, minute, duration);
}


void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute) {
	struct tm _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	self->priv->starttime = (dvb_utils_create_time (year, month, day, hour, minute, 0, &_tmp0_), _tmp0_);
	dvb_timer_update_epg_event (self);
}


/**
         * Whether the timer conflicts with the other one
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2) {
	gboolean result = FALSE;
	time_t this_start;
	time_t other_start;
	DVBChannel* t1_c;
	DVBChannel* t2_c;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t2 != NULL, FALSE);
	this_start = dvb_timer_get_start_time_timestamp (self);
	other_start = dvb_timer_get_start_time_timestamp (t2);
	t1_c = _g_object_ref0 (self->priv->_Channel);
	t2_c = _g_object_ref0 (t2->priv->_Channel);
	if (dvb_channel_on_same_transport_stream (t1_c, t2_c)) {
		result = FALSE;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	}
	if (this_start <= other_start) {
		time_t this_end;
		this_end = dvb_timer_get_end_time_timestamp (self);
		result = this_end > other_start;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	} else {
		time_t other_end;
		other_end = dvb_timer_get_end_time_timestamp (t2);
		result = other_end > this_start;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	}
	_g_object_unref0 (t2_c);
	_g_object_unref0 (t1_c);
}


/**
         * @duration: in minutes
         * @returns: The overlap between the timer and the given time range.
         * The timer is the reference, i.e. if the time range is completely
         * contained in the timer OverlapType.COMPLETE is returned.
         *
         * The given time range must be in local time.
         */
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DVBOverlapType result = 0;
	time_t this_start;
	time_t this_end;
	struct tm _tmp0_ = {0};
	struct tm other_time;
	time_t other_start;
	time_t other_end;
	g_return_val_if_fail (self != NULL, 0);
	this_start = dvb_timer_get_start_time_timestamp (self);
	this_end = dvb_timer_get_end_time_timestamp (self);
	other_time = (dvb_utils_create_time ((gint) start_year, (gint) start_month, (gint) start_day, (gint) start_hour, (gint) start_minute, 0, &_tmp0_), _tmp0_);
	other_start = mktime (&other_time);
	other_time.tm_min = other_time.tm_min + ((gint) duration);
	other_end = mktime (&other_time);
	result = dvb_timer_get_overlap (this_start, this_end, other_start, other_end);
	return result;
}


/**
         * Same as get_overlap_local but the given time range is UTC time.
         */
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DVBOverlapType result = 0;
	time_t this_start;
	time_t this_end;
	struct tm _tmp0_ = {0};
	struct tm other_time;
	time_t other_start;
	time_t other_end;
	g_return_val_if_fail (self != NULL, 0);
	this_start = dvb_timer_get_start_time_timestamp (self);
	this_end = dvb_timer_get_end_time_timestamp (self);
	other_time = (dvb_utils_create_time ((gint) start_year, (gint) start_month, (gint) start_day, (gint) start_hour, (gint) start_minute, 0, &_tmp0_), _tmp0_);
	other_start = timegm (&other_time);
	other_time.tm_min = other_time.tm_min + ((gint) duration);
	other_end = timegm (&other_time);
	result = dvb_timer_get_overlap (this_start, this_end, other_start, other_end);
	return result;
}


static DVBOverlapType dvb_timer_get_overlap (time_t this_start, time_t this_end, time_t other_start, time_t other_end) {
	DVBOverlapType result = 0;
	if (this_start <= other_start) {
		if (this_end <= other_start) {
			result = DVB_OVERLAP_TYPE_NONE;
			return result;
		} else {
			if (this_end >= other_end) {
				result = DVB_OVERLAP_TYPE_COMPLETE;
				return result;
			} else {
				result = DVB_OVERLAP_TYPE_PARTIAL;
				return result;
			}
		}
	} else {
		if (this_end <= other_end) {
			result = DVB_OVERLAP_TYPE_PARTIAL;
			return result;
		} else {
			if (this_start < other_end) {
				result = DVB_OVERLAP_TYPE_PARTIAL;
				return result;
			} else {
				result = DVB_OVERLAP_TYPE_NONE;
				return result;
			}
		}
	}
}


/**
         * Add the specified amount of minutes to the starting time
         */
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes) {
	g_return_if_fail (self != NULL);
	self->priv->starttime.tm_min = self->priv->starttime.tm_min + minutes;
	mktime (&self->priv->starttime);
}


guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1) {
	guint* result = NULL;
	gint start_length1;
	gint _start_size_;
	guint* _tmp1_;
	guint* _tmp0_ = NULL;
	guint* start;
	guint* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	start = (_tmp1_ = (_tmp0_ = g_new0 (guint, 5), _tmp0_[0] = (guint) (self->priv->starttime.tm_year + 1900), _tmp0_[1] = (guint) (self->priv->starttime.tm_mon + 1), _tmp0_[2] = (guint) self->priv->starttime.tm_mday, _tmp0_[3] = (guint) self->priv->starttime.tm_hour, _tmp0_[4] = (guint) self->priv->starttime.tm_min, _tmp0_), start_length1 = 5, _start_size_ = start_length1, _tmp1_);
	result = (_tmp2_ = start, *result_length1 = start_length1, _tmp2_);
	return result;
	start = (g_free (start), NULL);
}


void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->starttime;
	return;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1) {
	guint* result = NULL;
	struct tm _tmp0_ = {0};
	struct tm l;
	guint* _tmp1_ = NULL;
	guint* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	l = (g_time_local (dvb_timer_get_end_time_timestamp (self), &_tmp0_), _tmp0_);
	result = (_tmp2_ = (_tmp1_ = g_new0 (guint, 5), _tmp1_[0] = (guint) (l.tm_year + 1900), _tmp1_[1] = (guint) (l.tm_mon + 1), _tmp1_[2] = (guint) l.tm_mday, _tmp1_[3] = (guint) l.tm_hour, _tmp1_[4] = (guint) l.tm_min, _tmp1_), *result_length1 = 5, _tmp2_);
	return result;
}


/**
         * Whether the start time of the timer is after the current local time
         * and the timer hasn't expired, yet.
         */
gboolean dvb_timer_is_start_due (DVBTimer* self) {
	gboolean result = FALSE;
	time_t localtime;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	localtime = time (NULL);
	if ((localtime - mktime (&self->priv->starttime)) >= 0) {
		_tmp0_ = !dvb_timer_has_expired (self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
         * Whether the end time of the timer equals the current local time
         */
gboolean dvb_timer_is_end_due (DVBTimer* self) {
	gboolean result = FALSE;
	struct tm _tmp0_ = {0};
	struct tm localtime;
	struct tm _tmp1_ = {0};
	struct tm endtime;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	localtime = (g_time_local (time (NULL), &_tmp0_), _tmp0_);
	endtime = (g_time_local (dvb_timer_get_end_time_timestamp (self), &_tmp1_), _tmp1_);
	if (endtime.tm_year == localtime.tm_year) {
		_tmp5_ = endtime.tm_mon == localtime.tm_mon;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = endtime.tm_mday == localtime.tm_mday;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = endtime.tm_hour == localtime.tm_hour;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = endtime.tm_min == localtime.tm_min;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}


/**
         * Whether the timer ends in the past
         */
gboolean dvb_timer_has_expired (DVBTimer* self) {
	gboolean result = FALSE;
	time_t current_time;
	time_t end_time;
	g_return_val_if_fail (self != NULL, FALSE);
	current_time = time (NULL);
	end_time = dvb_timer_get_end_time_timestamp (self);
	result = end_time < current_time;
	return result;
}


char* dvb_timer_to_string (DVBTimer* self) {
	char* result = NULL;
	gint start_length1;
	gint _start_size_;
	guint* _tmp1_;
	gint _tmp0_;
	guint* start;
	g_return_val_if_fail (self != NULL, NULL);
	start = (_tmp1_ = dvb_timer_get_start_time (self, &_tmp0_), start_length1 = _tmp0_, _start_size_ = start_length1, _tmp1_);
	result = g_strdup_printf ("channel: %u, start: %04u-%02u-%02u %02u:%02u, duration: %u", dvb_channel_get_Sid (self->priv->_Channel), start[0], start[1], start[2], start[3], start[4], self->priv->_Duration);
	start = (g_free (start), NULL);
	return result;
}


/**
         * Check if we can find an EPG event belonging to this recording
         */
static void dvb_timer_update_epg_event (DVBTimer* self) {
	DVBSchedule* schedule;
	struct tm _tmp0_ = {0};
	struct tm _tmp1_;
	DVBEvent* event;
	g_return_if_fail (self != NULL);
	schedule = _g_object_ref0 (dvb_channel_get_Schedule (self->priv->_Channel));
	event = dvb_schedule_get_event_around (schedule, (_tmp1_ = (dvb_timer_get_start_time_time (self, &_tmp0_), _tmp0_), &_tmp1_), self->priv->_Duration);
	if (event == NULL) {
		dvb_timer_set_EventID (self, (guint) 0);
	} else {
		dvb_timer_set_EventID (self, event->id);
	}
	_dvb_event_unref0 (event);
	_g_object_unref0 (schedule);
}


static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self) {
	time_t result;
	struct tm _tmp0_ = {0};
	struct tm t;
	t = (dvb_utils_create_time (self->priv->starttime.tm_year + 1900, self->priv->starttime.tm_mon + 1, self->priv->starttime.tm_mday, self->priv->starttime.tm_hour, self->priv->starttime.tm_min, 0, &_tmp0_), _tmp0_);
	t.tm_min = t.tm_min + ((gint) self->priv->_Duration);
	result = mktime (&t);
	return result;
}


static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self) {
	time_t result;
	struct tm _tmp0_ = {0};
	struct tm t;
	t = (dvb_timer_get_start_time_time (self, &_tmp0_), _tmp0_);
	result = mktime (&t);
	return result;
}


guint32 dvb_timer_get_Id (DVBTimer* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Id;
	return result;
}


static void dvb_timer_set_Id (DVBTimer* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


DVBChannel* dvb_timer_get_Channel (DVBTimer* self) {
	DVBChannel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Channel;
	return result;
}


static void dvb_timer_set_Channel (DVBTimer* self, DVBChannel* value) {
	DVBChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Channel = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_Channel), _tmp0_);
	g_object_notify ((GObject *) self, "Channel");
}


guint dvb_timer_get_Duration (DVBTimer* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Duration;
	return result;
}


void dvb_timer_set_Duration (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Duration = value;
	g_object_notify ((GObject *) self, "Duration");
}


GstElement* dvb_timer_get_sink (DVBTimer* self) {
	GstElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sink;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


void dvb_timer_set_sink (DVBTimer* self, GstElement* value) {
	GstElement* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sink = (_tmp0_ = _gst_object_ref0 (value), _gst_object_unref0 (self->priv->_sink), _tmp0_);
	g_object_notify ((GObject *) self, "sink");
}


guint dvb_timer_get_EventID (DVBTimer* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_EventID;
	return result;
}


void dvb_timer_set_EventID (DVBTimer* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_EventID = value;
	g_object_notify ((GObject *) self, "EventID");
}


static void dvb_timer_class_init (DVBTimerClass * klass) {
	dvb_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTimerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_CHANNEL, g_param_spec_object ("Channel", "Channel", "Channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_DURATION, g_param_spec_uint ("Duration", "Duration", "Duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_SINK, g_param_spec_object ("sink", "sink", "sink", GST_TYPE_ELEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_EVENT_ID, g_param_spec_uint ("EventID", "EventID", "EventID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_timer_instance_init (DVBTimer * self) {
	self->priv = DVB_TIMER_GET_PRIVATE (self);
}


static void dvb_timer_finalize (GObject* obj) {
	DVBTimer * self;
	self = DVB_TIMER (obj);
	_g_object_unref0 (self->priv->_Channel);
	_gst_object_unref0 (self->priv->_sink);
	G_OBJECT_CLASS (dvb_timer_parent_class)->finalize (obj);
}


/**
     * This class represents an event that should be recorded
     */
GType dvb_timer_get_type (void) {
	static volatile gsize dvb_timer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_timer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTimer), 0, (GInstanceInitFunc) dvb_timer_instance_init, NULL };
		GType dvb_timer_type_id;
		dvb_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBTimer", &g_define_type_info, 0);
		g_once_init_leave (&dvb_timer_type_id__volatile, dvb_timer_type_id);
	}
	return dvb_timer_type_id__volatile;
}


static void dvb_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		g_value_set_uint (value, dvb_timer_get_Id (self));
		break;
		case DVB_TIMER_CHANNEL:
		g_value_set_object (value, dvb_timer_get_Channel (self));
		break;
		case DVB_TIMER_DURATION:
		g_value_set_uint (value, dvb_timer_get_Duration (self));
		break;
		case DVB_TIMER_SINK:
		g_value_set_object (value, dvb_timer_get_sink (self));
		break;
		case DVB_TIMER_EVENT_ID:
		g_value_set_uint (value, dvb_timer_get_EventID (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		dvb_timer_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_CHANNEL:
		dvb_timer_set_Channel (self, g_value_get_object (value));
		break;
		case DVB_TIMER_DURATION:
		dvb_timer_set_Duration (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_SINK:
		dvb_timer_set_sink (self, g_value_get_object (value));
		break;
		case DVB_TIMER_EVENT_ID:
		dvb_timer_set_EventID (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




