/* SqliteUtils.c generated by valac, the Vala compiler
 * generated from SqliteUtils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



char* dvb_database_sqlite_utils_escape (const char* text);
char* dvb_database_sqlite_utils_unescape (const char* text);



char* dvb_database_sqlite_utils_escape (const char* text) {
	char* result = NULL;
	GError * _inner_error_;
	GRegex* regex;
	char* escaped_str;
	_inner_error_ = NULL;
	if (text == NULL) {
		result = g_strdup ("");
		return result;
	}
	regex = NULL;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("'", G_REGEX_MULTILINE, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (regex), _tmp1_);
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("SqliteUtils.vala:36: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			return result;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	escaped_str = NULL;
	{
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "''", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (escaped_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		escaped_str = (_tmp3_ = _tmp2_, _g_free0 (escaped_str), _tmp3_);
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("SqliteUtils.vala:45: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			_g_free0 (escaped_str);
			return result;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		_g_free0 (escaped_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = escaped_str;
	_g_regex_unref0 (regex);
	return result;
}


char* dvb_database_sqlite_utils_unescape (const char* text) {
	char* result = NULL;
	GError * _inner_error_;
	GRegex* regex;
	char* new_str;
	g_return_val_if_fail (text != NULL, NULL);
	_inner_error_ = NULL;
	regex = NULL;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("''", G_REGEX_MULTILINE, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (regex), _tmp1_);
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("SqliteUtils.vala:62: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			return result;
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	new_str = NULL;
	{
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "'", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			_g_free0 (new_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		new_str = (_tmp3_ = _tmp2_, _g_free0 (new_str), _tmp3_);
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("SqliteUtils.vala:71: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			_g_free0 (new_str);
			return result;
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		_g_free0 (new_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_str;
	_g_regex_unref0 (regex);
	return result;
}




