/* Settings.c generated by valac, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
typedef struct _DVBSettingsPrivate DVBSettingsPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DVBSettings {
	GObject parent_instance;
	DVBSettingsPrivate * priv;
};

struct _DVBSettingsClass {
	GObjectClass parent_class;
};

struct _DVBSettingsPrivate {
	GKeyFile* keyfile;
};


static gpointer dvb_settings_parent_class = NULL;

GType dvb_settings_get_type (void);
#define DVB_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SETTINGS, DVBSettingsPrivate))
enum  {
	DVB_SETTINGS_DUMMY_PROPERTY
};
#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
#define DVB_SETTINGS_DEFAULT_SETTINGS "[timers]\n" \
"        margin_start=5\n" \
"        margin_end=5\n" \
"        [epg]\n" \
"        scan_interval=30"
GFile* dvb_settings_get_settings_file (DVBSettings* self);
gboolean dvb_settings_load (DVBSettings* self);
gboolean dvb_settings_save (DVBSettings* self);
char* dvb_settings_get_string (DVBSettings* self, const char* group_name, const char* key, GError** error);
gboolean dvb_settings_get_boolean (DVBSettings* self, const char* group_name, const char* key, GError** error);
gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error);
double dvb_settings_get_double (DVBSettings* self, const char* group_name, const char* key, GError** error);
char** dvb_settings_get_string_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
gint* dvb_settings_get_integer_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
double* dvb_settings_get_double_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error);
void dvb_settings_set_string (DVBSettings* self, const char* group_name, const char* key, const char* val, GError** error);
void dvb_settings_set_boolean (DVBSettings* self, const char* group_name, const char* key, gboolean val, GError** error);
void dvb_settings_set_double (DVBSettings* self, const char* group_name, const char* key, double val, GError** error);
void dvb_settings_set_integer (DVBSettings* self, const char* group_name, const char* key, gint val, GError** error);
void dvb_settings_set_string_list (DVBSettings* self, const char* group_name, const char* key, char** val, int val_length1, GError** error);
void dvb_settings_set_boolean_list (DVBSettings* self, const char* group_name, const char* key, gboolean* val, int val_length1, GError** error);
void dvb_settings_set_double_list (DVBSettings* self, const char* group_name, const char* key, double* val, int val_length1, GError** error);
void dvb_settings_set_integer_list (DVBSettings* self, const char* group_name, const char* key, gint* val, int val_length1, GError** error);
DVBSettings* dvb_settings_new (void);
DVBSettings* dvb_settings_construct (GType object_type);
static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_settings_finalize (GObject* obj);



GFile* dvb_settings_get_settings_file (DVBSettings* self) {
	GFile* result = NULL;
	GFile* config_dir;
	GFile* our_config;
	GFile* settings_file;
	g_return_val_if_fail (self != NULL, NULL);
	config_dir = g_file_new_for_path (g_get_user_config_dir ());
	our_config = g_file_get_child (config_dir, "gnome-dvb-daemon");
	settings_file = g_file_get_child (our_config, "settings.ini");
	result = settings_file;
	_g_object_unref0 (config_dir);
	_g_object_unref0 (our_config);
	return result;
}


gboolean dvb_settings_load (DVBSettings* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GFile* settings_file;
	gboolean success;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	settings_file = dvb_settings_get_settings_file (self);
	success = TRUE;
	if (!g_file_query_exists (settings_file, NULL)) {
		GFileOutputStream* stream;
		stream = NULL;
		{
			GFileOutputStream* _tmp0_;
			GFileOutputStream* _tmp1_;
			_tmp0_ = g_file_create (settings_file, 0, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch178_g_error;
			}
			stream = (_tmp1_ = _tmp0_, _g_object_unref0 (stream), _tmp1_);
		}
		goto __finally178;
		__catch178_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp2_;
				g_critical ("Settings.vala:63: Could not create file %s: %s", _tmp2_ = g_file_get_path (settings_file), e->message);
				_g_free0 (_tmp2_);
				result = FALSE;
				_g_error_free0 (e);
				_g_object_unref0 (stream);
				_g_object_unref0 (settings_file);
				return result;
			}
		}
		__finally178:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			g_output_stream_write ((GOutputStream*) stream, DVB_SETTINGS_DEFAULT_SETTINGS, strlen (DVB_SETTINGS_DEFAULT_SETTINGS), NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch179_g_error;
			}
		}
		goto __finally179;
		__catch179_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp3_;
				g_critical ("Settings.vala:71: Could not write to file %s: %s", _tmp3_ = g_file_get_path (settings_file), e->message);
				_g_free0 (_tmp3_);
				success = FALSE;
				_g_error_free0 (e);
			}
		}
		__finally179:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch180_g_error;
			}
		}
		goto __finally180;
		__catch180_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("Settings.vala:79: %s", e->message);
				success = FALSE;
				_g_error_free0 (e);
			}
		}
		__finally180:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (stream);
	}
	if (success) {
		{
			char* _tmp4_;
			g_key_file_load_from_file (self->priv->keyfile, _tmp4_ = g_file_get_path (settings_file), 0, &_inner_error_);
			_g_free0 (_tmp4_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch181_g_key_file_error;
				}
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch181_g_file_error;
				}
				_g_object_unref0 (settings_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally181;
		__catch181_g_key_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("Settings.vala:88: Could not load settings: %s", e->message);
				success = FALSE;
				_g_error_free0 (e);
			}
		}
		goto __finally181;
		__catch181_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("Settings.vala:91: Could not load settings: %s", e->message);
				success = FALSE;
				_g_error_free0 (e);
			}
		}
		__finally181:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (settings_file);
	return result;
}


gboolean dvb_settings_save (DVBSettings* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GFile* settings_file;
	GFileOutputStream* stream;
	char* data;
	gsize data_len = 0UL;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	settings_file = dvb_settings_get_settings_file (self);
	stream = NULL;
	{
		GFileOutputStream* _tmp0_;
		GFileOutputStream* _tmp1_;
		_tmp0_ = g_file_replace (settings_file, NULL, TRUE, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch182_g_error;
		}
		stream = (_tmp1_ = _tmp0_, _g_object_unref0 (stream), _tmp1_);
	}
	goto __finally182;
	__catch182_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
			g_critical ("Settings.vala:106: Could not replace file %s: %s", _tmp2_ = g_file_get_path (settings_file), e->message);
			_g_free0 (_tmp2_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (settings_file);
			_g_object_unref0 (stream);
			return result;
		}
	}
	__finally182:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (settings_file);
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	data = NULL;
	data = (_tmp3_ = g_key_file_to_data (self->priv->keyfile, &data_len, NULL), _g_free0 (data), _tmp3_);
	{
		g_output_stream_write_all ((GOutputStream*) stream, data, data_len, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch183_g_error;
		}
	}
	goto __finally183;
	__catch183_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp4_;
			g_critical ("Settings.vala:118: Could not write to file %s: %s", _tmp4_ = g_file_get_path (settings_file), e->message);
			_g_free0 (_tmp4_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (settings_file);
			_g_object_unref0 (stream);
			_g_free0 (data);
			return result;
		}
	}
	__finally183:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (settings_file);
		_g_object_unref0 (stream);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch184_g_error;
		}
	}
	goto __finally184;
	__catch184_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Settings.vala:127: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally184:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (settings_file);
		_g_object_unref0 (stream);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_object_unref0 (settings_file);
	_g_object_unref0 (stream);
	_g_free0 (data);
	return result;
}


char* dvb_settings_get_string (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_tmp0_ = g_key_file_get_string (self->priv->keyfile, group_name, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}


gboolean dvb_settings_get_boolean (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = g_key_file_get_boolean (self->priv->keyfile, group_name, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	gint result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = g_key_file_get_integer (self->priv->keyfile, group_name, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


double dvb_settings_get_double (DVBSettings* self, const char* group_name, const char* key, GError** error) {
	double result = 0.0;
	GError * _inner_error_;
	double _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (group_name != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_inner_error_ = NULL;
	_tmp0_ = g_key_file_get_double (self->priv->keyfile, group_name, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	result = _tmp0_;
	return result;
}


char** dvb_settings_get_string_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	char** result = NULL;
	GError * _inner_error_;
	char** _tmp2_;
	gint __tmp1__size_;
	gint _tmp1__length1;
	gsize _tmp0_;
	char** _tmp1_;
	char** _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_tmp1_ = (_tmp2_ = g_key_file_get_string_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	gboolean* result = NULL;
	GError * _inner_error_;
	gboolean* _tmp2_;
	gint __tmp1__size_;
	gint _tmp1__length1;
	gsize _tmp0_;
	gboolean* _tmp1_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_tmp1_ = (_tmp2_ = g_key_file_get_boolean_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


gint* dvb_settings_get_integer_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	gint* result = NULL;
	GError * _inner_error_;
	gint* _tmp2_;
	gint __tmp1__size_;
	gint _tmp1__length1;
	gsize _tmp0_;
	gint* _tmp1_;
	gint* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_tmp1_ = (_tmp2_ = g_key_file_get_integer_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


double* dvb_settings_get_double_list (DVBSettings* self, const char* group_name, const char* key, int* result_length1, GError** error) {
	double* result = NULL;
	GError * _inner_error_;
	double* _tmp2_;
	gint __tmp1__size_;
	gint _tmp1__length1;
	gsize _tmp0_;
	double* _tmp1_;
	double* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_tmp1_ = (_tmp2_ = g_key_file_get_double_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp3_ = _tmp1_, *result_length1 = _tmp1__length1, _tmp3_);
	return result;
}


void dvb_settings_set_string (DVBSettings* self, const char* group_name, const char* key, const char* val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	g_key_file_set_string (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_boolean (DVBSettings* self, const char* group_name, const char* key, gboolean val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_double (DVBSettings* self, const char* group_name, const char* key, double val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_integer (DVBSettings* self, const char* group_name, const char* key, gint val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_string_list (DVBSettings* self, const char* group_name, const char* key, char** val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_string_list (self->priv->keyfile, group_name, key, (const gchar* const*) val, val_length1);
}


void dvb_settings_set_boolean_list (DVBSettings* self, const char* group_name, const char* key, gboolean* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_double_list (DVBSettings* self, const char* group_name, const char* key, double* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_integer_list (DVBSettings* self, const char* group_name, const char* key, gint* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer_list (self->priv->keyfile, group_name, key, val, val_length1);
}


DVBSettings* dvb_settings_construct (GType object_type) {
	DVBSettings * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBSettings* dvb_settings_new (void) {
	return dvb_settings_construct (DVB_TYPE_SETTINGS);
}


static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSettings * self;
	parent_class = G_OBJECT_CLASS (dvb_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SETTINGS (obj);
	{
		GKeyFile* _tmp0_;
		self->priv->keyfile = (_tmp0_ = g_key_file_new (), _g_key_file_free0 (self->priv->keyfile), _tmp0_);
	}
	return obj;
}


static void dvb_settings_class_init (DVBSettingsClass * klass) {
	dvb_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSettingsPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_settings_finalize;
}


static void dvb_settings_instance_init (DVBSettings * self) {
	self->priv = DVB_SETTINGS_GET_PRIVATE (self);
}


static void dvb_settings_finalize (GObject* obj) {
	DVBSettings * self;
	self = DVB_SETTINGS (obj);
	_g_key_file_free0 (self->priv->keyfile);
	G_OBJECT_CLASS (dvb_settings_parent_class)->finalize (obj);
}


GType dvb_settings_get_type (void) {
	static volatile gsize dvb_settings_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSettings), 0, (GInstanceInitFunc) dvb_settings_instance_init, NULL };
		GType dvb_settings_type_id;
		dvb_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSettings", &g_define_type_info, 0);
		g_once_init_leave (&dvb_settings_type_id__volatile, dvb_settings_type_id);
	}
	return dvb_settings_type_id__volatile;
}




