
#include <src/Cable/CableScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/MpegTsEnums.h"
#include "src/Cable/CableChannel.h"

typedef DBusGProxy DVBIDBusCableScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusCableScannerDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_cable_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_introspect (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_get (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_set (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_get_all (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_cable_scanner_frequency_scanned (GObject* _sender, guint frequency, DBusConnection* _connection);
static void _dbus_dvb_id_bus_cable_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_cable_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, DBusConnection* _connection);
static void dvb_id_bus_cable_scanner_dbus_proxy_Run (DVBIDBusCableScanner* self);
static void dvb_id_bus_cable_scanner_dbus_proxy_Destroy (DVBIDBusCableScanner* self);
static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path);
static guint dvb_id_bus_cable_scanner_dbus_proxy_GetQueueSize (DVBIDBusCableScanner* self);
static void dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
static gboolean dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path);
static void dvb_id_bus_cable_scanner_dbus_proxy_interface_init (DVBIDBusCableScannerIface* iface);
enum  {
	DVB_CABLE_SCANNER_DUMMY_PROPERTY
};
static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path);
static void dvb_cable_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_cable_scanner_parent_class = NULL;
void _dvb_cable_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_cable_scanner_introspect (DVBCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DVBIDBusCableScannerIface* dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_cable_scanner_dbus_path_vtable = {_dvb_id_bus_cable_scanner_dbus_unregister, dvb_id_bus_cable_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_cable_scanner_dbus_vtable = {dvb_id_bus_cable_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_cable_scanner_dbus_path_vtable = {_dvb_cable_scanner_dbus_unregister, dvb_cable_scanner_dbus_message};
static const _DBusObjectVTable _dvb_cable_scanner_dbus_vtable = {dvb_cable_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


guint dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->GetQueueSize (self);
}


void dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, modulation, symbol_rate, code_rate);
}


/**
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


void _dvb_id_bus_cable_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_introspect (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Cable\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetQueueSize\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"modulation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n    <arg name=\"code_rate\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_get (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_set (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_property_get_all (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Cable") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_cable_scanner_Run (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_cable_scanner_Destroy (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp5;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp6;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp5);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp5);
	result = dvb_id_bus_cable_scanner_WriteChannelsToFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp6 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp6);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint result;
	DBusMessage* reply;
	dbus_uint32_t _tmp7;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result = dvb_id_bus_cable_scanner_GetQueueSize (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_UINT32, &_tmp7);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency;
	dbus_uint32_t _tmp8;
	const char* modulation;
	const char* _tmp9;
	guint symbol_rate;
	dbus_uint32_t _tmp10;
	const char* code_rate;
	const char* _tmp11;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "usus")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp8);
	dbus_message_iter_next (&iter);
	frequency = _tmp8;
	modulation = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp9);
	dbus_message_iter_next (&iter);
	modulation = g_strdup (_tmp9);
	symbol_rate = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10);
	dbus_message_iter_next (&iter);
	symbol_rate = _tmp10;
	code_rate = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp11);
	dbus_message_iter_next (&iter);
	code_rate = g_strdup (_tmp11);
	dvb_id_bus_cable_scanner_AddScanningData (self, frequency, modulation, symbol_rate, code_rate);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp12;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp13;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp12);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp12);
	result = dvb_id_bus_cable_scanner_AddScanningDataFromFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp13 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp13);
	return reply;
}


DBusHandlerResult dvb_id_bus_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_cable_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		reply = _dbus_dvb_id_bus_cable_scanner_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		reply = _dbus_dvb_id_bus_cable_scanner_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_cable_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "Run")) {
		reply = _dbus_dvb_id_bus_cable_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "Destroy")) {
		reply = _dbus_dvb_id_bus_cable_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "WriteChannelsToFile")) {
		reply = _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "GetQueueSize")) {
		reply = _dbus_dvb_id_bus_cable_scanner_GetQueueSize (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "AddScanningData")) {
		reply = _dbus_dvb_id_bus_cable_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "AddScanningDataFromFile")) {
		reply = _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_cable_scanner_frequency_scanned (GObject* _sender, guint frequency, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp14;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp14);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_cable_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_cable_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp15;
	dbus_uint32_t _tmp16;
	const char* _tmp17;
	const char* _tmp18;
	const char* _tmp19;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp15 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp15);
	_tmp16 = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp16);
	_tmp17 = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17);
	_tmp18 = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18);
	_tmp19 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_cable_scanner_dbus_path_vtable, object);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_cable_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_cable_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_cable_scanner_channel_added, connection);
}


static void dvb_id_bus_cable_scanner_base_init (DVBIDBusCableScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING, G_TYPE_NONE, 5, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		g_type_set_qdata (DVB_TYPE_ID_BUS_CABLE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_cable_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_cable_scanner_get_type (void) {
	static GType dvb_id_bus_cable_scanner_type_id = 0;
	if (dvb_id_bus_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusCableScannerIface), (GBaseInitFunc) dvb_id_bus_cable_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_cable_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusCableScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_cable_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_cable_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusCableScannerDBusProxy, dvb_id_bus_cable_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CABLE_SCANNER, dvb_id_bus_cable_scanner_dbus_proxy_interface_init));
DVBIDBusCableScanner* dvb_id_bus_cable_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	return g_object_new (dvb_id_bus_cable_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Cable", NULL);
}


static void dvb_id_bus_cable_scanner_dbus_proxy_class_init (DVBIDBusCableScannerDBusProxyClass* klass) {
}


static void dvb_id_bus_cable_scanner_dbus_proxy_init (DVBIDBusCableScannerDBusProxy* self) {
}


static void dvb_id_bus_cable_scanner_dbus_proxy_Run (DVBIDBusCableScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_cable_scanner_dbus_proxy_Destroy (DVBIDBusCableScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp20;
	gboolean _result;
	dbus_bool_t _tmp21;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp20 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp20);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp21);
	dbus_message_iter_next (&_iter);
	_result = _tmp21;
	dbus_message_unref (_reply);
	return _result;
}


static guint dvb_id_bus_cable_scanner_dbus_proxy_GetQueueSize (DVBIDBusCableScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint _result;
	dbus_uint32_t _tmp22;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "GetQueueSize");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp22);
	dbus_message_iter_next (&_iter);
	_result = _tmp22;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp23;
	const char* _tmp24;
	dbus_uint32_t _tmp25;
	const char* _tmp26;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp23 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp23);
	_tmp24 = modulation;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp24);
	_tmp25 = symbol_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp25);
	_tmp26 = code_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp26);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp27;
	gboolean _result;
	dbus_bool_t _tmp28;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp27 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp27);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp28);
	dbus_message_iter_next (&_iter);
	_result = _tmp28;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_interface_init (DVBIDBusCableScannerIface* iface) {
	iface->Run = dvb_id_bus_cable_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_cable_scanner_dbus_proxy_Destroy;
	iface->WriteChannelsToFile = dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile;
	iface->GetQueueSize = dvb_id_bus_cable_scanner_dbus_proxy_GetQueueSize;
	iface->AddScanningData = dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile;
}


DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBCableScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device) {
	return dvb_cable_scanner_construct (DVB_TYPE_CABLE_SCANNER, device);
}


static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	DVBCableScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = (DVBCableScanner*) base;
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "inner-fec", G_TYPE_STRING, code_rate, "modulation", G_TYPE_STRING, modulation, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL) ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL));
}


static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path) {
	DVBCableScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp7;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("CableScanner.vala:50: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
		}
		_tmp1 = NULL;
		contents = (_tmp1 = _tmp0, contents = (g_free (contents), NULL), _tmp1);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally0:
	;
	if (contents == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp2);
	}
	/* line looks like:
	 C freq sr fec mod*/
	{
		char** line_collection;
		int line_collection_length1;
		char** line_it;
		line_collection = g_strsplit (contents, "\n", 0);
		line_collection_length1 = -1;
		for (line_it = line_collection; *line_it != NULL; line_it = line_it + 1) {
			const char* _tmp6;
			char* line;
			_tmp6 = NULL;
			line = (_tmp6 = *line_it, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
			{
				char** _tmp3;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				const char* _tmp4;
				char* modulation;
				guint symbol_rate;
				const char* _tmp5;
				char* code_rate;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp3 = NULL;
				cols = (_tmp3 = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = -1, _tmp3);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				_tmp4 = NULL;
				modulation = (_tmp4 = cols[4], (_tmp4 == NULL) ? NULL : g_strdup (_tmp4));
				symbol_rate = (guint) atoi (cols[2]);
				_tmp5 = NULL;
				code_rate = (_tmp5 = cols[3], (_tmp5 == NULL) ? NULL : g_strdup (_tmp5));
				dvb_id_bus_cable_scanner_AddScanningData ((DVBIDBusCableScanner*) self, freq, modulation, symbol_rate, code_rate);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				modulation = (g_free (modulation), NULL);
				code_rate = (g_free (code_rate), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return (_tmp7 = TRUE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp7);
}


static void dvb_cable_scanner_real_prepare (DVBScanner* base) {
	DVBCableScanner * self;
	GstElement* _tmp0;
	GstElement* dvbsrc;
	char** _tmp2;
	gint keys_length1;
	char** _tmp1;
	char** keys;
	self = (DVBCableScanner*) base;
	g_debug ("CableScanner.vala:87: Setting up pipeline for DVB-C scan");
	_tmp0 = NULL;
	dvbsrc = (_tmp0 = gst_bin_get_by_name ((GST_BIN (((DVBScanner*) self)->pipeline)), "dvbsrc"), (_tmp0 == NULL) ? NULL : gst_object_ref (_tmp0));
	_tmp2 = NULL;
	_tmp1 = NULL;
	keys = (_tmp2 = (_tmp1 = g_new0 (char*, 2 + 1), _tmp1[0] = g_strdup ("frequency"), _tmp1[1] = g_strdup ("symbol-rate"), _tmp1), keys_length1 = 2, _tmp2);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; ((keys_length1 != -1) && (key_it < keys_length1)) || ((keys_length1 == -1) && (key_collection[key_it] != NULL)); key_it = key_it + 1) {
			const char* _tmp3;
			char* key;
			_tmp3 = NULL;
			key = (_tmp3 = key_collection[key_it], (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
			{
				dvb_scanner_set_uint_property (dvbsrc, ((DVBScanner*) self)->current_tuning_params, key);
				key = (g_free (key), NULL);
			}
		}
	}
	g_object_set ((GObject*) dvbsrc, "modulation", dvb_get_modulation_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "modulation")), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "inner-fec")), NULL);
	(dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL));
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}


static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBCableScanner * self;
	guint freq;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	/* TODO*/
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	return dvb_scanned_item_new (freq);
}


static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base) {
	DVBCableScanner * self;
	self = (DVBCableScanner*) base;
	return (DVBChannel*) dvb_cable_channel_new ();
}


static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBCableScanner * self;
	DVBCableChannel* _tmp0;
	DVBCableChannel* cc;
	guint freq;
	guint symbol_rate;
	self = (DVBCableScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!(DVB_IS_CABLE_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	cc = (_tmp0 = DVB_CABLE_CHANNEL (channel), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	/* structure doesn't contain information about inversion
	 set it to auto*/
	dvb_cable_channel_set_Inversion (cc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	dvb_cable_channel_set_Modulation (cc, dvb_get_modulation_val (gst_structure_get_string (delivery, "modulation")));
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) cc, freq);
	symbol_rate = 0U;
	gst_structure_get_uint (delivery, "symbol-rate", &symbol_rate);
	dvb_cable_channel_set_SymbolRate (cc, symbol_rate);
	dvb_cable_channel_set_CodeRate (cc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "inner-fec")));
	(cc == NULL) ? NULL : (cc = (g_object_unref (cc), NULL));
}


void _dvb_cable_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_cable_scanner_introspect (DVBCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Cable\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetQueueSize\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"modulation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n    <arg name=\"code_rate\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_cable_scanner_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_cable_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_cable_scanner_dbus_path_vtable, object);
	}
	dvb_id_bus_cable_scanner_dbus_register_object (connection, path, object);
}


static void dvb_cable_scanner_class_init (DVBCableScannerClass * klass) {
	dvb_cable_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_cable_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_cable_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_cable_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_cable_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_CABLE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_cable_scanner_dbus_vtable));
}


static void dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init (DVBIDBusCableScannerIface * iface) {
	dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_cable_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_cable_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
	iface->GetQueueSize = dvb_scanner_GetQueueSize;
}


static void dvb_cable_scanner_instance_init (DVBCableScanner * self) {
}


GType dvb_cable_scanner_get_type (void) {
	static GType dvb_cable_scanner_type_id = 0;
	if (dvb_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableScanner), 0, (GInstanceInitFunc) dvb_cable_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_cable_scanner_info = { (GInterfaceInitFunc) dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_cable_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBCableScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_cable_scanner_type_id, DVB_TYPE_ID_BUS_CABLE_SCANNER, &dvb_id_bus_cable_scanner_info);
	}
	return dvb_cable_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	vtable->register_object (connection, path, object);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), data2);
}



