
#include <src/Main.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gst/gst.h>
#include <stdio.h>
#include <gee/arraylist.h>
#include "src/Manager.h"
#include "src/RecordingsStore.h"
#include "src/Constants.h"
#include "src/GConfStore.h"
#include "src/DeviceGroup.h"
#include "src/Recorder.h"
#include "src/Timer.h"
#include <gobject/gvaluecollector.h>




enum  {
	MAIN_DUMMY_PROPERTY
};
static DVBManager* main_manager;
static DVBRecordingsStore* main_recstore;
static gboolean main_has_debug;
static gboolean main_has_version;
static gboolean main_disable_epg_scanner;
guint _dynamic_RequestName0 (DBusGProxy* obj, const char* param1, guint param2, GError** error);
static gboolean main_start_manager (void);
static gboolean main_start_recordings_store (guint32 minimum_id);
static gpointer main_parent_class = NULL;
static void main_finalize (Main* obj);

static const GOptionEntry MAIN_options[] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &main_has_debug, "Display debug statements on stdout", NULL}, {"version", ((gchar) (0)), 0, G_OPTION_ARG_NONE, &main_has_version, "Display version number", NULL}, {"disable-epg-scanner", ((gchar) (0)), 0, G_OPTION_ARG_NONE, &main_disable_epg_scanner, "Disable scanning for EPG data", NULL}, {NULL}};


guint _dynamic_RequestName0 (DBusGProxy* obj, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (obj, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if ((*error)) {
		return 0U;
	}
	return result;
}


static gboolean main_start_manager (void) {
	GError * inner_error;
	inner_error = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch17_g_error;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		/* try to register service in session bus*/
		request_name_result = _dynamic_RequestName0 (bus, DVB_CONSTANTS_DBUS_SERVICE, ((guint) (0)), &inner_error);
		if (inner_error != NULL) {
			goto __catch17_g_error;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			DVBManager* _tmp1;
			DVBManager* _tmp0;
			g_debug ("Main.vala:33: Creating new Manager D-Bus service");
			_tmp1 = NULL;
			_tmp0 = NULL;
			main_manager = (_tmp1 = (_tmp0 = dvb_manager_get_instance (), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (main_manager == NULL ? NULL : (main_manager = (g_object_unref (main_manager), NULL))), _tmp1);
			dbus_g_connection_register_g_object (conn, DVB_CONSTANTS_DBUS_MANAGER_PATH, G_OBJECT (main_manager));
		} else {
			gboolean _tmp2;
			g_debug ("Main.vala:41: Manager D-Bus service is already running");
			return (_tmp2 = FALSE, (conn == NULL ? NULL : (conn = (dbus_g_connection_unref (conn), NULL))), (bus == NULL ? NULL : (bus = (g_object_unref (bus), NULL))), _tmp2);
		}
		(conn == NULL ? NULL : (conn = (dbus_g_connection_unref (conn), NULL)));
		(bus == NULL ? NULL : (bus = (g_object_unref (bus), NULL)));
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp3;
			g_error ("Main.vala:46: Oops %s", e->message);
			return (_tmp3 = FALSE, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), _tmp3);
		}
	}
	__finally17:
	;
	return TRUE;
}


static gboolean main_start_recordings_store (guint32 minimum_id) {
	GError * inner_error;
	inner_error = NULL;
	g_debug ("Main.vala:54: Creating new RecordingsStore D-Bus service");
	{
		DBusGConnection* conn;
		DVBRecordingsStore* _tmp1;
		DVBRecordingsStore* _tmp0;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch18_g_error;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		main_recstore = (_tmp1 = (_tmp0 = dvb_recordings_store_get_instance (), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (main_recstore == NULL ? NULL : (main_recstore = (g_object_unref (main_recstore), NULL))), _tmp1);
		dvb_recordings_store_update_last_id (main_recstore, minimum_id);
		dbus_g_connection_register_g_object (conn, DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH, G_OBJECT (main_recstore));
		(conn == NULL ? NULL : (conn = (dbus_g_connection_unref (conn), NULL)));
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp2;
			g_error ("Main.vala:66: Oops %s", e->message);
			return (_tmp2 = FALSE, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), _tmp2);
		}
	}
	__finally18:
	;
	return TRUE;
}


gint main_main (char** args, int args_length1) {
	GError * inner_error;
	GMainLoop* loop;
	GOptionContext* context;
	GMainLoop* _tmp2;
	guint32 max_id;
	DVBGConfStore* gconf;
	GeeArrayList* device_groups;
	gint _tmp5;
	inner_error = NULL;
	loop = NULL;
	context = g_option_context_new ("- record TV shows using one or more DVB adapters");
	g_option_context_add_main_entries (context, MAIN_options, NULL);
	g_option_context_add_group (context, gst_init_get_option_group ());
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_OPTION_ERROR) {
				goto __catch19_g_option_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
	}
	goto __finally19;
	__catch19_g_option_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp0;
			fprintf (stderr, "%s\n", e->message);
			fprintf (stderr, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			return (_tmp0 = 1, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), (context == NULL ? NULL : (context = (g_option_context_free (context), NULL))), _tmp0);
		}
	}
	__finally19:
	;
	if (main_has_version) {
		gint _tmp1;
		fprintf (stdout, PACKAGE_NAME);
		fprintf (stdout, " %s\n", PACKAGE_VERSION);
		return (_tmp1 = 0, (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), (context == NULL ? NULL : (context = (g_option_context_free (context), NULL))), _tmp1);
	}
	/* Creating a GLib main loop with a default context*/
	_tmp2 = NULL;
	loop = (_tmp2 = g_main_loop_new (NULL, FALSE), (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), _tmp2);
	/* Initializing GStreamer*/
	gst_init (&args_length1, &args);
	if (!main_start_manager ()) {
		gint _tmp3;
		return (_tmp3 = -1, (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), (context == NULL ? NULL : (context = (g_option_context_free (context), NULL))), _tmp3);
	}
	max_id = ((guint32) (0));
	gconf = dvb_gconf_store_get_instance ();
	device_groups = dvb_gconf_store_get_all_device_groups (gconf);
	{
		GeeArrayList* device_group_collection;
		int device_group_it;
		device_group_collection = device_groups;
		for (device_group_it = 0; device_group_it < gee_collection_get_size (GEE_COLLECTION (device_group_collection)); device_group_it = device_group_it + 1) {
			DVBDeviceGroup* device_group;
			device_group = ((DVBDeviceGroup*) (gee_list_get (GEE_LIST (device_group_collection), device_group_it)));
			{
				if (dvb_manager_add_device_group (main_manager, device_group)) {
					DVBRecorder* rec;
					GeeArrayList* timers;
					if (!main_disable_epg_scanner) {
						dvb_manager_create_and_start_epg_scanner (main_manager, device_group);
					}
					rec = dvb_manager_get_recorder_for_device_group (main_manager, device_group);
					/* Restore timers*/
					timers = dvb_gconf_store_get_all_timers_of_device_group (gconf, device_group);
					{
						GeeArrayList* t_collection;
						int t_it;
						t_collection = timers;
						for (t_it = 0; t_it < gee_collection_get_size (GEE_COLLECTION (t_collection)); t_it = t_it + 1) {
							DVBTimer* t;
							t = ((DVBTimer*) (gee_list_get (GEE_LIST (t_collection), t_it)));
							{
								if (dvb_timer_get_Id (t) > max_id) {
									max_id = dvb_timer_get_Id (t);
								}
								if (dvb_recorder_add_timer (rec, t) == 0) {
									dvb_gconf_store_remove_timer_from_device_group (gconf, ((guint) (dvb_timer_get_Id (t))), device_group);
								}
								(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
							}
						}
					}
					(rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL)));
					(timers == NULL ? NULL : (timers = (g_object_unref (timers), NULL)));
				}
				(device_group == NULL ? NULL : (device_group = (g_object_unref (device_group), NULL)));
			}
		}
	}
	if (!main_start_recordings_store (max_id)) {
		gint _tmp4;
		return (_tmp4 = -1, (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), (context == NULL ? NULL : (context = (g_option_context_free (context), NULL))), (gconf == NULL ? NULL : (gconf = (g_object_unref (gconf), NULL))), (device_groups == NULL ? NULL : (device_groups = (g_object_unref (device_groups), NULL))), _tmp4);
	}
	/* Start GLib mainloop*/
	g_main_loop_run (loop);
	return (_tmp5 = 0, (loop == NULL ? NULL : (loop = (g_main_loop_unref (loop), NULL))), (context == NULL ? NULL : (context = (g_option_context_free (context), NULL))), (gconf == NULL ? NULL : (gconf = (g_object_unref (gconf), NULL))), (device_groups == NULL ? NULL : (device_groups = (g_object_unref (device_groups), NULL))), _tmp5);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return main_main (argv, argc);
}


Main* main_construct (GType object_type) {
	Main* self;
	self = ((Main*) (g_type_create_instance (object_type)));
	return self;
}


Main* main_new (void) {
	return main_construct (TYPE_MAIN);
}


static void value_main_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_unref (value->data[0].v_pointer);
	}
}


static void value_main_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Main* object;
		object = value->data[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_OBJECT_TYPE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", G_OBJECT_TYPE (object), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Main** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMain* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN), NULL);
	return value->data[0].v_pointer;
}


void value_set_main (GValue* value, gpointer v_object) {
	Main* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_unref (old);
	}
}


static void main_class_init (MainClass * klass) {
	main_parent_class = g_type_class_peek_parent (klass);
	MAIN_CLASS (klass)->finalize = main_finalize;
}


static void main_instance_init (Main * self) {
	self->ref_count = 1;
}


static void main_finalize (Main* obj) {
	Main * self;
	self = MAIN (obj);
}


GType main_get_type (void) {
	static GType main_type_id = 0;
	if (main_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_main_init, value_main_free_value, value_main_copy_value, value_main_peek_pointer, "p", value_main_collect_value, "p", value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Main", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return main_type_id;
}


gpointer main_ref (gpointer instance) {
	Main* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_unref (gpointer instance) {
	Main* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_GET_CLASS (self)->finalize (self);
		g_type_free_instance (((GTypeInstance *) (self)));
	}
}




