// $Id: entry.h,v 1.3 2002/02/17 18:53:39 murrayc Exp $ -*- c++ -*-

/* entry.h
 *
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GCONFMM_ENTRY_H
#define GCONFMM_ENTRY_H

extern "C"
{
#include <gconf/gconf-value.h> //for GConfEntry
}

#include <gconfmm/value.h>

namespace Gnome
{

namespace Conf
{


class Entry
{
public:
  Entry();
  Entry(const Glib::ustring& key, const Value& val);
  explicit Entry(const GConfEntry* pEntry);
  Entry(const Entry& Entry);
  Entry::~Entry();

  Entry& operator=(const Entry& src);

  //GConfValue* gconf_entry_steal_value      (GConfEntry  *entry);

  void set_value(const Value& val);
  void set_schema_name(const Glib::ustring& name);
  void set_is_default(bool is_default = true);
  void set_is_writable(bool is_writable = true);

  Glib::ustring get_key() const;
  Value get_value() const;
  Glib::ustring get_schema_name() const;
  bool get_is_default() const;
  bool get_is_writable() const;

  GConfEntry* Entry::gobj();
  const GConfEntry* Entry::gobj() const;

protected:
  void clear();

  GConfEntry* m_pEntry;
};


} /* namespace Conf */
} /* namespace Gnome */

#endif //GCONFMM_ENTRY_H
