// $Id: callback.h,v 1.2 2002/02/17 18:53:39 murrayc Exp $ -*- c++ -*-

/* callback.h
 *
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GCONFMM_CALLBACK_H
#define GCONFMM_CALLBACK_H

extern "C"
{
#include <gconf/gconf-client.h>
}

#include <glibmm/object.h>
#include <gconfmm/entry.h>

namespace Gnome
{

namespace Conf
{

typedef SigC::Slot2<void, guint, Entry> Callback;

class Client;

class CallbackHolder
{
public:

  CallbackHolder(Callback slot);
  ~CallbackHolder();

  void add(Client* pObj);

  Callback m_Slot;

  static void destroy (void *data);
  static void call (GConfClient *client, guint i, GConfEntry *entry, void *data);  
};

} /* namespace Conf */
} /* namespace Gnome */

#endif //GCONFMM_CALLBACK_H
