import pygtk
pygtk.require('2.0')
import gtk
import os.path
import sys

# put gazpacho in sys.path so we don't need to update PYTHONPATH
currentdir = os.path.dirname(os.path.abspath(sys.argv[0]))
prefix = os.path.abspath(os.path.join(currentdir, '..'))
localmode = False
if 'setup.py' in os.listdir(prefix):
    if prefix not in sys.path:
        sys.path.insert(0, prefix)
    localmode = True
else:
    major, minor = sys.version_info[0], sys.version_info[1]
    dir = os.path.join(prefix, 'lib', 'python%d.%d' % (major, minor),
                       'site-packages')
    if dir not in sys.path:
        sys.path.append(dir)

if localmode:
    from gazpacho import path
    path.xml_dir = os.path.join(prefix, 'xml')
    path.pixmaps_dir = os.path.join(prefix, 'pixmaps')
    path.languages_dir = os.path.join(prefix, 'locale')

from gazpacho import application, command, gladegtk, placeholder

def init_gazpacho():
    gazpacho = application.Application()
    gladegtk.init_gladegtk(gazpacho)
    gazpacho.show_all()
    gazpacho.new_project()
    project = gazpacho.get_current_project()
    refresh_gui()
    return gazpacho, project

def refresh_gui():
    while gtk.events_pending():
        gtk.main_iteration_do(block=gtk.FALSE)

