// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_H
#define _CLUTTERMM_ACTOR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <pangomm/context.h>
#include <pangomm/layout.h>
#include <cluttermm/animation.h>
#include <cluttermm/color.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/shader.h>
#include <cluttermm/types.h> // For Event*
#include <clutter/clutter.h> // For ClutterActorBox
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActor ClutterActor;
typedef struct _ClutterActorClass ClutterActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Actor_Class; } // namespace Clutter
namespace Clutter
{

class Animation;

class ActorBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ActorBox CppObjectType;
  typedef ClutterActorBox BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ActorBox();

  explicit ActorBox(const ClutterActorBox* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterActorBox*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterActorBox* gobj() const { return &gobject_; }

protected:
  ClutterActorBox gobject_;

private:
  
public:
  ActorBox(Unit x1, Unit y1, Unit x2, Unit y2);

   Unit get_x1() const;
    void set_x1(const Unit& value);
    Unit get_y1() const;
    void set_y1(const Unit& value);
    Unit get_x2() const;
    void set_x2(const Unit& value);
    Unit get_y2() const;
    void set_y2(const Unit& value);
 

};

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ActorFlags operator|(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator&(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator^(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator~(ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator|=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator&=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator^=(ActorFlags&, ActorFlags)</tt><br>
 */
enum ActorFlags
{
  ACTOR_MAPPED = 1 << 1,
  ACTOR_REALIZED = 1 << 2,
  ACTOR_REACTIVE = 1 << 3
};

/** @ingroup cluttermmEnums */
inline ActorFlags operator|(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator&(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator^(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator~(ActorFlags flags)
  { return static_cast<ActorFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator|=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator&=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator^=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ActorFlags> : public Glib::Value_Flags<Clutter::ActorFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Actor : public Glib::Object, public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Actor CppObjectType;
  typedef Actor_Class CppClassType;
  typedef ClutterActor BaseObjectType;
  typedef ClutterActorClass BaseClassType;

private:  friend class Actor_Class;
  static CppClassType actor_class_;

private:
  // noncopyable
  Actor(const Actor&);
  Actor& operator=(const Actor&);

protected:
  explicit Actor(const Glib::ConstructParams& construct_params);
  explicit Actor(ClutterActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Actor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActor*       gobj()       { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActor* gobj() const { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActor* gobj_copy();

private:

  
protected:
  Actor();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  void set_flags(ActorFlags flags);
  void unset_flags(ActorFlags flags);
   ActorFlags get_flags() const;
 
  bool is_mapped() const;
  bool is_realized() const;
  bool is_visible() const;
  bool is_reactive() const;

  
  void show();
  
  void show_all();
  
  /** Flags an actor to be hidden. A hidden actor will not be
   * rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor:show-on-set-parent property will be set to <tt>false</tt>
   * as a side-effect.
   */
  void hide();
  
  void hide_all();
  
  void realize();
  
  void unrealize();
  
  void paint();
  
  void queue_redraw();
  
  void queue_relayout();

   
  //TODO: Check that we don't want to wrap this: _WRAP_METHOD(void destroy(), clutter_actor_destroy)
  //__IGNORE(clutter_actor_destroy)

  
  Glib::RefPtr<Pango::Context> get_pango_context();
  
  Glib::RefPtr<const Pango::Context> get_pango_context() const;
  
  Glib::RefPtr<Pango::Context> create_pango_context();

  
  Glib::RefPtr<Pango::Layout> create_pango_layout(const Glib::ustring& text);

  
  Glib::RefPtr<Actor> get_stage();
  
  Glib::RefPtr<const Actor> get_stage() const;
 

  void set_geometry(const Geometry& geometry);
  

  Geometry get_geometry() const;
  //_WRAP_METHOD(void get_coords(int *x_1, int *y_1, int *x_2, int *y_2) const, clutter_actor_get_coords)
  
  void set_size(int width, int height);
  
  void set_sizeu(Unit width, Unit height);
  
  void get_position(int& x, int& y);
  
  void get_positionu(Unit& x, Unit& y);
  
  void set_position(int x, int y);
  
  void set_positionu(Unit x, Unit y);
  //_WRAP_METHOD(void get_abs_position(int& x, int& y) const, clutter_actor_get_abs_position)
  
  guint get_width() const;
  
  Unit get_widthu() const;
  
  guint get_height() const;
  
  Unit get_heightu() const;
  
  void set_width(guint width);
  
  void set_widthu(Unit width);
  
  void set_height(guint height);
  
  /** Forces a height on an actor, causing the actor's preferred width
   * and height (if any) to be ignored.
   * 
   * This function sets both the minimum and natural size of the actor.
   * 
   * since: 0.6
   * @param height Requested new height for the actor, in Clutter::Unit<!-- -->s.
   */
  void set_heightu(Unit height);

  
  void set_x(int x);
  
  void set_xu(Unit x);
  
  int get_x() const;
  
  Unit get_xu() const;
  
  void set_y(int y);
  
  void set_yu(Unit y);
  
  int get_y() const;
  
  Unit get_yu() const;
  
  void set_reactive(bool reactive = true);
  
  bool get_reactive() const;

  
  void set_rotation(RotateAxis axis, double angle, int x, int y, int z);
  
  void set_rotationu(RotateAxis axis, double angle, Unit x, Unit y, Unit z);
  
  void set_z_rotation_from_gravity(double angle, Gravity gravity);
  
  double get_rotation(RotateAxis axis, int& x, int& y, int& z) const;
  
  double get_rotationu(RotateAxis axis, Unit& x, Unit& y, Unit& z) const;
  
  Gravity get_z_rotation_gravity() const;
  
  void set_opacity(guint8 opacity);
  
  guint8 get_opacity() const;
  
  void set_name(const gchar *name);
  
  Glib::ustring get_name() const;
  
  guint32 get_gid() const;
  
  void set_clip(int xoff, int yoff, int width, int height);
  
  void get_clip(int& xoff, int& yoff, int& width, int& height);
  
  /** Unit-based variant of set_clip()
   * 
   * Sets clip area for @a self. The clip area is always computed from the
   * upper left corner of the actor, even if the anchor point is set
   * otherwise.
   * 
   * Since: 0.6
   * @param xoff X offset of the clip rectangle, in Clutter::Unit<!-- -->s.
   * @param yoff Y offset of the clip rectangle, in Clutter::Unit<!-- -->s.
   * @param width Width of the clip rectangle, in Clutter::Unit<!-- -->s.
   * @param height Height of the clip rectangle, in Clutter::Unit<!-- -->s.
   */
  void set_clipu(Unit xoff, Unit yoff, Unit width, Unit height);
  
  void get_clipu(Unit& xoff, Unit& yoff, Unit& width, Unit& height);
  
  void remove_clip();
  
  bool has_clip() const;
  
  /** Sets the parent of @a self to @a parent.  The opposite function is
   * unparent().
   * 
   * This function should not be used by applications, but by custom
   * container actor subclasses.
   * @param parent A new Clutter::Actor parent.
   */
  void set_parent(const Glib::RefPtr<Actor>& parent);
  
  Glib::RefPtr<Actor> get_parent();
  
  Glib::RefPtr<const Actor> get_parent() const;
  
  void reparent(const Glib::RefPtr<Actor>& new_parent);
  
  void unparent();
  
  /** Puts @a self above @a below.
   * 
   * Both actors must have the same parent.
   * 
   * This function is the equivalent of Clutter::Container::raise_child().
   * @param below (allow-none): A Clutter::Actor to raise above.
   */
  void raise(const Glib::RefPtr<Actor>& below);
  
  void lower(const Glib::RefPtr<Actor>& above);
  
  void raise_top ();
  
  void lower_bottom();

  
  /** Queries the currently set Clutter::Shader on @a self.
   * @return (transfer none): The currently set Clutter::Shader or <tt>0</tt> if no
   * shader is set.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<Shader> get_shader();
  
  /** Queries the currently set Clutter::Shader on @a self.
   * @return (transfer none): The currently set Clutter::Shader or <tt>0</tt> if no
   * shader is set.
   * 
   * Since: 0.6.
   */
  Glib::RefPtr<const Shader> get_shader() const;
  
  void set_shader(const Glib::RefPtr<Shader>& shader);
  

  template <class ParamType> void set_shader_param(const Glib::ustring& param, const ParamType& value);
  
  //_WRAP_METHOD_DOCS_ONLY(clutter_actor_get_paint_area)
  //ActorBox get_paint_area() const;
  
  bool is_rotated() const;
  
  bool is_scaled() const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts (out) (array): return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void get_allocation_vertices(Vertex vertices[4]) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts (out) (array): return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void get_allocation_vertices(const Glib::RefPtr<Actor>& ancestor, Vertex vertices[4]) const;
  

  void get_abs_allocation_vertices(Vertex vertices[4]) const;
  

  ActorBox get_allocation_box() const;
 

  void allocate(const ActorBox& box, bool absolute_origin_changed);
  
  void allocate(bool absolute_origin_changed);

 
  void apply_relative_transform_to_point(const Glib::RefPtr<Actor>& ancestor, const Vertex& point, Vertex& vertex) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * Since: 0.6
   * @param ancestor A Clutter::Actor to calculate the vertices against, or <tt>0</tt>
   * to use the default Clutter::Stage.
   * @param verts (out) (array): return location for an array of 4 Clutter::Vertex in which
   * to store the result.
   */

  void apply_relative_transform_to_point(const Vertex& point, Vertex& vertex) const;

  
  void get_preferred_size(Unit& min_width_p, Unit& min_height_p, Unit& natural_width_p, Unit& natural_height_p) const;
  
  void get_preferred_width(Unit for_height, Unit& min_width_p, Unit& natural_width_p) const;
  
  void get_preferred_height(Unit for_width, Unit& min_height_p, Unit& natural_height_p) const;
  
  guint8 get_paint_opacity() const;
  
  bool get_paint_visibility() const;
  
  void move_anchor_point_from_gravity(Gravity gravity);
  
  void move_anchor_point(int anchor_x, int anchor_y);
  
  void move_anchor_pointu(Unit anchor_x, Unit anchor_y);

  
  bool get_fixed_position_set() const;
  
  void set_fixed_position_set(bool is_set);
  
  void get_transformed_position(int& x, int& y) const;
  
  void get_transformed_positionu(Unit& x, Unit& y) const;
  
  void get_transformed_size(guint& width, guint& height) const;
  
  void get_transformed_sizeu(Unit& width, Unit& height) const;
  
  void get_allocation_coords(int& x1, int& y1, int& x2, int& y2) const;
  

  Geometry get_allocation_geometry() const;

  
  void set_depth(int depth);
  
  void set_depthu(Unit depth);
  
  int get_depth() const;
  
  Unit get_depthu() const;
  
  /** Scales an actor with the given factors. The scaling is relative to
   * the scale center and the anchor point. The scale center is
   * unchanged by this function and defaults to 0,0.
   * 
   * Since: 0.2
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   */
  void set_scale(double scale_x, double scale_y);
  
  void set_scale_full(double scale_x, double scale_y, int center_x, int center_y);
  
  void set_scale_fullu(double scale_x, double scale_y, Unit center_x, Unit center_y);
  
  void set_scale_with_gravity(double scale_x, double scale_y, Gravity gravity);
  
  void get_scale(double& scale_x, double& scale_y) const;
  
  void get_scale_center(int& center_x, int& center_y) const;
  
  void get_scale_centeru(Unit& center_x, Unit& center_y) const;
  
  Gravity get_scale_gravity() const;

  //_WRAP_METHOD(void get_abs_size(guint& width, guint& height) const, clutter_actor_get_abs_size)
  
  void get_size(guint& width, guint& height) const;
  
  void get_sizeu(Unit& width, Unit& height) const;
  
  void move_by(int dx, int dy);
  
  void move_byu(Unit dx, Unit dy);

  
  void apply_transform_to_point(const Vertex& point, Vertex& vertex) const;
  
  void transform_stage_point(Unit x, Unit y, Unit& x_out, Unit& y_out) const;

  
  bool event(ClutterEvent* event, bool capture);
  
  static Glib::RefPtr<Actor> get_actor_by_gid(guint32 id);

  
  void set_anchor_point(int anchor_x, int anchor_y);
  
  void get_anchor_point(int& anchor_x, int& anchor_y) const;
  
  void set_anchor_pointu(Unit anchor_x, Unit anchor_y);
  
  void get_anchor_pointu(Unit& anchor_x, Unit& anchor_y);
  
  void set_anchor_point_from_gravity(ClutterGravity gravity);
  
  Gravity get_anchor_point_gravity();

  // These are needed by custom container implementations and therefore public.
  
  void pick(const Color& color);
  
  bool should_pick_paint() const;

  
  void grab_key_focus();

// Animation API
  // Hand coded to use std::map instead of the 3 arguments used by C API
  

  //TODO: Documentation.
  Glib::RefPtr<Animation> animate(gulong mode, unsigned int duration, const std::map<std::string, Glib::ValueBase>& properties);
  Glib::RefPtr<Animation> animate(gulong mode, const Glib::RefPtr<Timeline>& timeline, const std::map<std::string, Glib::ValueBase>& properties);
  Glib::RefPtr<Animation> animate(const Glib::RefPtr<Alpha>& alpha, const std::map<std::string, Glib::ValueBase>& properties);
  
  
  Glib::RefPtr<Animation> get_animation();
  
  Glib::RefPtr<const Animation> get_animation() const;

// signals
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_event(MotionEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,MotionEvent* > signal_motion_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_leave_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%show()</tt>
   */

  Glib::SignalProxy0< void > signal_show();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%hide()</tt>
   */

  Glib::SignalProxy0< void > signal_hide();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%destroy()</tt>
   */

  Glib::SignalProxy0< void > signal_destroy();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_enter_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_out()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_out();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_in()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_in();

 
  /**
   * @par Prototype:
   * <tt>void on_my_%parent_set(const Glib::RefPtr<Actor>& old_parent)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_parent_set();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%scroll_event(ScrollEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ScrollEvent* > signal_scroll_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%captured_event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_captured_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paint()</tt>
   */

  Glib::SignalProxy0< void > signal_paint();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%queue_redaw(const Glib::RefPtr<Actor>& origin)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_queue_redaw();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%realize()</tt>
   */

  Glib::SignalProxy0< void > signal_realize();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unrealize()</tt>
   */

  Glib::SignalProxy0< void > signal_unrealize();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ActorBox> property_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_anchor_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_anchor_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_anchor_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_anchor_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Geometry> property_clip() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Geometry> property_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Depth of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_depth() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Depth of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_depth() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fixed_position_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fixed_position_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_fixed_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_fixed_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_fixed_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_fixed_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor has a clip set or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_min_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_min_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_height_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_height_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_min_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_min_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_width_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_width_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint8> property_opacity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint8> property_opacity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_reactive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_reactive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RequestMode> property_request_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RequestMode> property_request_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_on_set_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_on_set_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  
  void set_shader_param_value(const Glib::ustring& param, const Glib::ValueBase& value);

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void show_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void hide_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  // TODO: I think we need to hand-code the vfuncs if we need to handle
  // the ClutterUnit* being NULL.
   

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void pick_vfunc(const Color& color);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_width_vfunc(Unit for_height, Unit& min_width_p, Unit& natural_width_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_height_vfunc(Unit for_width, Unit& min_height_p, Unit& natural_height_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void allocate_vfunc(const ActorBox& box, bool absolute_origin_changed);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_button_press_event(ButtonEvent* event);
  virtual bool on_button_release_event(ButtonEvent* event);
  virtual bool on_motion_event(MotionEvent* event);
  virtual bool on_leave_event(CrossingEvent* event);
  virtual void on_show();
  virtual void on_hide();
  virtual void on_destroy();
  virtual bool on_key_release_event(KeyEvent* event);
  virtual bool on_enter_event(CrossingEvent* event);
  virtual bool on_event(Event* event);
  virtual void on_focus_out();
  virtual void on_focus_in();
  virtual void on_parent_set(const Glib::RefPtr<Actor>& old_parent);
  virtual bool on_scroll_event(ScrollEvent* event);
  virtual bool on_key_press_event(KeyEvent* event);
  virtual bool on_captured_event(Event* event);
  virtual void on_paint();
  virtual void on_queue_redaw(const Glib::RefPtr<Actor>& origin);
  virtual void on_realize();
  virtual void on_unrealize();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ParamType>
void Actor::set_shader_param(const Glib::ustring& param, const ParamType& value)
{
  Glib::Value<ParamType> param_value;
  param_value.init(Glib::Value<ParamType>::value_type());

  param_value.set(value);
  this->set_shader_param_value(param, param_value);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Clutter


namespace Glib
{

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::ActorBox& wrap(ClutterActorBox* object);

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::ActorBox& wrap(const ClutterActorBox* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::ActorBox> : public Glib::Value_Boxed<Clutter::ActorBox>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Actor
   */
  Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_H */

