// -*- c++ -*-
/*
 * Copyright 2008 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/init.h>
#include <glibmm/ustring.h>
#include <gdkmm/wrap_init.h>
#include <cluttermmconfig.h> //For LIBCLUTTERMM_VERSION
#include <cluttermm/wrap_init.h>
#include <clutter/clutter.h>

namespace Clutter
{

void init(int* nargs, gchar **args[])
{
  Glib::init(); //Sets up the g type system and the Glib::wrap() table.
  Gdk::wrap_init();
  wrap_init(); //Tells the Glib::wrap() table about the libcluttermm classes.
  clutter_init(nargs, args);
}

} //namespace Clutter
