// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_H
#define _CLUTTERMM_ACTOR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/color.h>
#include <cluttermm/scriptable.h>
#include <clutter/clutter-event.h> //For Clutter*Event
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActor ClutterActor;
typedef struct _ClutterActorClass ClutterActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Actor_Class; } // namespace Clutter
namespace Clutter
{

typedef ClutterEvent Event;
typedef ClutterButtonEvent ButtonEvent;
typedef ClutterKeyEvent KeyEvent;
typedef ClutterMotionEvent MotionEvent;
typedef ClutterScrollEvent ScrollEvent;
typedef ClutterCrossingEvent CrossingEvent;


class Actor : public Glib::Object, public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Actor CppObjectType;
  typedef Actor_Class CppClassType;
  typedef ClutterActor BaseObjectType;
  typedef ClutterActorClass BaseClassType;

private:  friend class Actor_Class;
  static CppClassType actor_class_;

private:
  // noncopyable
  Actor(const Actor&);
  Actor& operator=(const Actor&);

protected:
  explicit Actor(const Glib::ConstructParams& construct_params);
  explicit Actor(ClutterActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Actor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActor*       gobj()       { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActor* gobj() const { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActor* gobj_copy();

private:

  
protected:
  Actor();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()
  
  
  /** Flags a clutter actor to be displayed. An actor not shown will not
   * appear on the display.
   */
  void show();
  
  /** Call show() on all children of a actor (if any).
   * 
   * Since: 0.2
   */
  void show_all();
  
  /** Flags a clutter actor to be hidden. An actor not shown will not
   * appear on the display.
   */
  void hide();
  
  /** Call hide() on all child actors (if any).
   * 
   * Since: 0.2
   */
  void hide_all();
  
  /** Creates any underlying graphics resources needed by the actor to be
   * displayed.
   */
  void realize();
  
  /** Frees up any underlying graphics resources needed by the actor to be
   * displayed.
   */
  void unrealize();
  
  /** Renders the actor to display.
   * 
   * This function should not be called directly by applications instead
   * #clutter_actor_queue_redraw should be used to queue paints.
   */
  void paint();
  
  /** Queues up a redraw of an actor and any children. The redraw occurs
   * once the main loop becomes idle (after the current batch of events
   * has been processed, roughly).
   * 
   * Applications rarely need to call this as redraws are handled automatically
   * by modification functions.
   */
  void queue_redraw();

  //TODO: Check that we don't want to wrap this: _WRAP_METHOD(void destroy(), clutter_actor_destroy)

  //TODO: If these are output parameters, then they probably need to be hand-coded:
  //TODO: _WRAP_METHOD(void request_coords(const Glib::RefPtr<ActorBox>& box), clutter_actor_request_coords)
  //TODO: _WRAP_METHOD(void query_coords(const Glib::RefPtr<ActorBox>& box), clutter_actor_query_coords)
  
  /** Sets the actors untransformed geometry in pixels relative to any
   * parent actor.
   * @param geometry A Clutter::Geometry.
   */
  void set_geometry(const ClutterGeometry *geometry);
  
  /** Gets the actors untransformed geometry in pixels relative to any
   * parent actor.
   * @param geometry A location to store actors Clutter::Geometry.
   */
  void get_geometry(ClutterGeometry *geometry);
  
  /** Gets the actors untransformed bounding rectangle co-ordinates in pixels
   * relative to any parent actor.
   * @param x_1 A location to store actors left position, or <tt>0</tt>.
   * @param y_1 A location to store actors top position, or <tt>0</tt>.
   * @param x_2 A location to store actors right position, or <tt>0</tt>.
   * @param y_2 A location to store actors bottom position, or <tt>0</tt>.
   */
  void get_coords(int *x_1, int *y_1, int *x_2, int *y_2) const;
  
  /** Sets the actors size in pixels. If @a width and/or @a height are -1 the
   * actor will assume the same size of its bounding box.
   * @param width New width of actor in pixels, or -1.
   * @param height New height of actor in pixels, or -1.
   */
  void set_size(int width, int height);
  
  /** Sets the actors size in Clutter::Unit. If @a width and/or @a height are -1 the
   * actor will assume the same size of its bounding box.
   * 
   * Since: 0.6
   * @param width New width of actor in Clutter::Unit, or -1.
   * @param height New height of actor in Clutter::Unit, or -1.
   */
  void set_sizeu(Unit width, Unit height);
  
  /** Retrieves the position of an actor.
   * 
   * Since: 0.6
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_position(int& x, int& y);
  
  /** Retrieves the position of an actor in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_positionu(Unit& x, Unit& y);
  
  /** Sets the actors position in pixels relative to any
   * parent actor.
   * @param x New left position of actor in pixels.
   * @param y New top position of actor in pixels.
   */
  void set_position(int x, int y);
  
  /** Sets the actors position in Clutter::Unit relative to any
   * parent actor.
   * 
   * Since: 0.6
   * @param x New left position of actor in Clutter::Unit.
   * @param y New top position of actor in Clutter::Unit.
   */
  void set_positionu(Unit x, Unit y);
  
  /** Gets the absolute position of an actor in pixels relative
   * to the stage.
   * @param x Location to store x position if non <tt>0</tt>.
   * @param y Location to store y position if non <tt>0</tt>.
   */
  void get_abs_position(int& x, int& y) const;
  
  /** Retrieves the actors width ignoring any scaling factors.
   * @return The actor width in pixels.
   */
  guint get_width() const;
  
  /** Retrieves the actors width ignoring any scaling factors.
   * @return The actor width in Clutter::Unit
   * 
   * since: 0.6.
   */
  Unit get_widthu() const;
  
  /** Retrieves the actors height ignoring any scaling factors.
   * @return The actor height in pixels.
   */
  guint get_height() const;
  
  /** Retrieves the actors height ignoring any scaling factors.
   * @return The actor height in Clutter::Unit
   * 
   * since: 0.6.
   */
  Unit get_heightu() const;
  
  /** Requests a new width for actor
   * 
   * since: 0.2
   * @param width Requested new width for actor.
   */
  void set_width(guint width);
  
  /** Requests a new width for actor
   * 
   * since: 0.6
   * @param width Requested new width for actor in Clutter::Unit.
   */
  void set_widthu(Unit width);
  
  /** Requests a new height for actor
   * 
   * since: 0.2
   * @param height Requested new height for actor.
   */
  void set_height(guint height);
  
  /** Requests a new height for actor
   * 
   * since: 0.6
   * @param height Requested new height for actor in Clutter::Unit.
   */
  void set_heightu(Unit height);

  
  /** Sets the actor's x position relative to its parent.
   * 
   * Since: 0.6
   * @param x The actors position on the X axis.
   */
  void set_x(int x);
  
  /** Sets the actor's x position relative to its parent.
   * 
   * Since: 0.6
   * @param x The actors position on the X axis in Clutter::Unit.
   */
  void set_xu(Unit x);
  
  /** Retrieves the actors x position relative to any parent.
   * @return The actor x position in pixels ignoring any tranforms
   * (i.e scaling, rotation).
   */
  int get_x() const;
  
  /** Retrieves the actors x position relative to any parent, in Clutter::Unit
   * @return The actor x position in Clutter::Unit ignoring any tranforms
   * (i.e scaling, rotation).
   * 
   * Since: 0.6.
   */
  Unit get_xu() const;
  
  /** Sets the actor's y position relative to its parent.
   * 
   * Since: 0.6
   * @param y The actors position on the Y axis.
   */
  void set_y(int y);
  
  /** Sets the actor's y position relative to its parent.
   * 
   * Since: 0.6
   * @param y The actors position on the Y axis in Clutter::Unit.
   */
  void set_yu(Unit y);
  
  /** Retrieves the actors y position relative to any parent.
   * @return The actor y position in pixels ignoring any tranforms
   * (i.e scaling, rotation).
   */
  int get_y() const;
  
  /** Retrieves the actors y position relative to any parent, in Clutter::Unit
   * @return The actor y position in Clutter::Unit ignoring any tranforms
   * (i.e scaling, rotation).
   */
  Unit get_yu() const;
  
  /** Sets @a actor as reactive. Reactive actors will receive events.
   * 
   * Since: 0.6
   * @param reactive Whether the actor should be reactive to events.
   */
  void set_reactive(bool reactive = true);
  
  /** Checks whether @a actor is marked as reactive.
   * @return <tt>true</tt> if the actor is reactive
   * 
   * Since: 0.6.
   */
  bool get_reactive() const;

  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * The rotation center coordinates used depend on the value of @a axis:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;Clutter::X_AXIS requires @a y and @a z&lt;/listitem&gt;
   * &lt;listitem&gt;Clutter::Y_AXIS requires @a x and @a z&lt;/listitem&gt;
   * &lt;listitem&gt;Clutter::Z_AXIS requires @a x and @a y&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * The rotation coordinates are relative to the anchor point of the
   * actor, set using set_anchor_point(). If no anchor
   * point is set, the upper left corner is assumed as the origin.
   * 
   * Since: 0.6
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotation(RotateAxis axis, double angle, int x, int y, int z);
  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * This function is the fixed point variant of set_rotation().
   * 
   * Since: 0.6
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotationx(RotateAxis axis, Fixed angle, int x, int y, int z);
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using clutter_actor_set_angle().
   * 
   * The coordinates of the center returned by this function depend on
   * the axis passed.
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation.
   * 
   * Since: 0.6.
   */
  double get_rotation(RotateAxis axis, int& x, int& y, int& z) const;
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using set_rotation().
   * 
   * This function is the fixed point variant of get_rotation().
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation as a fixed point value.
   * 
   * Since: 0.6.
   */
  Fixed get_rotationx(RotateAxis axis, int& x, int& y, int& z) const;
  
  /** Sets the actors opacity, with zero being completely transparent and
   * 255 (0xff) as fully opaque.
   * @param opacity New opacity value for actor.
   */
  void set_opacity (guint8 opacity);
  
  /** Retrieves the actors opacity.
   * @return The actor opacity value.
   */
  guint8 get_opacity() const;
  
  /** Sets a textual tag to the actor.
   * @param name Textual tag to apply to actor.
   */
  void set_name(const gchar           *name);
  
  /** Retrieves the name of @a self.
   * @return Pointer to textual tag for the actor.  The
   * returned string is owned by the actor and should not
   * be modified or freed.
   */
  Glib::ustring get_name() const;
  
  /** Retrieves the unique id for @a self.
   * @return Globally unique value for object instance.
   * 
   * Since: 0.6.
   */
  guint32 get_gid() const;
  
  /** Sets clip area in pixels for @a self. The clip area is always computed
   * from the upper left corner of the actor, even if the anchor point is
   * set otherwise.
   * @param xoff X offset of the clip rectangle, in pixels.
   * @param yoff Y offset of the clip rectangle, in pixels.
   * @param width Width of the clip rectangle, in pixels.
   * @param height Height of the clip rectangle, in pixels.
   */
  void set_clip(int xoff, int yoff, int width, int height);
  
  /** Gets the clip area for @a self, in pixels.
   * 
   * Since: 0.6
   * @param xoff Return location for the X offset of the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of the clip rectangle, or <tt>0</tt>.
   */
  void get_clip(int& xoff, int& yoff, int& width, int& height);
  
  /** Unit-based variant of set_clip()
   * 
   * Sets clip area for @a self. The clip area is always computed from the
   * upper left corner of the actor, even if the anchor point is set
   * otherwise.
   * 
   * Since: 0.6
   * @param xoff X offset of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param yoff Y offset of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param width Width of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   * @param height Height of the clip rectangle, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_clipu(Unit xoff, Unit yoff, Unit width, Unit height);
  
  /** Unit-based variant of get_clip().
   * 
   * Gets the clip area for @a self, in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param xoff Return location for the X offset of the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of the clip rectangle, or <tt>0</tt>.
   */
  void get_clipu(Unit& xoff, Unit& yoff, Unit& width, Unit& height);
  
  /** Removes clip area in pixels from @a self.
   */
  void remove_clip();
  
  /** Gets whether the actor has a clip set or not.
   * @return <tt>true</tt> if the actor has a clip set.
   * 
   * Since: 0.1.1.
   */
  bool has_clip() const;
  
  /** Sets the parent of @a self to @a parent.  The opposite function is
   * unparent().
   * 
   * This function should not be used by applications but by custom
   * 'composite' actor sub classes.
   * @param parent A new Clutter::Actor parent.
   */
  void set_parent(const Glib::RefPtr<Actor>& parent);
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_parent();
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_parent() const;
  
  /** This function resets the parent actor of @a self.  It is
   * logically equivalent to calling clutter_actory_unparent()
   * and set_parent().
   * 
   * Since: 0.2
   * @param new_parent The new Clutter::Actor parent.
   */
  void reparent(const Glib::RefPtr<Actor>& new_parent);
  
  /** This function should not be used in applications.  It should be called by
   * implementations of container actors, to dissociate a child from the
   * container.
   * 
   * Since: 0.1.1
   */
  void unparent();
  
  /** Puts @a self above @a below.
   * Both actors must have the same parent.
   * @param below A Clutter::Actor to raise above.
   */
  void raise(const Glib::RefPtr<Actor>& below);
  
  /** Puts @a self below @a above.
   * Both actors must have the same parent.
   * @param above A Clutter::Actor to lower below.
   */
  void lower(const Glib::RefPtr<Actor>& above);
  
  /** Raises @a self to the top.
   */
  void raise_top ();
  
  /** Lowers @a self to the bottom.
   */
  void lower_bottom();
  
  /** Sets the Z co-ordinate of @a self to @a depth. The Units of which are dependant
   * on the perspective setup.
   * @param depth Z co-ord.
   */
  void set_depth(int depth);
  
  /** Sets the Z co-ordinate of @a self to @a depth in Clutter::Unit, the Units of
   * which are dependant on the perspective setup.
   * @param depth Z co-ord in Clutter::Unit.
   */
  void set_depthu(Unit depth);
  
  /** Retrieves the depth of @a self.
   * @return The depth of a Clutter::Actor.
   */
  int get_depth() const;
  
  /** Retrieves the depth of @a self.
   * @return The depth of a Clutter::Actor in Clutter::Unit
   * 
   * Since: 0.6.
   */
  Unit get_depthu() const;
  
  /** Scales an actor with fixed point parameters.
   * @param scale_x Clutter::Fixed factor to scale actor by horizontally.
   * @param scale_y Clutter::Fixed factor to scale actor by vertically.
   */
  void set_scalex(Fixed scale_x, Fixed scale_y);
  
  /** Scales an actor with floating point parameters.
   * 
   * Since: 0.2
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   */
  void set_scale(double scale_x, double scale_y);
  
  /** Retrieves an actors scale in fixed point.
   * 
   * Since: 0.2
   * @param scale_x Location to store horizonal fixed scale factor if non <tt>0</tt>.
   * @param scale_y Location to store vertical fixed scale factor if non <tt>0</tt>.
   */
  void get_scalex(Fixed& scale_x, Fixed& scale_y) const;
  
  /** Retrieves an actors scale in floating point.
   * 
   * Since: 0.2
   * @param scale_x Location to store horizonal float scale factor if non <tt>0</tt>.
   * @param scale_y Location to store vertical float scale factor if non <tt>0</tt>.
   */
  void get_scale(double& scale_x, double& scale_y) const;

  //TODO:: removed? _WRAP_METHOD(void set_scale_with_gravityx(Fixed scale_x, Fixed scale_y, ClutterGravity gravity), clutter_actor_set_scale_with_gravityx)

  //TODO:: removed? _WRAP_METHOD(void set_scale_with_gravity(float scale_x, float scale_y, ClutterGravity gravity), clutter_actor_set_scale_with_gravity)

  
  /** Gets the absolute size of an actor taking into account
   * an scaling factors
   * @param width Location to store width if non <tt>0</tt>.
   * @param height Location to store height if non <tt>0</tt>.
   */
  void get_abs_size(guint& width, guint& height) const;
  
  /** Gets the size of an actor in pixels ignoring any scaling factors.
   * 
   * Since: 0.2
   * @param width Location to store width if non <tt>0</tt>.
   * @param height Location to store height if non <tt>0</tt>.
   */
  void get_size(guint& width, guint& height) const;
  
  /** Gets the size of an actor in Clutter::Unit&lt;!-- --&gt;s ignoring any scaling
   * factors.
   * 
   * Since: 0.6
   * @param width Location to store width if non <tt>0</tt>.
   * @param height Location to store height if non <tt>0</tt>.
   */
  void get_sizeu(Unit& width, Unit& height) const;
  
  /** Moves an actor by specified distance relative to
   * current position in pixels.
   * 
   * Since: 0.2
   * @param dx Distance to move Actor on X axis.
   * @param dy Distance to move Actor on Y axis.
   */
  void move_by(int dx, int dy);
  
  /** Moves an actor by specified distance relative to the current position.
   * 
   * Since: 0.6
   * @param dx Distance to move Actor on X axis, in Clutter::Unit&lt;!-- --&gt;s.
   * @param dy Distance to move Actor on Y axis, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void move_byu(Unit dx, Unit dy);

  //TODO: _WRAP_METHOD(void get_vertices(ClutterVertex verts[4]) const, clutter_actor_get_vertices)

//TODO: typedef (or wrap) ClutterVertex.
 

  /** Transforms point in coordinates relative to the actor
   * into screen coordiances with the current actor tranform
   * (i.e.\ scale, rotation etc)
   * 
   * Since: 0.4
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_transform_to_point(const ClutterVertex& point, ClutterVertex& vertex);
  
  /** The function translates point with screen coordinates ( @a x, @a y) to
   * coordinates relative to the actor, i.e.\ it can be used to translate
   * screen events from global screen coordinates into local coordinates.
   * 
   * The conversion can fail, notably if the transform stack results in the
   * actor being projected on the screen as a mere line.
   * 
   * The conversion should not be expected to be pixel-perfect due to the
   * nature of the operation. In general the error grows when the skewing
   * of the actor rectangle on screen increases.
   * 
   * @note This function is fairly computationally intensive.
   * @param x X screen coordinate of the point to unproject, in Clutter::Unit&lt;!-- --&gt;s.
   * @param y Y screen coordinate of the point to unproject, in Clutter::Unit&lt;!-- --&gt;s.
   * @param x_out Return location for the unprojected x coordinance, in
   * Clutter::Unit&lt;!-- --&gt;s.
   * @param y_out Return location for the unprojected y coordinance, in
   * Clutter::Unit&lt;!-- --&gt;s.
   * @return <tt>true</tt> if conversion was successful.
   * 
   * Since: 0.6.
   */
  void transform_stage_point(Unit x, Unit y, Unit& x_out, Unit& y_out);


  /** This function is used to emit an event on the main stage.
   * You should rarely need to use this function, except for
   * synthetising events.
   * @param event A Clutter::Event.
   * @param capture <tt>true</tt> if event in in capture phase, <tt>false</tt> otherwise.
   * @return The return value from the signal emission: <tt>true</tt>
   * if the actor handled the event, or <tt>false</tt> if the event was
   * not handled
   * 
   * Since: 0.6.
   */
  bool event(ClutterEvent* event, bool capture);
  //TODO: _WRAP_METHOD(Glib::RefPtr<Actor> clutter_get_actor_by_gid(guint32 id), clutter_get_actor_by_gid)
  //TODO: _WRAP_METHOD(Glib::RefPtr<const Actor> clutter_get_actor_by_gid(guint32 id) const, clutter_get_actor_by_gid, constversion)

  
  /** Sets an anchor point for the @a actor. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner of
   * the actor.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void set_anchor_point(int anchor_x, int anchor_y);
  
  /** Gets the current anchor point of the @a actor in pixels.
   * 
   * Since: 0.6
   * @param anchor_x Return location for the X coordinate of the anchor point.
   * @param anchor_y Return location for the y coordinate of the anchor point.
   */
  void get_anchor_point(int& anchor_x, int& anchor_y) const;
  
  /** Sets an anchor point for the @a self. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner
   * of the actor.
   * 
   * Since: 0.6
   * @param anchor_x X coordinate of the anchor point, in Clutter::Unit&lt;!-- --&gt;s.
   * @param anchor_y Y coordinate of the anchor point, in Clutter::Unit&lt;!-- --&gt;s.
   */
  void set_anchor_pointu(Unit anchor_x, Unit anchor_y);
  
  /** Gets the current anchor point of the @a actor in Clutter::Unit&lt;!-- --&gt;s.
   * 
   * Since: 0.6
   * @param anchor_x Return location for the X coordinace of the anchor point.
   * @param anchor_y Return location for the X coordinace of the anchor point.
   */
  void get_anchor_pointu(Unit& anchor_x, Unit& anchor_y);
  
  /** Sets an anchor point the actor based on the given gravity (this is a
   * convenience function wrapping set_anchor_point()).
   * 
   * Since: 0.6
   * @param gravity Clutter::Gravity.
   */
  void set_anchor_point_from_gravity(ClutterGravity gravity);

// signals
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_event(MotionEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,MotionEvent* > signal_motion_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_leave_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%show()</tt>
   */

  Glib::SignalProxy0< void > signal_show();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%hide()</tt>
   */

  Glib::SignalProxy0< void > signal_hide();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%destroy()</tt>
   */

  Glib::SignalProxy0< void > signal_destroy();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_enter_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_out()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_out();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%focus_in()</tt>
   */

  Glib::SignalProxy0< void > signal_focus_in();

  //TODO: _WRAP_SIGNAL(void parent_set(const Glib::RefPtr<Actor>& old_parent), "parent_set")
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%scroll_event(ScrollEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ScrollEvent* > signal_scroll_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%captured_event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_captured_event();


  protected:
  // according to the clutter docs, these functions should never be called
  // directly and are only for subclasses
  
  /** Renders a silhouette of the actor in supplied color. Used internally for
   * mapping pointer events to actors.
   * 
   * This function should not never be called directly by applications.
   * 
   * Subclasses overiding this method should call
   * should_pick_paint() to decide if to render there
   * silhouette but in any case should still recursively call pick for
   * any children.
   * 
   * Since 0.4
   * @param color A Clutter::Color.
   */
  void pick(const Color& color);
  
  /** Utility call for subclasses overiding the pick method.
   * 
   * This function should not never be called directly by applications.
   * @return <tt>true</tt> if the actor should paint its silhouette,
   * <tt>false</tt> otherwise.
   */
  bool should_pick_paint() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_button_press_event(ButtonEvent* event);
  virtual bool on_button_release_event(ButtonEvent* event);
  virtual bool on_motion_event(MotionEvent* event);
  virtual bool on_leave_event(CrossingEvent* event);
  virtual void on_show();
  virtual void on_hide();
  virtual void on_destroy();
  virtual bool on_key_release_event(KeyEvent* event);
  virtual bool on_enter_event(CrossingEvent* event);
  virtual bool on_event(Event* event);
  virtual void on_focus_out();
  virtual void on_focus_in();
  virtual bool on_scroll_event(ScrollEvent* event);
  virtual bool on_key_press_event(KeyEvent* event);
  virtual bool on_captured_event(Event* event);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Actor
   */
  Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_H */

