// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_LABEL_H
#define _CLUTTERMM_LABEL_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/color.h>
#include <pangomm.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterLabel ClutterLabel;
typedef struct _ClutterLabelClass ClutterLabelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Label_Class; } // namespace Clutter
namespace Clutter
{


class Label :
  public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Label CppObjectType;
  typedef Label_Class CppClassType;
  typedef ClutterLabel BaseObjectType;
  typedef ClutterLabelClass BaseClassType;

private:  friend class Label_Class;
  static CppClassType label_class_;

private:
  // noncopyable
  Label(const Label&);
  Label& operator=(const Label&);

protected:
  explicit Label(const Glib::ConstructParams& construct_params);
  explicit Label(ClutterLabel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Label();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterLabel*       gobj()       { return reinterpret_cast<ClutterLabel*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterLabel* gobj() const { return reinterpret_cast<ClutterLabel*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterLabel* gobj_copy();

private:


protected:
  Label();
  explicit Label(const Glib::ustring& font_name, const Glib::ustring& text);
  explicit Label(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);

public:
  
  static Glib::RefPtr<Label> create();

  
  static Glib::RefPtr<Label> create(const Glib::ustring& font_name, const Glib::ustring& text);
;
  
  static Glib::RefPtr<Label> create(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);
;

 
  /** Sets @a text as the text to be displayed by @a label.
   * @param text The text to be displayed.
   */
  void set_text(const Glib::ustring& text);
  
  /** Retrieves the text displayed by @a label
   * @return The text of the label.  The returned string is
   * owned by Clutter::Label and should not be modified or freed.
   */
  Glib::ustring set_text() const;
  
  /** Sets @a font_name as the font used by @a label.
   * 
   *  @a font_name must be a string containing the font name and its
   * size, similarly to what you would feed to the
   * pango_font_description_from_string() function.
   * @param font_name A font name and size, or <tt>0</tt> for the default font.
   */
  void set_font_name(const Glib::ustring& font_name);
  
  /** Retrieves the font used by @a label.
   * @return A string containing the font name, in a format
   * understandable by pango_font_description_from_string().  The
   * string is owned by Clutter::Label and should not be modified
   * or freed.
   */
  Glib::ustring get_font_name() const;

  
  /** Retrieves the color of @a label.
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;
  
  
  /** Sets the color of @a label.
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);

  
  /** Return value: Pango::EllipsizeMode
   * @return Pango::EllipsizeMode
   * 
   * Since: 0.2.
   */
  Pango::EllipsizeMode get_ellipsize() const;
  
  /** Sets the mode used to ellipsize (add an ellipsis: "...") to the text 
   * if there is not enough space to render the entire string.
   * 
   * Since: 0.2
   * @param mode A Pango::EllipsizeMode.
   */
  void set_ellipsize(Pango::EllipsizeMode wrap_mode);

  
  /** Return value: <tt>true</tt> if the lines of the label are automatically wrapped.
   * @return <tt>true</tt> if the lines of the label are automatically wrapped.
   * 
   * Since: 0.2.
   */
  bool get_line_wrap() const;
  
  /** Toggles line wrapping within the Clutter::Label widget.  <tt>true</tt> makes
   * it break lines if text exceeds the widget's size.  <tt>false</tt> lets the
   * text get cut off by the edge of the widget if it exceeds the widget
   * size.
   * 
   * Since: 0.2
   * @param wrap The setting.
   */
  void set_line_wrap(bool wrap);

  
  /** Return value: <tt>true</tt> if the label's text will be parsed for markup.
   * @return <tt>true</tt> if the label's text will be parsed for markup.
   */
  bool get_use_markup() const;
  
  /** Sets whether the text of the label contains markup in Pango's text markup
   * language.
   * @param setting <tt>true</tt> if the label's text should be parsed for markup.
   */
  void set_use_markup(bool wrap);

  
  /** Return value: <tt>true</tt> if the lines of the label are automatically wrapped.
   * @return <tt>true</tt> if the lines of the label are automatically wrapped.
   * 
   * Since: 0.2.
   */
  Pango::WrapMode get_line_wrap_mode() const;
  
  /** If line wrapping is on (see set_line_wrap()) this controls how
   * the line wrapping is done. The default is Pango::WRAP_WORD which means
   * wrap on word boundaries.
   * 
   * Since: 0.2
   * @param wrap_mode The line wrapping mode.
   */
  void set_line_wrap_mode(Pango::WrapMode wrap_mode);

  
  /** Gets the Pango::Layout used to display the label.
   * The layout is useful to e.g. convert text positions to
   * pixel positions.
   * The returned layout is owned by the label so need not be
   * freed by the caller.
   * @return The Pango::Layout for this label
   * 
   * Since: 0.2.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Gets the Pango::Layout used to display the label.
   * The layout is useful to e.g. convert text positions to
   * pixel positions.
   * The returned layout is owned by the label so need not be
   * freed by the caller.
   * @return The Pango::Layout for this label
   * 
   * Since: 0.2.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;

  
  /** Gets the attribute list that was set on the label using
   * set_attributes(), if any.
   * @return The attribute list, or <tt>0</tt> if none was set.
   * 
   * Since: 0.2.
   */
  Pango::AttrList get_attributes() const;

  // TODO: check if AttrList param should be const
  // Probably not. It is reference counted. murrayc.
  
  /** Sets a Pango::AttrList; the attributes in the list are applied to the
   * label text. The attributes set with this function will be ignored
   * if the "use_markup" property
   * is <tt>true</tt>.
   * 
   * Since: 0.2
   * @param attrs A Pango::AttrList.
   */
  void set_attributes(Pango::AttrList& attrs);

  
  /** Return value: The labels Pango::Alignment
   * @return The labels Pango::Alignment
   * 
   * Since 0.2.
   */
  Pango::Alignment get_alignment() const;
  
  /** Sets text alignment of the label.
   * @param alignment A Pango::Alignment.
   */
  void set_alignment(Pango::Alignment wrap_mode);

  
  /** Retrieves whether the label should justify the text on both margins.
   * @return <tt>true</tt> if the text should be justified
   * 
   * Since: 0.6.
   */
  bool get_justify() const;
  
  /** Sets whether the text of the @a label actor should be justified
   * on both margins. This setting is ignored if Clutter is compiled
   * against Pango &gt; 1.18.
   * 
   * Since: 0.6
   * @param justify Whether the text should be justified.
   */
  void set_justify(bool justify);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Label
   */
  Glib::RefPtr<Clutter::Label> wrap(ClutterLabel* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_LABEL_H */

