/* locator.c generated by valac 0.12.0, the Vala compiler
 * generated from locator.vala, do not modify */

/*
 * Copyright (C) 2008 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Finds the innermost block containing the given location */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <string.h>


#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;
typedef struct _BlockLocatorPrivate BlockLocatorPrivate;

#define BLOCK_LOCATOR_TYPE_LOCATION (block_locator_location_get_type ())
typedef struct _BlockLocatorLocation BlockLocatorLocation;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _BlockLocator {
	ValaCodeVisitor parent_instance;
	BlockLocatorPrivate * priv;
};

struct _BlockLocatorClass {
	ValaCodeVisitorClass parent_class;
};

struct _BlockLocatorLocation {
	gint line;
	gint column;
};

struct _BlockLocatorPrivate {
	BlockLocatorLocation location;
	ValaSymbol* innermost;
	BlockLocatorLocation innermost_begin;
	BlockLocatorLocation innermost_end;
};


static gpointer block_locator_parent_class = NULL;
static GType block_locator_type_id = 0;

GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
static GType block_locator_location_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BlockLocatorLocation* block_locator_location_dup (const BlockLocatorLocation* self);
static void block_locator_location_free (BlockLocatorLocation* self);
#define BLOCK_LOCATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLOCK_LOCATOR, BlockLocatorPrivate))
enum  {
	BLOCK_LOCATOR_DUMMY_PROPERTY
};
ValaSymbol* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
static void block_locator_location_init (BlockLocatorLocation *self, gint line, gint column);
static gboolean block_locator_update_location (BlockLocator* self, ValaSymbol* s);
static gboolean block_locator_location_inside (BlockLocatorLocation *self, ValaSourceReference* src);
static gboolean block_locator_location_before (BlockLocatorLocation *self, BlockLocatorLocation* other);
static void block_locator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void block_locator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void block_locator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void block_locator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void block_locator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void block_locator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void block_locator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void block_locator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void block_locator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void block_locator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void block_locator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void block_locator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void block_locator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void block_locator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void block_locator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void block_locator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void block_locator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void block_locator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void block_locator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void block_locator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void block_locator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void block_locator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr);
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
static void block_locator_finalize (ValaCodeVisitor* obj);


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaSymbol* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column) {
	ValaSymbol* result = NULL;
	BlockLocatorLocation _tmp0_ = {0};
	BlockLocatorLocation _tmp1_ = {0};
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	block_locator_location_init (&_tmp0_, line, column);
	_tmp1_ = _tmp0_;
	self->priv->location = _tmp1_;
	_vala_code_node_unref0 (self->priv->innermost);
	self->priv->innermost = NULL;
	vala_source_file_accept_children (file, (ValaCodeVisitor*) self);
	_tmp2_ = _vala_code_node_ref0 (self->priv->innermost);
	result = _tmp2_;
	return result;
}


static gboolean block_locator_update_location (BlockLocator* self, ValaSymbol* s) {
	gboolean result = FALSE;
	ValaSourceReference* _tmp0_ = NULL;
	gboolean _tmp1_;
	ValaSourceReference* _tmp2_ = NULL;
	gint _tmp3_;
	ValaSourceReference* _tmp4_ = NULL;
	gint _tmp5_;
	BlockLocatorLocation begin = {0};
	ValaSourceReference* _tmp6_ = NULL;
	gint _tmp7_;
	ValaSourceReference* _tmp8_ = NULL;
	gint _tmp9_;
	BlockLocatorLocation end = {0};
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
	_tmp1_ = block_locator_location_inside (&self->priv->location, _tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
	_tmp3_ = vala_source_reference_get_first_line (_tmp2_);
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
	_tmp5_ = vala_source_reference_get_first_column (_tmp4_);
	block_locator_location_init (&begin, _tmp3_, _tmp5_);
	_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
	_tmp7_ = vala_source_reference_get_last_line (_tmp6_);
	_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) s);
	_tmp9_ = vala_source_reference_get_last_column (_tmp8_);
	block_locator_location_init (&end, _tmp7_, _tmp9_);
	if (self->priv->innermost == NULL) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp12_ = block_locator_location_before (&self->priv->innermost_begin, &begin);
		if (_tmp12_) {
			gboolean _tmp13_;
			_tmp13_ = block_locator_location_before (&end, &self->priv->innermost_end);
			_tmp11_ = _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp10_ = _tmp11_;
	}
	if (_tmp10_) {
		ValaSymbol* _tmp14_;
		_tmp14_ = _vala_code_node_ref0 (s);
		_vala_code_node_unref0 (self->priv->innermost);
		self->priv->innermost = _tmp14_;
		self->priv->innermost_begin = begin;
		self->priv->innermost_end = end;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void block_locator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) b);
	if (_tmp0_) {
		vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
	}
}


static void block_locator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (ns != NULL);
	block_locator_update_location (self, (ValaSymbol*) ns);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) cl);
	if (_tmp0_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) st);
	if (_tmp0_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) iface);
	if (_tmp0_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) m);
	if (_tmp0_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	BlockLocator * self;
	gboolean _tmp0_;
	self = (BlockLocator*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = block_locator_update_location (self, (ValaSymbol*) m);
	if (_tmp0_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (acc != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) acc, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (c != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (section != NULL);
	vala_code_visitor_visit_block ((ValaCodeVisitor*) self, (ValaBlock*) section);
}


static void block_locator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (clause != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) clause, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void block_locator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr) {
	BlockLocator * self;
	self = (BlockLocator*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}


BlockLocator* block_locator_construct (GType object_type) {
	BlockLocator* self = NULL;
	self = (BlockLocator*) vala_code_visitor_construct (object_type);
	return self;
}


BlockLocator* block_locator_new (void) {
	return block_locator_construct (TYPE_BLOCK_LOCATOR);
}


static void block_locator_location_init (BlockLocatorLocation *self, gint line, gint column) {
	memset (self, 0, sizeof (BlockLocatorLocation));
	(*self).line = line;
	(*self).column = column;
}


static gboolean block_locator_location_inside (BlockLocatorLocation *self, ValaSourceReference* src) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	BlockLocatorLocation begin = {0};
	gint _tmp2_;
	gint _tmp3_;
	BlockLocatorLocation end = {0};
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	g_return_val_if_fail (src != NULL, FALSE);
	_tmp0_ = vala_source_reference_get_first_line (src);
	_tmp1_ = vala_source_reference_get_first_column (src);
	block_locator_location_init (&begin, _tmp0_, _tmp1_);
	_tmp2_ = vala_source_reference_get_last_line (src);
	_tmp3_ = vala_source_reference_get_last_column (src);
	block_locator_location_init (&end, _tmp2_, _tmp3_);
	_tmp5_ = block_locator_location_before (&begin, &(*self));
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = block_locator_location_before (&(*self), &end);
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}


static gboolean block_locator_location_before (BlockLocatorLocation *self, BlockLocatorLocation* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if ((*self).line > (*other).line) {
		result = FALSE;
		return result;
	}
	if ((*self).line == (*other).line) {
		_tmp0_ = (*self).column > (*other).column;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static BlockLocatorLocation* block_locator_location_dup (const BlockLocatorLocation* self) {
	BlockLocatorLocation* dup;
	dup = g_new0 (BlockLocatorLocation, 1);
	memcpy (dup, self, sizeof (BlockLocatorLocation));
	return dup;
}


static void block_locator_location_free (BlockLocatorLocation* self) {
	g_free (self);
}


static GType block_locator_location_get_type (void) {
	static volatile gsize block_locator_location_type_id__volatile = 0;
	if (g_once_init_enter (&block_locator_location_type_id__volatile)) {
		GType block_locator_location_type_id;
		block_locator_location_type_id = g_boxed_type_register_static ("BlockLocatorLocation", (GBoxedCopyFunc) block_locator_location_dup, (GBoxedFreeFunc) block_locator_location_free);
		g_once_init_leave (&block_locator_location_type_id__volatile, block_locator_location_type_id);
	}
	return block_locator_location_type_id__volatile;
}


static void block_locator_class_init (BlockLocatorClass * klass) {
	block_locator_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = block_locator_finalize;
	g_type_class_add_private (klass, sizeof (BlockLocatorPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = block_locator_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = block_locator_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = block_locator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = block_locator_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = block_locator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = block_locator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = block_locator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = block_locator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = block_locator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = block_locator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = block_locator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = block_locator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = block_locator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = block_locator_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = block_locator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = block_locator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = block_locator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = block_locator_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = block_locator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = block_locator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = block_locator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = block_locator_real_visit_lambda_expression;
}


static void block_locator_instance_init (BlockLocator * self) {
	self->priv = BLOCK_LOCATOR_GET_PRIVATE (self);
}


static void block_locator_finalize (ValaCodeVisitor* obj) {
	BlockLocator * self;
	self = BLOCK_LOCATOR (obj);
	_vala_code_node_unref0 (self->priv->innermost);
	VALA_CODE_VISITOR_CLASS (block_locator_parent_class)->finalize (obj);
}


GType block_locator_get_type (void) {
	return block_locator_type_id;
}


GType block_locator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BlockLocatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_locator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockLocator), 0, (GInstanceInitFunc) block_locator_instance_init, NULL };
	block_locator_type_id = g_type_module_register_type (module, VALA_TYPE_CODE_VISITOR, "BlockLocator", &g_define_type_info, 0);
	return block_locator_type_id;
}



