%define	desktop_vendor	anjuta
%define	name		anjuta
%define	version		2.1.3
%define	release		1
%define	serial		1

Summary:	Integrated Development Environment
Name:		%{name}
Version:	%{version}
Release:	%{release}
Serial:		%{serial}
Copyright:	GPL2
Group:		Development/Tools
URL:		http://anjuta.org/
Vendor:		Naba Kumar  <naba@gnome.org>
Source:		%{name}-%{version}.tar.gz
BuildRoot:	/var/tmp/%{name}-%{version}
Docdir:		%{_docdir}

Requires: 	glib2 >= 2.8.0
Requires: 	gtk2 >= 2.8.0
Requires: 	ORBit2 >= 2.6.0
Requires: 	libglade2 >= 2.3.0
Requires: 	libgnome >= 2.12.0
Requires: 	libgnomeui >= 2.12.0
Requires: 	libgnomeprint22 >= 2.12.0
Requires: 	libgnomeprintui22 >= 2.12.0
Requires: 	gnome-vfs2 >= 2.10.0
Requires: 	vte >= 0.9.0
Requires: 	libxml2 >= 2.4.23
Requires: 	pango >= 1.1.1
Requires: 	pcre >= 3.9
Requires: 	devhelp >= 0.13
Requires: 	gdl >= 0.7.3
Requires: 	gnome-build >= 0.1.4
Requires: 	graphviz >= 1.0
Requires: 	neon >= 0.24.5
Requires: 	subversion >= 1.0.2

BuildRequires: 	glib2-devel >= 2.8.0
BuildRequires: 	gtk2-devel >= 2.8.0
BuildRequires: 	ORBit2-devel >= 2.6.0
BuildRequires: 	libglade2-devel >= 2.3.0
BuildRequires: 	libgnome-devel >= 2.12.0
BuildRequires: 	libgnomeui-devel >= 2.12.0
BuildRequires: 	libgnomeprint22-devel >= 2.12.0
BuildRequires: 	libgnomeprintui22-devel >= 2.12.0
BuildRequires: 	gnome-vfs2-devel >= 2.10.0
BuildRequires: 	vte-devel >= 0.9.0
BuildRequires: 	libxml2-devel >= 2.4.23
BuildRequires: 	pango-devel >= 1.1.1
BuildRequires: 	pcre-devel >= 3.9
BuildRequires: 	devhelp-devel >= 0.13
BuildRequires: 	gdl-devel >= 0.7.3
BuildRequires: 	gnome-build-devel >= 0.1.4
BuildRequires: 	graphviz-devel >= 1.0
BuildRequires: 	neon-devel >= 0.24.5
BuildRequires: 	subversion-devel >= 1.0.2

Distribution: 	Any
Packager:     	Naba Kumar  <naba@gnome.org>

%description
Anjuta DevStudio is a versatile Integrated Development Environment (IDE)
on GNOME Desktop Environment and features a number of advanced
programming facilities. These include project management, application and
class wizards, an on-board interactive debugger, powerful source editor,
syntax highlighting, intellisense autocompletions, symbol navigation,
version controls, integrated GUI designing and other tools.

%package devel
Summary:	Libraries and include files for Anjuta plugins development.
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description devel
Libraries, header files and API docs for developing Anjuta plugins.

%prep
%setup -q

%build
%configure --disable-plugin-glade
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall
rm -fr %{buildroot}/var/scrollkeeper

%clean
rm -rf %{buildroot}

%post
## if which scrollkeeper-update>/dev/null 2>&1; then \
## 	scrollkeeper-update; \
## fi
if which update-mime-database>/dev/null 2>&1; then \
	update-mime-database %{_datadir}/mime; \
fi

%postun
## if which scrollkeeper-update>/dev/null 2>&1; then \
## 	scrollkeeper-update; \
## fi
if which update-mime-database>/dev/null 2>&1; then \
	update-mime-database %{_datadir}/mime; \
fi

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%doc doc/ScintillaDoc.html

%defattr(-,root,root)
%{_bindir}/%{name}*
%{_libdir}/lib%{name}*.so.*
%{_libdir}/%{name}
%{_datadir}/%{name}
%{_datadir}/applications/*%{name}.desktop
%{_datadir}/pixmaps/%{name}
%{_datadir}/doc/%{name}
%{_datadir}/application-registry/%{name}.applications
%{_datadir}/mime-info/%{name}.mime
%{_datadir}/mime-info/%{name}.keys
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/icons/gnome/48x48/mimetypes/*%{name}.png
## %{_datadir}/gnome/help/%{name}
## %{_datadir}/omf/%{name}
%{_datadir}/locale
%{_mandir}/man1/*

%files devel
%defattr (-, root, root)
%{_includedir}/*%{name}*
%{_libdir}/pkgconfig/*%{name}*
## %{_libdir}/lib%{name}*.a
%{_libdir}/lib%{name}*.la
%{_libdir}/lib%{name}*.so
%{_datadir}/gtk-doc/html/*%{name}*
