/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-selection.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-editor-selection.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_selection_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-selection-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_selection_clear:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Clear selection
 */
void
ianjuta_editor_selection_clear (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->clear (obj, err);
}

/**
 * ianjuta_editor_selection_copy:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Copy selection to clipboard.
 */
void
ianjuta_editor_selection_copy (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->copy (obj, err);
}

/**
 * ianjuta_editor_selection_cut:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Cut selection to clipboard.
 */
void
ianjuta_editor_selection_cut (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->cut (obj, err);
}

/**
 * ianjuta_editor_selection_get:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Gets curerntly selected text in editor.
 * 
 * Returns: A newly allocated buffer of currently selected characters.
 * NULL if there is no selection. The returned buffer must be freed after
 * use.
 */
gchar*
ianjuta_editor_selection_get (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), NULL);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get (obj, err);
}

/**
 * ianjuta_editor_selection_get_end:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get end position of selection.
 */
gint
ianjuta_editor_selection_get_end (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), -1);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get_end (obj, err);
}

/**
 * ianjuta_editor_selection_get_start:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Gets start position of selection text. If there is no selection,
 * returns the current carat position.
 *
 * Return: Start of selection
 */
gint
ianjuta_editor_selection_get_start (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj), -1);
	return IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->get_start (obj, err);
}

/**
 * ianjuta_editor_selection_paste:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Paste clipboard at current position.
 */
void
ianjuta_editor_selection_paste (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->paste (obj, err);
}

/**
 * ianjuta_editor_selection_replace:
 * @obj: Self
 * @text: Replacement text.
 * @length: Length of the text to used in @text.
 * @err: Error propagation and reporting
 *
 * Replaces currently selected text with the @text. Only @length amount
 * of characters are used from @text buffer to replace.
 */
void
ianjuta_editor_selection_replace (IAnjutaEditorSelection *obj, const gchar *text,   gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	g_return_if_fail (text != NULL);
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->replace (obj, text, length, err);
}

/**
 * ianjuta_editor_edit_select_all:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Select whole buffer.
 */
void
ianjuta_editor_selection_select_all (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_all (obj, err);
}

/**
 * ianjuta_editor_selection_select_block:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Selects current block of code. The definition of block of code
 * depends on highlight mode used (programming language). Some
 * highlight mode does not have block concept, in that case this
 * method does not do anything.
 */
void
ianjuta_editor_selection_select_block (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_block (obj, err);
}

/**
 * ianjuta_editor_selection_select_function:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Select current function block. The definition of function block
 * depends on highlight mode used (programming language). Some
 * highlight mode does not have function concept, in that case this
 * method does not do anything.
 */
void
ianjuta_editor_selection_select_function (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_function (obj, err);
}

/**
 * ianjuta_editor_selection_select_to_brace:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Select to brace. Some highlight mode does not have braces concept,
 * in that case, this method does not do anything.
 */
void
ianjuta_editor_selection_select_to_brace (IAnjutaEditorSelection *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->select_to_brace (obj, err);
}

/**
 * ianjuta_editor_selection_set:
 * @obj: Self
 * @start: Begin of selection
 * @end: End of selection
 * @backward: Direction of search
 * @err: Error propagation and reporting
 *
 * Select characters between start and end
 */
void
ianjuta_editor_selection_set (IAnjutaEditorSelection *obj, gint start,   gint end,   gboolean backward, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_SELECTION(obj));
	IANJUTA_EDITOR_SELECTION_GET_IFACE (obj)->set (obj, start, end, backward, err);
}

static void
ianjuta_editor_selection_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_selection_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorSelectionIface),
			ianjuta_editor_selection_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorSelection", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
