/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _IANJUTA_DEBUGGER_H_
#define _IANJUTA_DEBUGGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debug-manager.h>
#include <libanjuta/interfaces/ianjuta-message-view.h>
#include <sys/types.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER (ianjuta_debugger_get_type ())
#define IANJUTA_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebugger))
#define IANJUTA_IS_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER))
#define IANJUTA_DEBUGGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebuggerIface))

#define IANJUTA_TYPE_DEBUGGER_BREAKPOINT_TYPE (ianjuta_debugger_breakpoint_type_get_type())
#define IANJUTA_TYPE_DEBUGGER_DATA (ianjuta_debugger_data_get_type())
#define IANJUTA_TYPE_DEBUGGER_ERROR (ianjuta_debugger_error_get_type())
#define IANJUTA_TYPE_DEBUGGER_OUTPUT_TYPE (ianjuta_debugger_output_type_get_type())
#define IANJUTA_TYPE_DEBUGGER_STATE (ianjuta_debugger_state_get_type())
#define IANJUTA_TYPE_DEBUGGER_STATUS (ianjuta_debugger_status_get_type())

typedef enum {
	IANJUTA_DEBUGGER_BREAK_ON_LINE,
	IANJUTA_DEBUGGER_BREAK_ON_ADDRESS,
	IANJUTA_DEBUGGER_BREAK_ON_FUNCTION
} IAnjutaDebuggerBreakpointType;

typedef enum {
	IANJUTA_DEBUGGER_INFORMATION,
	IANJUTA_DEBUGGER_BREAKPOINT,
	IANJUTA_DEBUGGER_FRAME,
	IANJUTA_DEBUGGER_VARIABLE,
	IANJUTA_DEBUGGER_REGISTER
} IAnjutaDebuggerData;

typedef enum {
	IANJUTA_DEBUGGER_OK              =  0,
	IANJUTA_DEBUGGER_NOT_READY       = -1,
	IANJUTA_DEBUGGER_NOT_RUNNING     = -2,
	IANJUTA_DEBUGGER_NOT_STOPPED     = -3,
	IANJUTA_DEBUGGER_NOT_LOADED      = -4,
	IANJUTA_DEBUGGER_NOT_STARTED     = -5,
	IANJUTA_DEBUGGER_NOT_CONNECTED   = -6,
	IANJUTA_DEBUGGER_NOT_IMPLEMENTED = -7,
	IANJUTA_DEBUGGER_CANCEL,
	IANJUTA_DEBUGGER_UNABLE_TO_CREATE_VARIABLE,
	IANJUTA_DEBUGGER_UNABLE_TO_ACCESS_MEMORY,
	IANJUTA_DEBUGGER_UNKNOWN_ERROR
} IAnjutaDebuggerError;

typedef enum {
	IANJUTA_DEBUGGER_OUTPUT,
	IANJUTA_DEBUGGER_WARNING_OUTPUT,
	IANJUTA_DEBUGGER_ERROR_OUTPUT,
	IANJUTA_DEBUGGER_INFO_OUTPUT
} IAnjutaDebuggerOutputType;

typedef enum {
	IANJUTA_DEBUGGER_UNDEFINED = -1,
	IANJUTA_DEBUGGER_NO = 0,
	IANJUTA_DEBUGGER_YES = 1
} IAnjutaDebuggerState;

typedef enum {
	IANJUTA_DEBUGGER_BUSY,
	IANJUTA_DEBUGGER_STOPPED,
	IANJUTA_DEBUGGER_STARTED,
	IANJUTA_DEBUGGER_PROGRAM_LOADED,
	IANJUTA_DEBUGGER_PROGRAM_RUNNING,
	IANJUTA_DEBUGGER_PROGRAM_STOPPED
} IAnjutaDebuggerStatus;

typedef struct _IAnjutaDebuggerALine IAnjutaDebuggerALine;
struct _IAnjutaDebuggerALine {
	guint address;
	gchar *text;
};

typedef struct _IAnjutaDebuggerBreakpoint IAnjutaDebuggerBreakpoint;
struct _IAnjutaDebuggerBreakpoint {
	IAnjutaDebuggerBreakpointType type;
	guint id;
	gchar *file;
	guint line;
	gchar *function;
	guint address;
	IAnjutaDebuggerState enable;
	guint ignore;
	guint times;
	gchar *condition;
	IAnjutaDebuggerState keep;
};

typedef struct _IAnjutaDebuggerDisassembly IAnjutaDebuggerDisassembly;
struct _IAnjutaDebuggerDisassembly {
	guint size;
	IAnjutaDebuggerALine data[0];
};

typedef struct _IAnjutaDebuggerFrame IAnjutaDebuggerFrame;
struct _IAnjutaDebuggerFrame {
	guint level;
	gchar *args;
	gchar *file;
	guint line;
	gchar *function;
	guint address;
};

typedef struct _IAnjutaDebuggerMemory IAnjutaDebuggerMemory;
struct _IAnjutaDebuggerMemory {
	guint address;
	guint length;
	gchar *data;
};

typedef struct _IAnjutaDebuggerRegister IAnjutaDebuggerRegister;
struct _IAnjutaDebuggerRegister {
	guint num;
	gchar *name;
	gchar *value;
};

typedef struct _IAnjutaDebuggerVariable IAnjutaDebuggerVariable;
struct _IAnjutaDebuggerVariable {
	gchar *name;
	gchar *expression;
	gchar *type;
	gchar *value;
	gboolean changed;
	gint children;
};

#define IANJUTA_DEBUGGER_ERROR ianjuta_debugger_error_quark()

typedef void (*IAnjutaDebuggerCallback) (const gpointer data, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerGListCallback) (const GList* list, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerGCharCallback) (const gchar *value, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerBreakpointCallback) (const IAnjutaDebuggerBreakpoint *breakpoint, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerOutputCallback) (IAnjutaDebuggerOutputType type, const gchar *output, gpointer user_data);
typedef void (*IAnjutaDebuggerMemoryCallback) (const gchar* address, guint length, const gchar *data, gpointer user_data, GError *err);
typedef void (*IAnjutaDebuggerVariableCallback) (IAnjutaDebuggerVariable *variable, gpointer user_data, GError *err);

typedef struct _IAnjutaDebugger IAnjutaDebugger;
typedef struct _IAnjutaDebuggerIface IAnjutaDebuggerIface;

struct _IAnjutaDebuggerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*debugger_ready) (IAnjutaDebugger *obj, IAnjutaDebuggerStatus status);
	/* Signal */
	void (*debugger_started) (IAnjutaDebugger *obj);
	/* Signal */
	void (*debugger_stopped) (IAnjutaDebugger *obj);
	/* Signal */
	void (*frame_changed) (IAnjutaDebugger *obj, guint frame);
	/* Signal */
	void (*location_changed) (IAnjutaDebugger *obj, const gchar* file,  guint line,  const gchar* address);
	/* Signal */
	void (*program_exited) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_loaded) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_running) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_stopped) (IAnjutaDebugger *obj);
	/* Signal */
	void (*send) (IAnjutaDebugger *obj);
	/* Signal */
	void (*sharedlib_event) (IAnjutaDebugger *obj);
	/* Signal */
	void (*status_changed) (IAnjutaDebugger *obj, IAnjutaDebuggerStatus status);

	gboolean (*abort) (IAnjutaDebugger *obj, GError **err);
	gboolean (*attach) (IAnjutaDebugger *obj, pid_t pid, const GList* source_search_directories, GError **err);
	gboolean (*callback) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*clear_breakpoint) (IAnjutaDebugger *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*condition_breakpoint) (IAnjutaDebugger *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	void (*disable_log) (IAnjutaDebugger *obj, GError **err);
	gboolean (*enable_breakpoint) (IAnjutaDebugger *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	void (*enable_log) (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err);
	gboolean (*evaluate) (IAnjutaDebugger *obj, const gchar* name,  const gchar* value,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*exit) (IAnjutaDebugger *obj, GError **err);
	IAnjutaDebuggerStatus (*get_status) (IAnjutaDebugger *obj, GError **err);
	gboolean (*handle_signal) (IAnjutaDebugger *obj, const gchar *name,  gboolean stop,  gboolean print,  gboolean ignore, GError **err);
	gboolean (*ignore_breakpoint) (IAnjutaDebugger *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_args) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_frame) (IAnjutaDebugger *obj, guint frame,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_program) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_sharedlib) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_signal) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_target) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_threads) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_udot) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_variables) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*initialize) (IAnjutaDebugger *obj, IAnjutaDebuggerOutputCallback func,  gpointer user_data, GError **err);
	gboolean (*inspect) (IAnjutaDebugger *obj, const gchar* name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*interrupt) (IAnjutaDebugger *obj, GError **err);
	gboolean (*list_argument) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_frame) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_local) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_register) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*load) (IAnjutaDebugger *obj, const gchar *file,  const gchar *mime_type, const GList* source_search_directories, GError **err);
	gboolean (*print) (IAnjutaDebugger *obj, const gchar *variable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*quit) (IAnjutaDebugger *obj, GError **err);
	gboolean (*run) (IAnjutaDebugger *obj, GError **err);
	gboolean (*run_to) (IAnjutaDebugger *obj, const gchar *uri,  gint line, GError **err);
	gboolean (*send_command) (IAnjutaDebugger *obj, const gchar *command, GError **err);
	gboolean (*set_breakpoint_at_address) (IAnjutaDebugger *obj, guint address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_function) (IAnjutaDebugger *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_line) (IAnjutaDebugger *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_frame) (IAnjutaDebugger *obj, guint frame, GError **err);
	gboolean (*start) (IAnjutaDebugger *obj, const gchar *args,  gboolean terminal, GError **err);
	gboolean (*step_in) (IAnjutaDebugger *obj, GError **err);
	gboolean (*step_out) (IAnjutaDebugger *obj, GError **err);
	gboolean (*step_over) (IAnjutaDebugger *obj, GError **err);
	gboolean (*unload) (IAnjutaDebugger *obj, GError **err);

};
GType ianjuta_debugger_breakpoint_type_get_type (void);
GType ianjuta_debugger_data_get_type (void);
GType ianjuta_debugger_error_get_type (void);
GType ianjuta_debugger_output_type_get_type (void);
GType ianjuta_debugger_state_get_type (void);
GType ianjuta_debugger_status_get_type (void);

GQuark ianjuta_debugger_error_quark     (void);
GType  ianjuta_debugger_get_type        (void);

gboolean ianjuta_debugger_abort (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_attach (IAnjutaDebugger *obj, pid_t pid, const GList* source_search_directories, GError **err);

gboolean ianjuta_debugger_callback (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_clear_breakpoint (IAnjutaDebugger *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_condition_breakpoint (IAnjutaDebugger *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

void ianjuta_debugger_disable_log (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_enable_breakpoint (IAnjutaDebugger *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

void ianjuta_debugger_enable_log (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err);

gboolean ianjuta_debugger_evaluate (IAnjutaDebugger *obj, const gchar* name,  const gchar* value,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_exit (IAnjutaDebugger *obj, GError **err);

IAnjutaDebuggerStatus ianjuta_debugger_get_status (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_handle_signal (IAnjutaDebugger *obj, const gchar *name,  gboolean stop,  gboolean print,  gboolean ignore, GError **err);

gboolean ianjuta_debugger_ignore_breakpoint (IAnjutaDebugger *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_args (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_frame (IAnjutaDebugger *obj, guint frame,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_program (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_sharedlib (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_signal (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_target (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_threads (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_udot (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_variables (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_initialize (IAnjutaDebugger *obj, IAnjutaDebuggerOutputCallback func,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_inspect (IAnjutaDebugger *obj, const gchar* name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_interrupt (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_list_argument (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_frame (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_local (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_register (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_load (IAnjutaDebugger *obj, const gchar *file,  const gchar *mime_type, const GList* source_search_directories, GError **err);

gboolean ianjuta_debugger_print (IAnjutaDebugger *obj, const gchar *variable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_quit (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_run (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_run_to (IAnjutaDebugger *obj, const gchar *uri,  gint line, GError **err);

gboolean ianjuta_debugger_send_command (IAnjutaDebugger *obj, const gchar *command, GError **err);

gboolean ianjuta_debugger_set_breakpoint_at_address (IAnjutaDebugger *obj, guint address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_set_breakpoint_at_function (IAnjutaDebugger *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_set_breakpoint_at_line (IAnjutaDebugger *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_set_frame (IAnjutaDebugger *obj, guint frame, GError **err);

gboolean ianjuta_debugger_start (IAnjutaDebugger *obj, const gchar *args,  gboolean terminal, GError **err);

gboolean ianjuta_debugger_step_in (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_step_out (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_step_over (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_unload (IAnjutaDebugger *obj, GError **err);


G_END_DECLS

#endif
