/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.texteditor.FloatingTextEditorHelperBase;

public class FloatingTextEditorHelper
extends FloatingTextEditorHelperBase
implements FigureListener {
    private IFigure figure = null;
    private PrecisionRotator rotator = null;

    public FloatingTextEditorHelper() {
    }

    public FloatingTextEditorHelper(boolean extendsBidirectionalHorizontal) {
        super(extendsBidirectionalHorizontal);
    }

    public IFigure getFigure() {
        return this.figure;
    }

    public void setFigure(IFigure figure) {
        this.figure = figure;
    }

    public PrecisionRotator getRotator() {
        if (this.rotator == null) {
            this.rotator = new PrecisionRotator();
        }
        return this.rotator;
    }

    public void figureMoved(IFigure source) {
        this.refreshEditor(false);
    }

    @Override
    public void activate() {
        super.activate();
        if (this.figure != null) {
            this.figure.addFigureListener((FigureListener)this);
        }
        if (this.getEditor() != null && this.getViewer() != null && this.getFigure() != null) {
            Rectangle b = this.figure.getBounds();
            Point loc = this.getViewer().computeToControl(b.getLocation(), true);
            this.getEditor().setInitialLocation(new org.eclipse.swt.graphics.Point(loc.x, loc.y));
            this.getEditor().setInitialSize(new org.eclipse.swt.graphics.Point(b.width, b.height));
        }
    }

    @Override
    public void deactivate() {
        if (this.figure != null) {
            this.figure.removeFigureListener((FigureListener)this);
            this.figure = null;
        }
        super.deactivate();
    }

    @Override
    protected Font getPreferredFont() {
        if (this.getFigure() == null) {
            return null;
        }
        return this.getPreferredFont(this.getFigure());
    }

    protected Font getPreferredFont(IFigure figure) {
        Font font = figure.getFont();
        if (font == null) {
            return null;
        }
        int height = font.getFontData()[0].getHeight();
        height = (int)((double)height * this.getScale());
        return FontUtils.getNewHeight((Font)font, (int)height);
    }

    @Override
    protected Rectangle getPreferredBounds() {
        if (this.figure == null) {
            return null;
        }
        return this.calcPreferredBounds(this.figure, this.figure.getBounds());
    }

    protected Rectangle calcPreferredBounds(IFigure figure, Rectangle bounds) {
        if (figure instanceof IRotatableFigure && ((IRotatableFigure)figure).getRotationDegrees() != 0.0) {
            IRotatableFigure rf = (IRotatableFigure)figure;
            PrecisionRectangle r = new PrecisionRectangle(bounds);
            PrecisionPoint center = r.getCenter();
            this.getRotator().setOrigin(center);
            this.getRotator().setAngle(rf.getRotationDegrees());
            PrecisionDimension d = rf.getNormalPreferredSize(-1, -1);
            PrecisionRectangle r2 = this.getRotator().r(r, -1.0, d.height);
            return r2.toDraw2DRectangle();
        }
        return bounds.getCopy();
    }
}

