/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.opml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.CoreException;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.exports.opml.OpmlExportPart;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;

public class OpmlExporter
extends Exporter {
    private Document document;
    private Element bodyEle;
    private String targetPath;

    public OpmlExporter(ISheet sheet, ITopic element, String targetPath) {
        super(sheet, element);
        this.targetPath = targetPath;
    }

    public void init() {
        this.appendAll(this.getCentralTopic());
    }

    private void appendAll(ITopic topic) {
        this.appendTopic(this.getCentralTopic(), null);
    }

    private void appendTopic(ITopic topic, OpmlExportPart parent) {
        OpmlExportPart part = (OpmlExportPart)this.getTitlePart(topic, parent);
        this.append((IExportPart)part);
        this.collectTopicContent(topic, part);
    }

    private void collectTopicContent(ITopic topic, OpmlExportPart parent) {
        INotesContent content = topic.getNotes().getContent("plain");
        if (content instanceof IPlainNotesContent) {
            NotesPart notes = new NotesPart(this, (IPlainNotesContent)content);
            notes.setParent(parent);
            this.append((IExportPart)notes);
        }
        for (ITopic child : topic.getChildren("attached")) {
            this.appendTopic(child, parent);
        }
    }

    private IExportPart getTitlePart(ITopic topic, OpmlExportPart parent) {
        TopicPart topicPart = new TopicPart(this, topic);
        topicPart.setParent(parent);
        return topicPart;
    }

    private Node getBodyNode() {
        if (this.bodyEle == null) {
            this.bodyEle = this.createBodyNode();
        }
        return this.bodyEle;
    }

    private Element createBodyNode() {
        return DOMUtils.createElement((Node)this.getDocument().getDocumentElement(), (String)"body");
    }

    private Element createHeadNode(Element opmlEle) {
        Element headEle = DOMUtils.createElement((Node)opmlEle, (String)"head");
        Element titleEle = DOMUtils.createElement((Node)headEle, (String)"title");
        titleEle.setTextContent(this.getCentralTopic().getTitleText());
        String owerName = System.getProperty("user.name");
        String version = System.getProperty("org.xmind.product.version");
        Element owernameEle = DOMUtils.createElement((Node)headEle, (String)"owername");
        owernameEle.setTextContent(owerName);
        Element producerEle = DOMUtils.createElement((Node)headEle, (String)"producer");
        producerEle.setTextContent("XMind");
        Element versionEle = DOMUtils.createElement((Node)headEle, (String)"xmind-version");
        versionEle.setTextContent(version);
        return headEle;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
            this.createHeadNode(this.document.getDocumentElement());
        }
        return this.document;
    }

    private Document createDocument() {
        Document doc = DOMUtils.createDocument();
        Element opmlEle = DOMUtils.createElement((Node)doc, (String)"opml");
        opmlEle.setAttribute("version", "2.0");
        return doc;
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        OpmlExportPart child = (OpmlExportPart)part;
        OpmlExportPart parent = child.getParent();
        if (parent != null) {
            child.addToParent(parent);
        } else {
            this.getBodyNode().appendChild(child.getNode());
        }
    }

    public void end() throws InvocationTargetException {
        try {
            try {
                FileOutputStream out = new FileOutputStream(this.targetPath);
                try {
                    DOMUtils.save((Node)this.getDocument(), (OutputStream)out, (boolean)true);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            catch (FileNotFoundException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            super.end();
        }
    }

    private class NotesPart
    extends OpmlExportPart {
        public NotesPart(OpmlExporter exporter, IPlainNotesContent content) {
            super(exporter, content);
        }

        protected Node createNode() {
            Element noteEle = this.createDOMElement("outline");
            IPlainNotesContent content = (IPlainNotesContent)this.getElement();
            noteEle.setAttribute("type", "note");
            noteEle.setAttribute("text", content.getTextContent());
            return noteEle;
        }
    }

    private class TopicPart
    extends OpmlExportPart {
        public TopicPart(OpmlExporter exporter, Object element) {
            super(exporter, element);
        }

        protected Node createNode() {
            ITopic topic = (ITopic)this.getElement();
            Element topicEle = this.createDOMElement("outline");
            topicEle.setAttribute("text", topic.getTitleText());
            String link = topic.getHyperlink();
            if (link != null && this.isLinkToWeb(link)) {
                topicEle.setAttribute("type", "link");
                topicEle.setAttribute("url", link);
            }
            return topicEle;
        }

        private boolean isLinkToWeb(String hyperlink) {
            return hyperlink.contains("www.") || hyperlink.contains(".com") || hyperlink.contains(".cn") || hyperlink.contains(".org") || hyperlink.contains(".cc") || hyperlink.contains(".net") || hyperlink.contains(".ren");
        }
    }
}

