/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.lighten;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.widgets.Display;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IFileEntry;
import org.xmind.core.INotes;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Point;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;

public class LightenExporter
extends Exporter {
    private String exportPath;
    private Set<String> palette = new HashSet<String>();
    private Display display;

    public LightenExporter(ISheet sheet, ITopic centralTopic, String exportPath, Display display) {
        super(sheet, centralTopic);
        this.exportPath = exportPath;
        this.display = display;
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(null, 100);
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.exportPath));
            try {
                ZipEntry contentEntry = new ZipEntry("content.json");
                zos.putNextEntry(contentEntry);
                zos.write(this.transferSheetToJson(this.getSheet()).toString().getBytes("utf-8"));
                zos.closeEntry();
                monitor.worked(60);
                boolean previewExported = false;
                zos.putNextEntry(new ZipEntry("thumbnail.png"));
                for (IFileEntry fileEntry : this.getSheet().getOwnedWorkbook().getManifest().getFileEntries()) {
                    int readLength;
                    if (!"Thumbnails/thumbnail.png".equals(fileEntry.getPath()) || !fileEntry.canRead() || previewExported) continue;
                    InputStream is = fileEntry.openInputStream();
                    byte[] buffer = new byte[2048];
                    while ((readLength = is.read(buffer)) != -1) {
                        zos.write(buffer, 0, readLength);
                    }
                    previewExported = true;
                    break;
                }
                if (!previewExported) {
                    this.exportPreviewImage(zos);
                }
                zos.closeEntry();
            }
            finally {
                zos.close();
            }
            monitor.worked(40);
            monitor.done();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private JSONObject serializeSheetStyle() {
        JSONObject json = new JSONObject();
        json.put("enablePalette", true);
        return json;
    }

    private JSONObject serializeTopic(ITopic topic, JSONArray detachedTopics) {
        JSONObject json = new JSONObject();
        json.put("folded", topic.isFolded());
        json.put("id", (Object)topic.getId().toUpperCase());
        json.put("checkList", false);
        json.put("title", (Object)topic.getTitleText());
        if (topic.getPosition() != null) {
            json.put("position", (Object)this.formatPoint(topic.getPosition()));
            json.put("detach", true);
        } else {
            json.put("position", (Object)"{0, 0}");
            json.put("detach", false);
        }
        JSONObject notesJson = new JSONObject();
        if (topic != null) {
            json.put("style", (Object)this.serializeTopicStyle(topic));
            INotes notes = topic.getNotes();
            if (notes != null && !notes.isEmpty() && notes.getContent("plain") != null) {
                notesJson.put("text", (Object)((IPlainNotesContent)notes.getContent("plain")).getTextContent());
            }
        }
        json.put("note", (Object)notesJson);
        json.put("hightlight", false);
        List subtopics = topic.getAllChildren();
        if (subtopics != null && !subtopics.isEmpty()) {
            JSONArray subtopicsJson = new JSONArray();
            for (ITopic subtopic : subtopics) {
                JSONObject subtopicJson = this.serializeTopic(subtopic, detachedTopics);
                if (subtopicJson == null) continue;
                subtopicsJson.put((Object)subtopicJson);
            }
            json.put("subtopics", (Object)subtopicsJson);
        }
        json.put("checkboxStatus", false);
        if (topic.getPosition() != null) {
            detachedTopics.put((Object)json);
            return null;
        }
        return json;
    }

    private JSONArray serializeRelationships(ISheet sheet) {
        Set relationships = sheet.getRelationships();
        JSONArray relationShipJson = new JSONArray();
        for (IRelationship relationship : relationships) {
            Point cp1;
            JSONObject json = new JSONObject();
            json.put("startNodeId", (Object)relationship.getEnd1Id().toUpperCase());
            json.put("endNodeId", (Object)relationship.getEnd2Id().toUpperCase());
            Point cp0 = relationship.getControlPoint(0).getPosition();
            if (cp0 != null) {
                json.put("controlPoint1", (Object)this.formatPoint(cp0));
            }
            if ((cp1 = relationship.getControlPoint(1).getPosition()) != null) {
                json.put("controlPoint2", (Object)this.formatPoint(cp1));
            }
            json.put("id", (Object)relationship.getId().toUpperCase());
            relationShipJson.put((Object)json);
        }
        return relationShipJson;
    }

    private String formatPoint(Point point) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append(point.x).append(',').append(' ').append(point.y).append('}');
        return sb.toString();
    }

    private String rgbToColor(String rgbValue) {
        if (rgbValue == null || "none".equals(rgbValue)) {
            return "{255, 255, 255, 0.00}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{').append(Integer.valueOf(rgbValue.substring(1, 3), 16)).append(',').append(' ').append(Integer.valueOf(rgbValue.substring(3, 5), 16)).append(',').append(' ').append(Integer.valueOf(rgbValue.substring(5, 7), 16)).append(',').append(' ').append("1.00}");
        String colorPoint = sb.toString();
        this.palette.add(colorPoint);
        return colorPoint;
    }

    private JSONObject serializeTopicStyle(ITopic topic) {
        IStyle topicStyle;
        JSONObject json = new JSONObject();
        json.put("enablePalette", true);
        json.put("lineType", 0);
        IStyleSheet styleSheet = topic.getOwnedWorkbook().getStyleSheet();
        if (styleSheet != null && (topicStyle = styleSheet.findStyle(topic.getStyleId())) != null) {
            String taperedLine;
            String lineWidth;
            String cornerRadius;
            String margin;
            String fontWeight;
            String fontFamily;
            String fillColor;
            String lineColor = topicStyle.getProperty("line-color");
            if (lineColor != null) {
                json.put("lineColor", (Object)this.rgbToColor(lineColor));
            }
            if ((fillColor = topicStyle.getProperty("svg:fill")) != null) {
                json.put("fillColor", (Object)this.rgbToColor(fillColor));
            }
            if ((fontFamily = topicStyle.getProperty("fo:font-family")) != null) {
                json.put("fontName", (Object)this.generateFontName(fontFamily));
                json.put("fontFamily", (Object)fontFamily);
            }
            if ((fontWeight = topicStyle.getProperty("fo:font-weight")) != null) {
                json.put("fontWeight", (Object)fontWeight);
            }
            if ((margin = this.generateMargin(topicStyle)) != null) {
                json.put("topicMargin", (Object)margin);
            }
            if ((cornerRadius = topicStyle.getProperty("line-corner")) != null) {
                json.put("cornerRadius", (Object)Integer.valueOf(cornerRadius.substring(0, cornerRadius.length() - 2)));
            }
            if ((lineWidth = topicStyle.getProperty("line-width")) != null) {
                json.put("lineWidth", (Object)Integer.valueOf(lineWidth.substring(0, lineWidth.length() - 2)));
            }
            if ((taperedLine = topicStyle.getProperty("line-tapered")) != null) {
                json.put("taperedLine", (Object)new Boolean(taperedLine));
            }
        }
        return json;
    }

    private void exportPreviewImage(OutputStream output) {
        MindMapImageExporter exporter = new MindMapImageExporter(this.display);
        exporter.setSource((Object)new MindMap(this.getSheet()), null, new Insets(15));
        exporter.setResize(4, 1280, 1024);
        exporter.setTargetStream(output);
        exporter.export();
    }

    private String generateFontName(String fontFamily) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = fontFamily.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A') {
                sb.append(c);
            }
            ++n2;
        }
        sb.append("-Regular");
        return sb.toString();
    }

    private String generateMargin(IStyle style) {
        String marginLeft = style.getProperty("fo:margin-left");
        String marginRight = style.getProperty("fo:margin-right");
        String marginTop = style.getProperty("fo:margin-top");
        String marginBottom = style.getProperty("fo:margin-bottom");
        if (!(marginLeft == null && marginRight == null || marginBottom == null && marginTop == null)) {
            Integer ml = marginLeft == null ? 0 : Integer.valueOf(marginLeft);
            Integer mr = marginRight == null ? 0 : Integer.valueOf(marginRight);
            Integer mt = marginTop == null ? 0 : Integer.valueOf(marginTop);
            Integer mb = marginBottom == null ? 0 : Integer.valueOf(marginBottom);
            Integer marginHor = ml >= mr ? ml : mr;
            Integer marginVer = mt >= mb ? mt : mb;
            return "" + '{' + marginHor + ',' + ' ' + marginVer + '}';
        }
        return null;
    }

    private JSONObject getSkeletonTheme() {
        JSONObject skeThemeJson = new JSONObject();
        skeThemeJson.put("name", (Object)"branch-taperedline");
        skeThemeJson.put("palette", (Object)new JSONArray());
        JSONObject main = new JSONObject();
        main.put("lineType", 0).put("topicShape", 1).put("lineWidth", 4);
        skeThemeJson.put("topicStyleForMain", (Object)main);
        JSONObject sub = new JSONObject();
        sub.put("lineType", 0).put("topicShape", 1).put("lineWidth", 2);
        skeThemeJson.put("topicStyleForSubtopic", (Object)sub);
        JSONObject map = new JSONObject();
        map.put("taperedLine", true);
        skeThemeJson.put("mapStyle", (Object)map);
        JSONObject central = new JSONObject();
        central.put("lineType", 0).put("topicShape", 0).put("lineWidth", 4);
        skeThemeJson.put("topicStyleForCentral", (Object)central);
        JSONObject floating = new JSONObject();
        floating.put("lineType", 0).put("topicShape", 1).put("lineWidth", 4);
        skeThemeJson.put("topicStyleForFloating", (Object)floating);
        JSONObject rela = new JSONObject();
        rela.put("lineWidth", 3);
        skeThemeJson.put("relationshipStyle", (Object)rela);
        return skeThemeJson;
    }

    private JSONObject getColorTheme() {
        JSONObject colorThemeJson = new JSONObject();
        colorThemeJson.put("name", (Object)"summer");
        JSONArray platte = new JSONArray();
        platte.put((Object)"{124, 214, 212, 1.00}").put((Object)"{178, 148, 139, 1.00}").put((Object)"{242, 198, 19, 1.00}").put((Object)"{173, 217, 55, 1.00}").put((Object)"{251, 168, 71, 1.00}").put((Object)"{102, 106, 126, 1.00}");
        colorThemeJson.put("palette", (Object)platte);
        JSONObject main = new JSONObject();
        main.put("lineColor", (Object)"{124, 214, 212, 1.00}").put("lineType", 2).put("fillColor", (Object)"{0, 0, 0, 0.00}").put("fontName", (Object)"AvenirNext-Regular").put("fontFamily", (Object)"Avenir Next").put("fontColor", (Object)"{91, 91, 91, 1.00}").put("topicShape", 1).put("topicMargin", (Object)"{16, 6}").put("cornerRadius", 8).put("lineWidth", 5);
        colorThemeJson.put("topicStyleForMain", (Object)main);
        JSONObject sub = new JSONObject();
        sub.put("lineColor", (Object)"{124, 214, 212, 1.00}").put("lineType", 2).put("fillColor", (Object)"{0, 0, 0, 0.00}").put("fontName", (Object)"AvenirNext-Regular").put("fontFamily", (Object)"Avenir Next").put("fontColor", (Object)"{91, 91, 91, 1.00}").put("topicShape", 1).put("topicMargin", (Object)"{6, 6}").put("cornerRadius", 8).put("lineWidth", 5);
        colorThemeJson.put("topicStyleForSubtopic", (Object)sub);
        JSONObject map = new JSONObject();
        map.put("fillColor", (Object)"{255, 255, 255, 1.00}").put("lineType", 0);
        colorThemeJson.put("mapStyle", (Object)map);
        JSONObject central = new JSONObject();
        central.put("lineColor", (Object)"{102, 106, 126, 1.00}").put("lineType", 1).put("fillColor", (Object)"{255, 255, 255, 1.00}").put("fontName", (Object)"AvenirNext-Regular").put("fontFamily", (Object)"Avenir Next").put("fontColor", (Object)"{102, 106, 126, 1.00}").put("topicShape", 0).put("topicMargin", (Object)"{28, 16}").put("cornerRadius", 12).put("lineWidth", 5);
        colorThemeJson.put("topicStyleForCentral", (Object)central);
        JSONObject floating = new JSONObject();
        floating.put("lineColor", (Object)"{124, 214, 212, 1.00}").put("lineType", 2).put("fillColor", (Object)"{0, 0, 0, 0.00}").put("fontName", (Object)"AvenirNext-Regular").put("fontFamily", (Object)"Avenir Next").put("fontColor", (Object)"{91, 91, 91, 1.00}").put("topicShape", 1).put("topicMargin", (Object)"{16, 6}").put("cornerRadius", 8).put("lineWidth", 5);
        colorThemeJson.put("topicStyleForFloating", (Object)floating);
        JSONObject rela = new JSONObject();
        rela.put("lineWidth", 3).put("lineColor", (Object)"{255, 87, 34, 1.00}");
        colorThemeJson.put("relationshipStyle", (Object)rela);
        return colorThemeJson;
    }

    private JSONObject transferSheetToJson(ISheet sheet) {
        JSONObject json = new JSONObject();
        double dateTime = ((double)sheet.getModifiedTime() == 0.0 ? new Date().getTime() : sheet.getModifiedTime()) / 1000L;
        json.put("createTime", dateTime);
        json.put("style", (Object)this.serializeSheetStyle());
        json.put("id", (Object)sheet.getId().toUpperCase());
        json.put("updateTime", dateTime);
        json.put("mapName", (Object)"");
        json.put("skeletonTheme", (Object)this.getSkeletonTheme());
        json.put("colorTheme", (Object)this.getColorTheme());
        ITopic rootTopic = sheet.getRootTopic();
        JSONArray detachedTopics = new JSONArray();
        json.put("rootTopic", (Object)this.serializeTopic(rootTopic, detachedTopics));
        json.put("detachedTopics", (Object)detachedTopics);
        json.put("relationships", (Object)this.serializeRelationships(sheet));
        ITopicExtension topicExtension = rootTopic.getExtension("org.xmind.ui.map.unbalanced");
        if (topicExtension != null) {
            json.put("rightNumber", (Object)Integer.valueOf(((ITopicExtensionElement)topicExtension.getContent().getFirstChild("right-number")).getTextContent()));
        } else {
            int mainTopicsNum = 0;
            for (ITopic topics : rootTopic.getAllChildren()) {
                if (!topics.isAttached()) continue;
                ++mainTopicsNum;
            }
            json.put("rightNumber", mainTopicsNum % 2 == 0 ? mainTopicsNum / 2 : mainTopicsNum / 2 + 1);
        }
        return json;
    }

    public void init() {
    }
}

