/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilePathParser {
    public static final String URI_SCHEME = "file";
    private static final String FILE_PROTOCOL = "file:";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String PROTOCOL_SEP = "//";
    private static final String PATH_SEP = "/";
    private static final String PARENT_DIR = "..";
    private static final String SAME_DIR = ".";
    private static final String PARENT_DIR_SEP = ".." + FILE_SEP;
    private static final String SAME_DIR_SEP = "." + FILE_SEP;
    public static final String ABSTRACT_FILE_BASE = System.getProperty("user.home");
    private static final String WIN_NETWORK_PATH_PREFIX = "\\\\";
    static Boolean IS_WINDOWS = null;
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";

    public static boolean isFileURI(String uri) {
        return uri != null && uri.startsWith(FILE_PROTOCOL);
    }

    public static String toPath(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            uri = FilePathParser.decode(uri, true);
        }
        catch (Exception exception) {}
        String path = uri.startsWith(FILE_PROTOCOL) ? uri.substring(FILE_PROTOCOL.length()) : uri;
        if (path.startsWith(PROTOCOL_SEP)) {
            path = path.substring(2);
        }
        if (FilePathParser.isWindows()) {
            path = path.replaceAll(PATH_SEP, WIN_NETWORK_PATH_PREFIX);
        }
        return path;
    }

    public static String toURI(String path, boolean relative) {
        if (path == null) {
            return null;
        }
        if (FilePathParser.isWindows()) {
            path = path.replaceAll(WIN_NETWORK_PATH_PREFIX, PATH_SEP);
        }
        return FilePathParser.encode(relative ? FILE_PROTOCOL + path : "file://" + path, true);
    }

    public static boolean isPathRelative(String path) {
        return (!FilePathParser.isWindows() || !path.startsWith(WIN_NETWORK_PATH_PREFIX)) && !new File(path).isAbsolute();
    }

    private static List<String> calculateRoutine(File file) {
        ArrayList<String> routine = new ArrayList<String>();
        while (file != null) {
            String name = file.getName();
            if (name == null || "".equals(name)) {
                name = file.getPath();
            }
            routine.add(0, name);
            file = file.getParentFile();
        }
        return routine;
    }

    public static String toRelativePath(String base, String absolutePath) {
        int i;
        if (absolutePath.equals(base)) {
            return SAME_DIR;
        }
        List<String> baseRoutine = FilePathParser.calculateRoutine(new File(base));
        List<String> absRoutine = FilePathParser.calculateRoutine(new File(absolutePath));
        int start = 0;
        while (start < absRoutine.size() && start < baseRoutine.size() && absRoutine.get(start).equals(baseRoutine.get(start))) {
            ++start;
        }
        if (start == absRoutine.size()) {
            return SAME_DIR;
        }
        StringBuilder builder = new StringBuilder();
        if (start < baseRoutine.size()) {
            i = start;
            while (i < baseRoutine.size()) {
                builder.append(PARENT_DIR);
                builder.append(FILE_SEP);
                ++i;
            }
        }
        i = start;
        while (i < absRoutine.size()) {
            builder.append(absRoutine.get(i));
            if (i < absRoutine.size() - 1) {
                builder.append(FILE_SEP);
            }
            ++i;
        }
        return builder.toString();
    }

    public static String toAbsolutePath(String base, String relativePath) {
        File file = new File(base);
        while (!"".equals(relativePath)) {
            if (FilePathParser.isWindows() && relativePath.startsWith(WIN_NETWORK_PATH_PREFIX)) {
                return relativePath.substring(FILE_SEP.length());
            }
            if (relativePath.startsWith(PARENT_DIR_SEP)) {
                if (file != null) {
                    file = file.getParentFile();
                }
                relativePath = relativePath.substring(PARENT_DIR_SEP.length());
                continue;
            }
            if (relativePath.startsWith(SAME_DIR_SEP)) {
                relativePath = relativePath.substring(SAME_DIR_SEP.length());
                continue;
            }
            int sepIndex = relativePath.indexOf(FILE_SEP);
            if (sepIndex < 0) {
                if (file == null) {
                    return relativePath;
                }
                return new File(file, relativePath).getPath();
            }
            file = file == null ? new File(relativePath.substring(0, sepIndex)) : new File(file, relativePath.substring(0, sepIndex));
            relativePath = relativePath.substring(sepIndex + FILE_SEP.length());
        }
        if (file == null) {
            return "";
        }
        return file.getPath();
    }

    private static String encode(String str, boolean fullUri) {
        byte[] utf8buf = null;
        StringBuffer sb = null;
        int k = 0;
        int length = str.length();
        while (k != length) {
            int C = str.charAt(k);
            if (FilePathParser.encodeUnescaped((char)C, fullUri)) {
                if (sb != null) {
                    sb.append((char)C);
                }
            } else {
                int V;
                if (sb == null) {
                    sb = new StringBuffer(length + 3);
                    sb.append(str);
                    sb.setLength(k);
                    utf8buf = new byte[6];
                }
                if (56320 <= C && C <= 57343) {
                    throw new IllegalArgumentException();
                }
                if (C < 55296 || 56319 < C) {
                    V = C;
                } else {
                    if (++k == length) {
                        throw new IllegalArgumentException();
                    }
                    char C2 = str.charAt(k);
                    if ('\udc00' > C2 || C2 > '\udfff') {
                        throw new IllegalArgumentException();
                    }
                    V = (C - 55296 << 10) + (C2 - 56320) + 65536;
                }
                int L = FilePathParser.oneUcs4ToUtf8Char(utf8buf, V);
                int j = 0;
                while (j < L) {
                    int d = 0xFF & utf8buf[j];
                    sb.append('%');
                    sb.append(FilePathParser.toHexChar(d >>> 4));
                    sb.append(FilePathParser.toHexChar(d & 0xF));
                    ++j;
                }
            }
            ++k;
        }
        return sb == null ? str : sb.toString();
    }

    private static String decode(String str, boolean fullUri) {
        char[] buf = null;
        int bufTop = 0;
        int k = 0;
        int length = str.length();
        while (k != length) {
            char C = str.charAt(k);
            if (C != '%') {
                if (buf != null) {
                    buf[bufTop++] = C;
                }
                ++k;
                continue;
            }
            if (buf == null) {
                buf = new char[length];
                str.getChars(0, k, buf, 0);
                bufTop = k;
            }
            int start = k;
            if (k + 3 > length) {
                throw new IllegalArgumentException();
            }
            int B = FilePathParser.unHex(str.charAt(k + 1), str.charAt(k + 2));
            if (B < 0) {
                throw new IllegalArgumentException();
            }
            k += 3;
            if ((B & 0x80) == 0) {
                C = (char)B;
            } else {
                int minUcs4Char;
                int ucs4Char;
                int utf8Tail;
                if ((B & 0xC0) == 128) {
                    throw new IllegalArgumentException();
                }
                if ((B & 0x20) == 0) {
                    utf8Tail = 1;
                    ucs4Char = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    utf8Tail = 2;
                    ucs4Char = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    utf8Tail = 3;
                    ucs4Char = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    utf8Tail = 4;
                    ucs4Char = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    utf8Tail = 5;
                    ucs4Char = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    throw new IllegalArgumentException();
                }
                if (k + 3 * utf8Tail > length) {
                    throw new IllegalArgumentException();
                }
                int j = 0;
                while (j != utf8Tail) {
                    if (str.charAt(k) != '%') {
                        throw new IllegalArgumentException();
                    }
                    B = FilePathParser.unHex(str.charAt(k + 1), str.charAt(k + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ucs4Char = ucs4Char << 6 | B & 0x3F;
                    k += 3;
                    ++j;
                }
                if (ucs4Char < minUcs4Char || ucs4Char == 65534 || ucs4Char == 65535) {
                    ucs4Char = 65533;
                }
                if (ucs4Char >= 65536) {
                    if ((ucs4Char -= 65536) > 1048575) {
                        throw new IllegalArgumentException();
                    }
                    char H = (char)((ucs4Char >>> 10) + 55296);
                    C = (char)((ucs4Char & 0x3FF) + 56320);
                    buf[bufTop++] = H;
                } else {
                    C = (char)ucs4Char;
                }
            }
            if (fullUri && URI_DECODE_RESERVED.indexOf(C) >= 0) {
                int x = start;
                while (x != k) {
                    buf[bufTop++] = str.charAt(x);
                    ++x;
                }
                continue;
            }
            buf[bufTop++] = C;
        }
        return buf == null ? str : new String(buf, 0, bufTop);
    }

    private static boolean encodeUnescaped(char c, boolean fullUri) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (fullUri) {
            return URI_DECODE_RESERVED.indexOf(c) >= 0;
        }
        return false;
    }

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            int i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }

    private static char toHexChar(int i) {
        if (i >> 4 != 0) {
            throw new IllegalArgumentException();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c1, char c2) {
        int i1 = FilePathParser.unHex(c1);
        int i2 = FilePathParser.unHex(c2);
        if (i1 >= 0 && i2 >= 0) {
            return i1 << 4 | i2;
        }
        return -1;
    }

    private static boolean isWindows() {
        if (IS_WINDOWS == null) {
            try {
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                String os = (String)platformClass.getDeclaredMethod("getOS", new Class[0]).invoke(null, new Object[0]);
                String os_win32 = (String)platformClass.getDeclaredField("OS_WIN32").get(null);
                if (os_win32 != null && os != null) {
                    IS_WINDOWS = os_win32.equals(os);
                }
            }
            catch (Throwable throwable) {}
            if (IS_WINDOWS == null) {
                IS_WINDOWS = Boolean.FALSE;
            }
        }
        return IS_WINDOWS;
    }

    public static void calculateFileURILabels(URI[] inputURIs, Map<URI, String> labels) {
        ArrayList<PathDisambiguator> paths = new ArrayList<PathDisambiguator>();
        int i = 0;
        while (i < inputURIs.length) {
            String path;
            String uriValue;
            URI uri = inputURIs[i];
            if (uri != null && FilePathParser.isFileURI(uriValue = uri.toString()) && (path = FilePathParser.toPath(uriValue)) != null) {
                paths.add(new PathDisambiguator(uri, new File(path)));
            }
            ++i;
        }
        i = 1;
        while (i < paths.size()) {
            PathDisambiguator path1 = (PathDisambiguator)paths.get(i);
            int j = 0;
            while (j < i) {
                PathDisambiguator path2 = (PathDisambiguator)paths.get(j);
                while (path1.conflictsWith(path2)) {
                    path1.increaseDepth();
                    path2.increaseDepth();
                }
                ++j;
            }
            ++i;
        }
        for (PathDisambiguator path : paths) {
            labels.put(path.uri, path.toString());
        }
    }

    public static void main(String[] args) {
        String absolutePath = "C:/bb/11/11/11/11/1js\u519b\u961f\u5efa\u8bbe";
        String base = "C:/bb";
        String relativePath = FilePathParser.toRelativePath(base, absolutePath);
        System.out.println(relativePath);
        System.out.println(FilePathParser.isPathRelative(relativePath));
    }

    private static class PathDisambiguator {
        URI uri;
        String head;
        String neck;
        File body;

        public PathDisambiguator(URI uri, File file) {
            this.uri = uri;
            this.head = file.getName();
            this.neck = null;
            this.body = file.getParentFile();
        }

        public void increaseDepth() {
            if (this.body == null) {
                return;
            }
            String name = this.body.getName();
            this.body = this.body.getParentFile();
            this.neck = this.neck == null ? name : String.valueOf(name) + File.separator + this.neck;
        }

        public boolean conflictsWith(PathDisambiguator that) {
            return that != null && this.head.equals(that.head) && (this.neck == null || this.neck == that.neck || this.neck != null && this.neck.equals(that.neck)) && (this.body != null || that.body != null);
        }

        public String toString() {
            return this.neck == null ? this.head : String.format("%2$s [%3$s]", File.separator, this.head, this.neck);
        }
    }
}

