/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.outline;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.PageBook;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IRevealServiceListener;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.RevealEvent;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tree.ITreeViewer;
import org.xmind.gef.tree.TreeRootPart;
import org.xmind.gef.tree.TreeSelectTool;
import org.xmind.gef.tree.TreeViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dnd.MindMapElementTransfer;
import org.xmind.ui.internal.e4models.ViewModelPart;
import org.xmind.ui.internal.editpolicies.ModifiablePolicy;
import org.xmind.ui.internal.outline.MindMapTreeViewer;
import org.xmind.ui.internal.outline.OutlineType;
import org.xmind.ui.internal.outline.OutlineViewer;
import org.xmind.ui.internal.outline.TopicTreePart;
import org.xmind.ui.internal.outline.resource.OutlineResources;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tabfolder.IPageClosedListener;
import org.xmind.ui.util.MindMapUtils;

public class OutlineIndexModelPart
extends ViewModelPart
implements IPartListener,
IPageChangedListener,
IContributedContentsView,
IPageClosedListener,
ICoreEventListener {
    public static final int OUTLINE_TYPE_NONE = 0;
    public static final int OUTLINE_TYPE_BY_MARKERS = 1;
    public static final int OUTLINE_TYPE_BY_LABELS = 2;
    public static final int OUTLINE_TYPE_BY_STARTDATE = 3;
    public static final int OUTLINE_TYPE_BY_ENDDATE = 4;
    public static final int OUTLINE_TYPE_BY_ASSIGNEE = 5;
    public static final int OUTLINE_TYPE_BY_AZ = 6;
    public static final int OUTLINE_TYPE_BY_ZA = 7;
    private static final String VIEWMENU_ID_FOR_OUTLINEPART = "org.eclipse.ui.views.ContentOutline";
    private CoreEventRegister coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private Composite parentComposite;
    private IGraphicalEditor sourceEditor;
    private OutlineResources outlineResources;
    private IGraphicalEditorPage sourcePage;
    private PageBook viewerStack;
    private Control defaultPage;
    private ITreeViewer editorTreeViewer;
    private Map<Object, ITreeViewer> pageViewers = new HashMap<Object, ITreeViewer>();
    private Map<IGraphicalEditor, Collection<IGraphicalEditorPage>> pages = new HashMap<IGraphicalEditor, Collection<IGraphicalEditorPage>>();
    private boolean showCurrentPage = false;
    private int outlineType = 0;
    private Map<IGraphicalEditor, Map<String, OutlineViewer>> outlineViewers = new HashMap<IGraphicalEditor, Map<String, OutlineViewer>>();
    private EditDomain domain;
    private IAction showWorkbookAction;
    private IAction showCurrentSheetAction;
    private MenuManager dropDownMenuManager;
    private Composite topComposite;
    private ToolItem indexTypeToolItem;

    protected void init() {
        super.init();
        this.registerViewMenu(VIEWMENU_ID_FOR_OUTLINEPART);
    }

    protected Control doCreateContent(Composite parent) {
        IWorkbenchPage activePage;
        this.parentComposite = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.topComposite = this.createTopComposite(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite contentComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        contentComposite.setLayout((Layout)gridLayout);
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerStack = new PageBook(contentComposite, 0);
        this.viewerStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPage = this.createDefaultPage((Composite)this.viewerStack);
        this.viewerStack.showPage(this.defaultPage);
        IWorkbenchWindow window = (IWorkbenchWindow)this.getAdapter(IWorkbenchWindow.class);
        if (window != null && (activePage = window.getActivePage()) != null) {
            this.partActivated((IWorkbenchPart)activePage.getActiveEditor());
            activePage.addPartListener((IPartListener)this);
        }
        return composite;
    }

    private Composite createTopComposite(Composite composite) {
        Composite topComposite = new Composite(composite, 131072);
        topComposite.setBackground(topComposite.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showWorkbookAction = new ShowWorkbookAction();
        this.showCurrentSheetAction = new ShowCurrentSheetAction();
        this.showWorkbookAction.setChecked(!this.isShowCurrentPage());
        this.showCurrentSheetAction.setChecked(this.isShowCurrentPage());
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.add(this.showWorkbookAction);
        toolBarManager.add(this.showCurrentSheetAction);
        ToolBar leftToolBar = toolBarManager.createControl(topComposite);
        leftToolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ToolBar rightToolBar = new ToolBar(topComposite, 0);
        rightToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.indexTypeToolItem = new ToolItem(rightToolBar, 4);
        this.indexTypeToolItem.setText(OutlineType.None.getName());
        this.indexTypeToolItem.addListener(12, this.getToolItemListener());
        this.indexTypeToolItem.addListener(13, this.getToolItemListener());
        return topComposite;
    }

    private Listener getToolItemListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        OutlineIndexModelPart.this.handleWidgetDispose(event);
                        break;
                    }
                    case 13: {
                        Widget ew = event.widget;
                        if (ew == null) break;
                        OutlineIndexModelPart.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                    }
                }
            }
        };
    }

    private void handleWidgetSelection(Event event, boolean selection) {
        if (event.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)event.widget;
            MenuManager menuMan = this.getDropDownMenuManager();
            Menu menu = menuMan.createContextMenu((Control)item.getParent());
            if (menu != null) {
                Rectangle b = item.getBounds();
                Point p = item.getParent().toDisplay(b.x, b.y + b.height);
                menu.setLocation(p.x, p.y);
                menu.setVisible(true);
            }
        }
    }

    private MenuManager getDropDownMenuManager() {
        if (this.dropDownMenuManager == null) {
            this.dropDownMenuManager = new MenuManager();
            this.dropDownMenuManager.setRemoveAllWhenShown(true);
            this.dropDownMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    String[] stringArray = OutlineType.getNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        manager.add((IAction)new IndexTypeAction(name));
                        ++n2;
                    }
                }
            });
        }
        return this.dropDownMenuManager;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget instanceof ToolItem && this.dropDownMenuManager != null) {
            this.dropDownMenuManager.dispose();
            this.dropDownMenuManager = null;
        }
    }

    private OutlineViewer getOutlineViewer(IGraphicalEditor editor, String viewerType) {
        Map<String, OutlineViewer> typeToViewers = this.outlineViewers.get(editor);
        if (typeToViewers == null) {
            return null;
        }
        return typeToViewers.get(viewerType);
    }

    private String parseOutlineTypeToViewerType(int outlineType) {
        if (outlineType == 3 || outlineType == 4) {
            return "multiColumn";
        }
        if (outlineType == 1 || outlineType == 2 || outlineType == 5 || outlineType == 6 || outlineType == 7) {
            return "singleColumn";
        }
        return null;
    }

    private void registerCoreEventForEditor() {
        IWorkbook workbook;
        if (this.sourceEditor != null && (workbook = (IWorkbook)this.sourceEditor.getAdapter(IWorkbook.class)) instanceof ICoreEventSource) {
            this.coreEventRegister = new CoreEventRegister((ICoreEventSource)workbook, (ICoreEventListener)this);
            this.coreEventRegister.register("modifyTime");
            this.coreEventRegister.register("workbookSave");
        }
    }

    public OutlineResources getOutlineResources() {
        return this.outlineResources;
    }

    public boolean isShowCurrentPage() {
        return this.showCurrentPage;
    }

    public void setOutlineType(int type) {
        if (type == 0) {
            this.outlineType = type;
            if (this.isShowCurrentPage()) {
                this.showCurrentPageViewer();
            } else {
                this.showEditorTreeViewer();
            }
        } else {
            String oldViewerType = this.parseOutlineTypeToViewerType(this.outlineType);
            OutlineViewer oldViewer = this.getOutlineViewer(this.sourceEditor, oldViewerType);
            this.outlineType = type;
            String viewerType = this.parseOutlineTypeToViewerType(type);
            OutlineViewer newViewer = this.getOutlineViewer(this.sourceEditor, viewerType);
            if (newViewer == null) {
                newViewer = this.createOutlineViewer(this.viewerStack, viewerType);
                Map<String, OutlineViewer> typeToViewer = this.outlineViewers.get(this.sourceEditor);
                typeToViewer.put(viewerType, newViewer);
            }
            this.outlineViewerChanged(oldViewer, newViewer);
        }
    }

    protected void dispose() {
        this.setEditor(null);
        IWorkbenchWindow window = (IWorkbenchWindow)this.getAdapter(IWorkbenchWindow.class);
        if (window != null) {
            window.getActivePage().removePartListener((IPartListener)this);
        }
        Object[] objectArray = this.pages.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object editor = objectArray[n2];
            this.partClosed((IWorkbenchPart)((IGraphicalEditor)editor));
            ++n2;
        }
        this.coreEventRegister.unregisterAll();
        super.dispose();
    }

    private Composite createDefaultPage(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(page, 16448);
        label.setText(MindMapMessages.OutlineIndexPart_DefaultPage_message);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return page;
    }

    protected void setFocus() {
        super.setFocus();
        OutlineViewer outlineViewer = this.getOutlineViewer(this.sourceEditor, this.parseOutlineTypeToViewerType(this.outlineType));
        if (outlineViewer != null && !outlineViewer.getControl().isDisposed()) {
            outlineViewer.setFocus();
        } else if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.setFocus();
        } else if (this.parentComposite != null && !this.parentComposite.isDisposed()) {
            this.parentComposite.setFocus();
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.sourceEditor;
    }

    public void pageClosed(Object pageObject) {
        if (pageObject instanceof IGraphicalEditorPage) {
            IGraphicalEditorPage page = (IGraphicalEditorPage)pageObject;
            this.unregisterSourcePage(page);
        }
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                OutlineIndexModelPart.this.setSourcePage(page);
            }
        });
    }

    public void partActivated(final IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                OutlineIndexModelPart.this.setEditor((IGraphicalEditor)part);
            }
        });
    }

    private void setEditor(IGraphicalEditor editor) {
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
        }
        this.sourceEditor = editor;
        this.outlineResources = editor == null ? null : new OutlineResources();
        this.registerCoreEventForEditor();
        if (editor != null && this.domain == null) {
            this.domain = new EditDomain();
            this.domain.installTool("select tool", (ITool)new TreeSelectTool());
            this.domain.setCommandStack(this.sourceEditor.getCommandStack());
            this.domain.installEditPolicy("org.xmind.ui.editPolicy.modifiable", (IEditPolicy)new ModifiablePolicy());
        }
        if (this.sourceEditor != null) {
            if (!this.outlineViewers.containsKey(this.sourceEditor)) {
                this.outlineViewers.put(this.sourceEditor, new HashMap());
            }
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            this.setSourcePage(this.sourceEditor.getActivePageInstance());
        } else {
            this.setSourcePage(null);
            this.viewerStack.showPage(this.defaultPage);
        }
    }

    private void setSourcePage(IGraphicalEditorPage page) {
        if (page == this.sourcePage) {
            return;
        }
        this.sourcePage = page;
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            Control pageToShow = this.defaultPage;
            if (this.sourcePage != null) {
                if (this.outlineType == 0) {
                    if (this.isShowCurrentPage()) {
                        this.showCurrentPageViewer();
                    } else {
                        this.showEditorTreeViewer();
                    }
                } else {
                    OutlineViewer viewer = this.ensureOutlineViewer(this.sourcePage);
                    if (viewer != null && !viewer.getControl().isDisposed()) {
                        pageToShow = viewer.getControl();
                    }
                    this.viewerStack.showPage(pageToShow);
                }
            }
        }
    }

    private void showEditorTreeViewer() {
        if (this.editorTreeViewer == null || this.editorTreeViewer.getControl() == null || this.editorTreeViewer.getControl().isDisposed()) {
            this.editorTreeViewer = this.createEditorTreeViewer();
            if (this.editorTreeViewer != null) {
                this.configureEditorTreeViewer(this.editorTreeViewer);
                this.createEditorTreeViewerControl(this.editorTreeViewer, (Composite)this.viewerStack);
                this.editorTreeViewer.setInput(this.sourceEditor.getAdapter(IWorkbook.class));
            }
        }
        if (this.editorTreeViewer != null) {
            Object newInput = this.sourceEditor.getAdapter(IWorkbook.class);
            if (newInput != this.editorTreeViewer.getInput()) {
                this.editorTreeViewer.setInput(newInput);
            }
            this.viewerStack.showPage(this.editorTreeViewer.getControl());
        }
    }

    private void showCurrentPageViewer() {
        IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
        if (page == null) {
            this.viewerStack.showPage(this.defaultPage);
            return;
        }
        Object pageInput = page.getInput();
        ITreeViewer pageTreeViewer = this.pageViewers.get(pageInput);
        if ((pageTreeViewer == null || pageTreeViewer.getControl() == null || pageTreeViewer.getControl().isDisposed()) && (pageTreeViewer = this.createPageTreeViewer()) != null) {
            this.configurePageTreeViewer(pageTreeViewer);
            this.createPageTreeViewerControl(pageTreeViewer, (Composite)this.viewerStack);
            pageTreeViewer.setInput(pageInput);
        }
        if (pageTreeViewer != null) {
            Object newInput = pageInput;
            if (newInput != pageTreeViewer.getInput()) {
                pageTreeViewer.setInput(newInput);
            }
            this.viewerStack.showPage(pageTreeViewer.getControl());
        }
    }

    private TreeViewer createEditorTreeViewer() {
        MindMapTreeViewer viewer = new MindMapTreeViewer();
        viewer.getProperties().set("PROP_HEADER_VISIBLE", false);
        return viewer;
    }

    private ITreeViewer createPageTreeViewer() {
        MindMapTreeViewer viewer = new MindMapTreeViewer();
        viewer.getProperties().set("PROP_HEADER_VISIBLE", false);
        return viewer;
    }

    private Control createEditorTreeViewerControl(ITreeViewer viewer, Composite parent) {
        Control control = ((TreeViewer)viewer).createControl(parent, 66306);
        this.hookViewerControl((IViewer)viewer, control);
        return control;
    }

    private Control createPageTreeViewerControl(ITreeViewer viewer, Composite parent) {
        Control control = ((TreeViewer)viewer).createControl(parent, 66306);
        this.hookViewerControl((IViewer)viewer, control);
        return control;
    }

    private void configureEditorTreeViewer(ITreeViewer viewer) {
        this.configureTreeViewer(viewer);
    }

    private void configurePageTreeViewer(ITreeViewer viewer) {
        this.configureTreeViewer(viewer);
    }

    protected void configureTreeViewer(ITreeViewer viewer) {
        viewer.setEditDomain(this.domain);
        viewer.setPartFactory(MindMapUI.getMindMapTreePartFactory());
        viewer.setRootPart((IRootPart)new TreeRootPart());
    }

    private void outlineViewerChanged(OutlineViewer oldViewer, OutlineViewer newViewer) {
        if (newViewer != null && !newViewer.getControl().isDisposed() && this.sourceEditor != null && this.sourcePage != null) {
            IWorkbookRef workbookRef = (IWorkbookRef)this.sourceEditor.getAdapter(IWorkbookRef.class);
            Object resourceForWorkbook = this.outlineResources.getResourceForWorkbook(workbookRef, this.outlineType, true);
            ISheet sheet = (ISheet)this.sourcePage.getAdapter(ISheet.class);
            Object resourceForSheet = this.outlineResources.getResourceForSheet(sheet, this.outlineType, true);
            if (this.showCurrentPage) {
                newViewer.setInput(resourceForSheet);
            } else {
                newViewer.setInput(resourceForWorkbook);
            }
            if (oldViewer != newViewer && this.viewerStack != null && !this.viewerStack.isDisposed()) {
                this.viewerStack.showPage(newViewer.getControl());
            }
        }
    }

    private OutlineViewer ensureOutlineViewer(IGraphicalEditorPage page) {
        String viewerType = this.parseOutlineTypeToViewerType(this.outlineType);
        OutlineViewer viewer = this.getOutlineViewer(this.sourceEditor, viewerType);
        if (viewer == null && this.sourceEditor != null) {
            viewer = this.createOutlineViewer(this.viewerStack, viewerType);
            this.registerSourcePage(page);
            Map<String, OutlineViewer> typeToViewer = this.outlineViewers.get(this.sourceEditor);
            typeToViewer.put(viewerType, viewer);
        }
        if (viewer != null) {
            if (this.showCurrentPage) {
                ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
                if (sheet != null && viewer.getInput() != this.outlineResources.getResourceForSheet(sheet, this.outlineType, true)) {
                    viewer.setInput(this.outlineResources.getResourceForSheet(sheet, this.outlineType, true));
                }
            } else {
                IWorkbookRef workbookRef = (IWorkbookRef)page.getParentEditor().getAdapter(IWorkbookRef.class);
                Object newInput = this.outlineResources.getResourceForWorkbook(workbookRef, this.outlineType, true);
                if (workbookRef != null && viewer.getInput() != newInput) {
                    viewer.setInput(newInput);
                }
            }
        }
        return viewer;
    }

    private void registerSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list == null) {
            list = new HashSet<IGraphicalEditorPage>();
            this.pages.put(editor, list);
        }
        list.add(page);
    }

    private void unregisterSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list != null) {
            list.remove(page);
            if (list.isEmpty()) {
                this.pages.remove(editor);
            }
        }
    }

    private OutlineViewer createOutlineViewer(PageBook parent, String viewerType) {
        final OutlineViewer viewer = new OutlineViewer((Composite)parent, viewerType);
        viewer.setAutoExpandLevel(4);
        viewer.getTree().setLinesVisible(true);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
                    OutlineIndexModelPart.this.reveal((ITopic)element);
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
                    OutlineIndexModelPart.this.handleDoubleClick((Control)viewer.getTree(), MindMapUtils.findTopicPart((IViewer)OutlineIndexModelPart.this.sourceEditor.getAdapter(IGraphicalViewer.class), (ITopic)element));
                }
            }
        });
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return viewer;
    }

    private void reveal(ITopic topic) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.getSite().getPage().activate((IWorkbenchPart)this.sourceEditor);
        if (topic != null) {
            Object selectedPage;
            ISelectionProvider selectionProvider = this.sourceEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object)topic));
            }
            if ((selectedPage = this.sourceEditor.getSelectedPage()) instanceof IGraphicalEditorPage) {
                IGraphicalEditorPage page = (IGraphicalEditorPage)selectedPage;
                IGraphicalViewer viewer = page.getViewer();
                if (viewer == null) {
                    return;
                }
                IPart selectedPart = viewer.getFocusedPart();
                if (selectedPart instanceof IGraphicalPart) {
                    IGraphicalPart part = (IGraphicalPart)selectedPart;
                    new CenteredRevealHelper((IViewer)viewer).start(part);
                }
            }
        }
    }

    private void disposeOutlineViewer(OutlineViewer viewer) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().dispose();
            viewer = null;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        Map<String, OutlineViewer> typeToViewer;
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Collection<IGraphicalEditorPage> oldPages = this.pages.remove(part);
        if (part == this.sourceEditor) {
            this.setEditor(null);
        }
        if (oldPages != null) {
            Object[] objectArray = oldPages.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.pageClosed(page);
                ++n2;
            }
        }
        if ((typeToViewer = this.outlineViewers.remove(part)) != null) {
            for (OutlineViewer viewer : typeToViewer.values()) {
                this.disposeOutlineViewer(viewer);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void handleCoreEvent(CoreEvent event) {
        if (this.sourceEditor == null) {
            return;
        }
        final String type = event.getType();
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ("workbookSave".equals(type)) {
                        OutlineViewer currentViewer = OutlineIndexModelPart.this.getOutlineViewer(OutlineIndexModelPart.this.sourceEditor, OutlineIndexModelPart.this.parseOutlineTypeToViewerType(OutlineIndexModelPart.this.outlineType));
                        if (currentViewer != null) {
                            currentViewer.refresh();
                        }
                    } else if ("modifyTime".equals(type) && OutlineIndexModelPart.this.sourceEditor != null) {
                        Control control;
                        OutlineViewer currentViewer;
                        IWorkbookRef workbookRef = (IWorkbookRef)OutlineIndexModelPart.this.sourceEditor.getAdapter(IWorkbookRef.class);
                        Object resourceForWorkbook = OutlineIndexModelPart.this.outlineResources.getResourceForWorkbook(workbookRef, OutlineIndexModelPart.this.outlineType, true);
                        Object resourceForSheet = null;
                        if (OutlineIndexModelPart.this.sourcePage != null) {
                            ISheet sheet = (ISheet)OutlineIndexModelPart.this.sourcePage.getAdapter(ISheet.class);
                            resourceForSheet = OutlineIndexModelPart.this.outlineResources.getResourceForSheet(sheet, OutlineIndexModelPart.this.outlineType, true);
                        }
                        if ((currentViewer = OutlineIndexModelPart.this.getOutlineViewer(OutlineIndexModelPart.this.sourceEditor, OutlineIndexModelPart.this.parseOutlineTypeToViewerType(OutlineIndexModelPart.this.outlineType))) != null && (control = currentViewer.getControl()) != null && !control.isDisposed()) {
                            if (!OutlineIndexModelPart.this.showCurrentPage) {
                                if (resourceForWorkbook != null) {
                                    currentViewer.setInput(resourceForWorkbook);
                                }
                            } else if (resourceForSheet != null) {
                                currentViewer.setInput(resourceForSheet);
                            }
                        }
                    }
                }
            });
        }
    }

    private void hookViewerControl(final IViewer viewer, final Control control) {
        final DragSource dragSource = new DragSource(control, 3);
        dragSource.setTransfer(new Transfer[]{MindMapElementTransfer.getInstance(), TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            Object[] elements;
            String text;

            public void dragStart(DragSourceEvent event) {
                this.elements = this.getElements();
                if (this.elements == null || this.elements.length == 0) {
                    event.doit = false;
                } else {
                    this.text = this.createText(this.elements);
                }
            }

            private Object[] getElements() {
                TreeItem[] selection;
                if (control instanceof Tree && (selection = ((Tree)control).getSelection()).length > 0) {
                    Object[] elements = new Object[selection.length];
                    int i = 0;
                    while (i < selection.length) {
                        TreeItem item = selection[i];
                        Object data = item.getData();
                        if (data instanceof IPart) {
                            data = ((IPart)data).getModel();
                        }
                        elements[i] = data;
                        ++i;
                    }
                    return elements;
                }
                return null;
            }

            public void dragSetData(DragSourceEvent event) {
                if (MindMapElementTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.elements;
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.text;
                }
            }

            private String createText(Object[] elements) {
                IDndClient textClient = MindMapUI.getMindMapDndSupport().getDndClient("org.xmind.ui.dnd.text");
                if (textClient == null) {
                    return null;
                }
                Object data = textClient.toTransferData(elements, viewer);
                return data instanceof String ? (String)data : null;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        control.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Tree tree = (Tree)control;
                TreeItem[] selection = tree.getSelection();
                if (selection.length == 0) {
                    return;
                }
                TreeItem item = selection[0];
                if (!(item.getData() instanceof TopicTreePart)) {
                    return;
                }
                TopicTreePart part = (TopicTreePart)((Object)item.getData());
                OutlineIndexModelPart.this.reveal(part.getTopic());
            }
        });
        control.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                OutlineIndexModelPart.this.handleDoubleClick(control, null);
                event.doit = false;
            }
        });
    }

    private void handleDoubleClick(Control control, ITopicPart topicPart) {
        this.startEditing(control, topicPart);
    }

    private void startEditing(Control control, final ITopicPart topicPart) {
        Tree tree = (Tree)control;
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return;
        }
        final TreeItem item = selection[0];
        if (!(item.getData() instanceof TopicTreePart) && topicPart == null) {
            return;
        }
        TreeEditor editor = new TreeEditor(tree){

            public void layout() {
                super.layout();
                Control editor = this.getEditor();
                if (editor == null || editor.isDisposed()) {
                    return;
                }
                Rectangle bounds = editor.getBounds();
                Point prefSize = editor.computeSize(-1, -1);
                if (prefSize.y > bounds.height) {
                    bounds.y += (bounds.height - prefSize.y - 1) / 2;
                    bounds.height = prefSize.y;
                }
                editor.setBounds(bounds);
            }
        };
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        final Text text = new Text((Composite)tree, 2052);
        text.setCursor(Display.getCurrent().getSystemCursor(19));
        editor.setEditor((Control)text, item);
        final String oldValue = item.getText();
        text.setText(oldValue);
        text.setFocus();
        text.selectAll();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (item != null && !item.isDisposed()) {
                    item.setText(text.getText() == null ? oldValue : text.getText());
                    OutlineIndexModelPart.this.modifyTreeItem(item, topicPart);
                }
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        text.dispose();
                    }
                });
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        item.setText(oldValue);
                        e.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                text.dispose();
                            }
                        });
                        break;
                    }
                    case '\r': {
                        if (item != null && !item.isDisposed()) {
                            item.setText(text.getText() == null ? oldValue : text.getText());
                            OutlineIndexModelPart.this.modifyTreeItem(item, topicPart);
                        }
                        e.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                text.dispose();
                            }
                        });
                    }
                }
            }
        });
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (text != null && !text.isDisposed()) {
                    text.dispose();
                }
            }
        });
    }

    private void modifyTreeItem(TreeItem item, ITopicPart topicPart) {
        Object o;
        if (topicPart != null) {
            topicPart.handleRequest(new Request("modify").setViewer(topicPart.getSite().getViewer()).setParameter("text", (Object)item.getText()).setPrimaryTarget((IPart)topicPart), "modifiable role");
        }
        if ((o = item.getData()) instanceof IPart) {
            IPart part = (IPart)o;
            part.handleRequest(new Request("modify").setViewer(part.getSite().getViewer()).setParameter("text", (Object)item.getText()).setPrimaryTarget(part), "modifiable role");
        }
    }

    private class CenteredRevealHelper
    implements IRevealServiceListener {
        private ZoomingAndPanningRevealService service;
        private boolean oldCentered;

        public CenteredRevealHelper(IViewer viewer) {
            IViewerService service = viewer.getService(IRevealService.class);
            if (service != null && service instanceof ZoomingAndPanningRevealService) {
                this.service = (ZoomingAndPanningRevealService)service;
                this.oldCentered = this.service.isCentered();
            } else {
                this.service = null;
                this.oldCentered = false;
            }
        }

        public void start(IGraphicalPart part) {
            if (this.service != null) {
                this.service.setCentered(true);
                this.service.reveal((ISelection)new StructuredSelection((Object)part));
                this.service.addRevealServiceListener((IRevealServiceListener)this);
            }
        }

        public void revealingStarted(RevealEvent event) {
        }

        public void revealingCanceled(RevealEvent event) {
            this.restore();
        }

        public void revealingFinished(RevealEvent event) {
            this.restore();
        }

        void restore() {
            this.service.removeRevealServiceListener((IRevealServiceListener)this);
            this.service.setCentered(this.oldCentered);
        }
    }

    private class IndexTypeAction
    extends Action {
        IndexTypeAction(String name) {
            super(name, 2);
        }

        public void run() {
            if (OutlineIndexModelPart.this.indexTypeToolItem != null && !OutlineIndexModelPart.this.indexTypeToolItem.isDisposed()) {
                OutlineIndexModelPart.this.setOutlineType(OutlineType.findByName(this.getText()).getType());
                OutlineIndexModelPart.this.indexTypeToolItem.setText(this.getText());
                if (OutlineIndexModelPart.this.topComposite != null && !OutlineIndexModelPart.this.topComposite.isDisposed()) {
                    OutlineIndexModelPart.this.topComposite.pack(true);
                    OutlineIndexModelPart.this.topComposite.getParent().layout(true, true);
                }
            }
        }
    }

    private class ShowCurrentSheetAction
    extends Action {
        public ShowCurrentSheetAction() {
            super(MindMapMessages.OutlineIndexPart_ShowCurrentSheetAction_text);
            this.setId("org.xmind.ui.showCurrentSheet");
            this.setToolTipText(MindMapMessages.OutlineIndexPart_ShowCurrentSheetAction_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("sheet.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("sheet.png", false));
        }

        public void run() {
            OutlineIndexModelPart.this.showCurrentPage = true;
            OutlineIndexModelPart.this.showCurrentSheetAction.setChecked(OutlineIndexModelPart.this.showCurrentPage);
            OutlineIndexModelPart.this.showWorkbookAction.setChecked(!OutlineIndexModelPart.this.showCurrentPage);
            if (OutlineIndexModelPart.this.sourcePage == null) {
                return;
            }
            ISheet sheet = (ISheet)OutlineIndexModelPart.this.sourcePage.getAdapter(ISheet.class);
            if (sheet == null) {
                return;
            }
            if (OutlineIndexModelPart.this.outlineType == 0) {
                OutlineIndexModelPart.this.showCurrentPageViewer();
            } else {
                OutlineViewer currentViewer = OutlineIndexModelPart.this.getOutlineViewer(OutlineIndexModelPart.this.sourceEditor, OutlineIndexModelPart.this.parseOutlineTypeToViewerType(OutlineIndexModelPart.this.outlineType));
                if (currentViewer != null && !currentViewer.getControl().isDisposed()) {
                    currentViewer.setInput(OutlineIndexModelPart.this.outlineResources.getResourceForSheet(sheet, OutlineIndexModelPart.this.outlineType, false));
                    OutlineIndexModelPart.this.viewerStack.showPage(currentViewer.getControl());
                }
            }
        }
    }

    private class ShowWorkbookAction
    extends Action {
        public ShowWorkbookAction() {
            super(MindMapMessages.OutlineIndexPart_ShowWorkbookAction_text, 8);
            this.setId("org.xmind.ui.showWorkbook");
            this.setToolTipText(MindMapMessages.OutlineIndexPart_ShowWorkbookAction_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("workbook.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("workbook.png", false));
        }

        public void run() {
            OutlineIndexModelPart.this.showCurrentPage = false;
            OutlineIndexModelPart.this.showCurrentSheetAction.setChecked(OutlineIndexModelPart.this.showCurrentPage);
            OutlineIndexModelPart.this.showWorkbookAction.setChecked(!OutlineIndexModelPart.this.showCurrentPage);
            if (OutlineIndexModelPart.this.sourceEditor == null) {
                return;
            }
            IWorkbookRef workbookRef = (IWorkbookRef)OutlineIndexModelPart.this.sourceEditor.getAdapter(IWorkbookRef.class);
            if (workbookRef == null) {
                return;
            }
            if (OutlineIndexModelPart.this.outlineType == 0) {
                OutlineIndexModelPart.this.showEditorTreeViewer();
            } else {
                OutlineViewer currentViewer = OutlineIndexModelPart.this.getOutlineViewer(OutlineIndexModelPart.this.sourceEditor, OutlineIndexModelPart.this.parseOutlineTypeToViewerType(OutlineIndexModelPart.this.outlineType));
                if (currentViewer != null && !currentViewer.getControl().isDisposed()) {
                    currentViewer.setInput(OutlineIndexModelPart.this.outlineResources.getResourceForWorkbook(workbookRef, OutlineIndexModelPart.this.outlineType, false));
                    OutlineIndexModelPart.this.viewerStack.showPage(currentViewer.getControl());
                }
            }
        }
    }
}

