/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.mindmap.IMindMapEditorConfigurer;
import org.xmind.ui.util.Logger;

public class MindMapEditorConfigurerManager
extends RegistryReader {
    private static final MindMapEditorConfigurerManager instance = new MindMapEditorConfigurerManager();
    private Map<String, IMindMapEditorConfigurer> configurers = null;

    private MindMapEditorConfigurerManager() {
    }

    public void configureEditor(MindMapEditor editor) {
        this.ensureLoaded();
        for (IMindMapEditorConfigurer configurer : this.configurers.values()) {
            try {
                configurer.configureEditor((IGraphicalEditor)editor);
            }
            catch (Throwable e) {
                Logger.log(e);
            }
        }
    }

    public void configurePage(IGraphicalEditorPage page) {
        this.ensureLoaded();
        for (IMindMapEditorConfigurer configurer : this.configurers.values()) {
            try {
                configurer.configureEditorPage(page);
            }
            catch (Throwable e) {
                Logger.log(e);
            }
        }
    }

    private void ensureLoaded() {
        if (this.configurers != null) {
            return;
        }
        this.lazyLoad();
        if (this.configurers == null) {
            this.configurers = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "mindMapEditorConfigurer");
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("configurer".equals(name)) {
            this.readConfigurer(element);
            return true;
        }
        return false;
    }

    private void readConfigurer(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null) {
            return;
        }
        try {
            this.addConfigurer(id, this.createConfigurer(element));
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private void addConfigurer(String id, IMindMapEditorConfigurer configurer) {
        if (this.configurers == null) {
            this.configurers = new HashMap<String, IMindMapEditorConfigurer>();
        }
        this.configurers.put(id, configurer);
    }

    private IMindMapEditorConfigurer createConfigurer(IConfigurationElement element) throws CoreException {
        String clazz = element.getAttribute("class");
        if (clazz == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension(missing class attribute)"));
        }
        return (IMindMapEditorConfigurer)element.createExecutableExtension("class");
    }

    public static MindMapEditorConfigurerManager getInstance() {
        return instance;
    }
}

