/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command;

import java.io.File;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.xmind.core.command.ICommandService;
import org.xmind.core.internal.command.BinaryUtil;
import org.xmind.core.internal.command.XMindCommandHandlerRegistry;
import org.xmind.core.internal.command.XMindCommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMindCommandPlugin
implements BundleActivator,
ServiceTrackerCustomizer<IExtensionRegistry, IExtensionRegistry> {
    public static final String PLUGIN_ID = "org.xmind.core.command";
    private static BundleContext bundleContext;
    private static XMindCommandPlugin singleton;
    private ICommandService commandService = null;
    private ServiceRegistration<ICommandService> commandServiceRegistration = null;
    private ServiceTracker<IExtensionRegistry, IExtensionRegistry> registryTracker = null;
    private File cacheLocation = null;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;

    public void start(BundleContext bundleContext) throws Exception {
        XMindCommandPlugin.bundleContext = bundleContext;
        singleton = this;
        this.commandService = new XMindCommandService();
        this.commandServiceRegistration = bundleContext.registerService(ICommandService.class, (Object)this.commandService, null);
        this.registryTracker = new ServiceTracker(bundleContext, IExtensionRegistry.class, (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.registryTracker != null) {
            this.registryTracker.close();
            this.registryTracker = null;
        }
        if (this.commandServiceRegistration != null) {
            this.commandServiceRegistration.unregister();
            this.commandServiceRegistration = null;
        }
        this.commandService = null;
        if (this.cacheLocation != null) {
            BinaryUtil.delete(this.cacheLocation);
            this.cacheLocation = null;
        }
        XMindCommandPlugin.bundleContext = null;
        singleton = null;
    }

    public File getBinaryCacheLocation() {
        if (this.cacheLocation == null) {
            this.cacheLocation = new File(Platform.getStateLocation((Bundle)bundleContext.getBundle()).toFile(), ".binarycaches");
        }
        return this.cacheLocation;
    }

    public ICommandService getCommandService() {
        return this.commandService;
    }

    public IExtensionRegistry addingService(ServiceReference<IExtensionRegistry> reference) {
        IExtensionRegistry registry = (IExtensionRegistry)bundleContext.getService(reference);
        XMindCommandHandlerRegistry.getInstance().installRegistryEventListener(registry);
        return registry;
    }

    public void modifiedService(ServiceReference<IExtensionRegistry> reference, IExtensionRegistry service) {
    }

    public void removedService(ServiceReference<IExtensionRegistry> reference, IExtensionRegistry registry) {
        XMindCommandHandlerRegistry.getInstance().uninstallRegistryEventListener(registry);
        bundleContext.ungetService(reference);
    }

    private DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(bundleContext, DebugOptions.class, null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public static boolean isDebugging(String option) {
        DebugOptions options = XMindCommandPlugin.getDefault().getDebugOptions();
        return options != null && options.getBooleanOption(PLUGIN_ID + option, false);
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)bundleContext.getBundle());
    }

    public static XMindCommandPlugin getDefault() {
        return singleton;
    }
}

