/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.windows.WindowsBrowser;
import edu.stanford.ejalbert.launching.windows.WindowsBrowserLaunching;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

abstract class DefaultWindowsBrowserLaunching
extends WindowsBrowserLaunching {
    private Map browserNameAndExeMap = null;
    protected static final String FIRST_WINDOWS_PARAMETER = "/c";
    protected static final String SECOND_WINDOWS_PARAMETER = "start";
    protected static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    static /* synthetic */ Class class$edu$stanford$ejalbert$launching$windows$DefaultWindowsBrowserLaunching;

    protected DefaultWindowsBrowserLaunching(AbstractLogger logger) {
        super(logger);
    }

    protected abstract String[] getCommandArgs(String var1, String var2);

    protected abstract String[] getCommandArgs(String var1, String var2, String var3);

    protected Map getAvailableBrowsers(List browsersToCheck) {
        this.logger.debug("entering getAvailableBrowsers");
        this.logger.debug("browsers to check: " + browsersToCheck);
        TreeMap<String, WindowsBrowser> browsersAvailable = new TreeMap<String, WindowsBrowser>(String.CASE_INSENSITIVE_ORDER);
        try {
            String line;
            File tmpFile = File.createTempFile("bl2-app-paths", ".reg");
            String[] cmdArgs = new String[]{"regedit.exe", "/E", "\"" + tmpFile.getAbsolutePath() + "\"", "\"HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\""};
            Process process = Runtime.getRuntime().exec(cmdArgs);
            int exitCode = -1;
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException exec'ing regedit.exe: " + e.getMessage());
            }
            if (exitCode != 0) {
                this.logger.error("Unable to exec regedit.exe to extract available browsers.");
                tmpFile.delete();
                return browsersAvailable;
            }
            FileInputStream fis = new FileInputStream(tmpFile);
            byte[] magic = new byte[2];
            fis.read(magic);
            fis.close();
            InputStreamReader in = null;
            in = magic[0] == -1 && magic[1] == -2 ? new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-16") : new InputStreamReader(new FileInputStream(tmpFile));
            BufferedReader reader = new BufferedReader(in);
            while ((line = reader.readLine()) != null) {
                Iterator iter = browsersToCheck.iterator();
                boolean foundBrowser = false;
                while (iter.hasNext() && !foundBrowser) {
                    WindowsBrowser winBrowser = (WindowsBrowser)iter.next();
                    String exeName = winBrowser.getExe().toLowerCase() + ".exe";
                    if (line.toLowerCase().lastIndexOf(exeName) < 0) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(line);
                        this.logger.debug("Adding browser " + winBrowser.getDisplayName() + " to available list.");
                    }
                    browsersAvailable.put(winBrowser.getDisplayName(), winBrowser);
                    browsersAvailable.put(winBrowser.getExe(), winBrowser);
                    iter.remove();
                    foundBrowser = true;
                }
            }
            in.close();
            tmpFile.delete();
        }
        catch (IOException e) {
            this.logger.error("Error listing available browsers: " + e.getMessage());
        }
        return browsersAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBrowserMap() {
        Class clazz = class$edu$stanford$ejalbert$launching$windows$DefaultWindowsBrowserLaunching == null ? (class$edu$stanford$ejalbert$launching$windows$DefaultWindowsBrowserLaunching = DefaultWindowsBrowserLaunching.class$("edu.stanford.ejalbert.launching.windows.DefaultWindowsBrowserLaunching")) : class$edu$stanford$ejalbert$launching$windows$DefaultWindowsBrowserLaunching;
        synchronized (clazz) {
            if (this.browserNameAndExeMap == null) {
                ArrayList<WindowsBrowser> browsersToCheck = new ArrayList<WindowsBrowser>();
                browsersToCheck.add(WindowsBrowser.FIREFOX);
                browsersToCheck.add(WindowsBrowser.IEXPLORER);
                browsersToCheck.add(WindowsBrowser.MOZILLA);
                this.browserNameAndExeMap = this.getAvailableBrowsers(browsersToCheck);
            }
        }
    }

    protected final Map getBrowserMap() {
        this.initBrowserMap();
        return this.browserNameAndExeMap;
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.logger.info(urlString);
            String protocol = this.getProtocol(urlString);
            this.logger.info(protocol);
            String[] args = this.getCommandArgs(protocol, urlString);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getArrayAsString(args));
            }
            Process process = Runtime.getRuntime().exec(args);
            process.waitFor();
            process.exitValue();
        }
        catch (Exception e) {
            this.logger.error("fatal exception", e);
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if ("Default".equals(browser) || browser == null) {
            this.logger.info("default or null browser target");
            this.openUrl(urlString);
            return;
        }
        Map browserMap = this.getBrowserMap();
        WindowsBrowser winBrowser = (WindowsBrowser)browserMap.get(browser);
        if (winBrowser == null) {
            this.logger.info("the available browsers list does not contain: " + browser);
            this.logger.info("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            boolean successfullLaunch = false;
            try {
                this.logger.info(winBrowser.getDisplayName());
                this.logger.info(urlString);
                String protocol = this.getProtocol(urlString);
                this.logger.info(protocol);
                String[] args = this.getCommandArgs(protocol, winBrowser.getExe(), urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getArrayAsString(args));
                }
                Process process = Runtime.getRuntime().exec(args);
                process.waitFor();
                successfullLaunch = process.exitValue() == 0;
            }
            catch (Exception e) {
                this.logger.error("fatal exception", e);
                successfullLaunch = false;
            }
            if (!successfullLaunch) {
                this.logger.debug("falling through to non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    public List getBrowserList() {
        Map browserMap = this.getBrowserMap();
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add("Default");
        Iterator iter = browserMap.keySet().iterator();
        while (iter.hasNext()) {
            WindowsBrowser winBrowser;
            String key = (String)iter.next();
            if (!key.equals((winBrowser = (WindowsBrowser)browserMap.get(key)).getDisplayName())) continue;
            browsers.add(winBrowser.getDisplayName());
        }
        return browsers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

