/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_DRAW
#  define H_DRAW

/************************************************************************
 * Type definitions
 ************************************************************************/

typedef enum {
    LIGHTOFF,
    LIGHTON
} light;

/*
 * Holds several information about the graphics part of the program:
 * pixmaps used, backlight settings, and more general X/windowing settings.
 */
typedef struct {
    Pixmap backdrop_on;         /* Background with light on */
    Pixmap backdrop_off;        /* Background with light off */
    Pixmap parts;               /* digits, icons and stuff */
    Pixmap mask;
    Pixmap pixmap;              /* The pixmap which is actually displayed */

    char  *light_color;         /* back-light color value */
    light  backlight;           /* indicates whether the backlight is on or off */

    char  *display_name;        /* which X Window display to use */
#if 0 /* not used yet */
    Bool   iswindowed;          /* says if the program is windowed */
    Bool   isbrokenwm;          /* says if the WM is broken (?) */
#endif
} DrawConfig;

/************************************************************************
 * Global variable declarations
 ************************************************************************/

#  if 0
extern light backlight;
extern char *display_name;
extern char *light_color;
extern Pixmap pixmap;
#  endif

/************************************************************************
 * Function prototypes for draw.c
 ************************************************************************/

/*
 * Connects to the X server to get a window, draw it, and show it.
 *
 * This function returns 1 if the xpm/pixmap conversion fails, else 0.
 */
int draw_init(DrawConfig *, int, char **);

/* Draws the entire window */
void draw_window(DrawConfig *, AcpiInfos *);

/* Switches the "backlight" variable, and redraws the entire window */
void switch_light(DrawConfig *, AcpiInfos *);

/*      
 * Displays the temperature of the active thermal sensor, as a two-digit
 * number.
 *
 * TODO: consider negative temperatures ?
 * TODO: draw "--" when no thermal zone ?
 */
void draw_tempdigit(DrawConfig *, AcpiInfos *);

/*
 *  Draws the numerical value of battery load percentage. 
 *
 *  If the battery is unplugged, or if there is no battery slot at all, then
 *  '---%' is drawn.
 */
void draw_pcdigit(DrawConfig *, AcpiInfos *);

/*
 * Draws the charging status.
 *
 * If a charging battery is present, the 'C' is drawn. If there is no battery
 * or the battery is unplugged, '-' is drawn.
 */
void draw_statusdigit(DrawConfig *, AcpiInfos *);

/* Draws the AC power online OR the battery icon. */
void draw_power_icon(DrawConfig *, AcpiInfos *);

/* Draws the dots representing the battery charge. */
void draw_pcgraph(DrawConfig *, AcpiInfos *);

/* Draws the background corresponding to the given light */
void draw_background(DrawConfig *, light);

#endif                          /* H_DRAW */
