/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumable;
import gnu.lists.FilterConsumer;
import gnu.lists.UnescapedData;
import gnu.mapping.OutPort;
import gnu.xml.XMLPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpPrinter
extends FilterConsumer {
    Vector headers = new Vector();
    StringBuffer sbuf = new StringBuffer(100);
    String currentHeader;
    protected String sawContentType;
    OutputStream ostream;
    OutPort writer;
    boolean seenXmlHeader;

    public HttpPrinter(OutputStream outputStream) {
        super(null);
        this.ostream = outputStream;
    }

    public HttpPrinter(OutPort outPort) {
        super(null);
        this.writer = outPort;
    }

    public static HttpPrinter make(OutPort outPort) {
        return new HttpPrinter(outPort);
    }

    private void writeRaw(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                this.ostream.write((byte)string.charAt(n2));
                ++n2;
            }
        }
    }

    public void printHeader(String string, String string2) throws IOException {
        this.writeRaw(string);
        this.writeRaw(": ");
        this.writeRaw(string2);
        this.writeRaw("\n");
    }

    public void printHeaders() throws IOException {
        int n = this.headers.size();
        int n2 = 0;
        while (n2 < n) {
            this.printHeader(this.headers.elementAt(n2).toString(), this.headers.elementAt(n2 + 1).toString());
            n2 += 2;
        }
        this.writeRaw("\n");
    }

    public void addHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-type")) {
            this.sawContentType = string2;
        }
        this.headers.addElement(string);
        this.headers.addElement(string2);
    }

    public void beginAttribute(String string, Object object2) {
        if (this.base == null) {
            this.currentHeader = string;
        } else {
            this.base.beginAttribute(string, object2);
        }
    }

    public void endAttribute() {
        if (this.currentHeader != null) {
            this.addHeader(this.currentHeader, this.sbuf.toString());
            this.sbuf.setLength(0);
            this.currentHeader = null;
        } else {
            this.base.endAttribute();
        }
    }

    public void beginData() {
        if (this.base == null) {
            if (this.sawContentType == null) {
                this.addHeader("Content-type", "text/html");
            }
            if (this.writer == null) {
                this.writer = new OutPort(this.ostream);
            }
            String string = null;
            if ("text/html".equalsIgnoreCase(this.sawContentType)) {
                string = "html";
            } else if ("text/xhtml".equalsIgnoreCase(this.sawContentType)) {
                string = "xhtml";
            } else if ("text/plain".equalsIgnoreCase(this.sawContentType)) {
                string = "plain";
            }
            this.base = XMLPrinter.make(this.writer, string);
            try {
                this.printHeaders();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString());
            }
        }
        this.writeChars(this.sbuf.toString());
        this.sbuf.setLength(0);
    }

    public void beginGroup(String string, Object object2) {
        if (this.sawContentType == null) {
            String string2 = !this.seenXmlHeader ? "text/html" : (string.equals("html") ? "text/xhtml" : "text/xml");
            this.addHeader("Content-type", string2);
        }
        this.beginData();
        this.base.beginGroup(string, object2);
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable && !(object2 instanceof UnescapedData)) {
            ((Consumable)object2).consume(this);
        } else {
            this.beginData();
            super.writeObject(object2);
        }
    }

    public void writeChars(String string) {
        if (this.base == null) {
            this.sbuf.append(string);
        } else {
            this.base.writeChars(string);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.base == null) {
            this.sbuf.append(cArray, n, n2);
        } else {
            this.base.write(cArray, n, n2);
        }
    }

    public void beginDocument() {
        if (this.base != null) {
            this.base.beginDocument();
        }
    }

    public void endDocument() {
        if (this.base != null) {
            this.base.endDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.ostream != null) {
                this.ostream.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

