/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;

public final class ChainVersionMatcher
extends AbstractVersionMatcher {
    private List matchers = new LinkedList();

    public ChainVersionMatcher() {
        super("chain");
    }

    public final void add(VersionMatcher versionMatcher) {
        LogOptions.checkNotNull(versionMatcher, "matcher");
        this.matchers.add(0, versionMatcher);
        if (this.getSettings() != null && versionMatcher instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(this.getSettings());
        }
    }

    @Override
    public final void setSettings(IvySettings ivySettings) {
        super.setSettings(ivySettings);
        for (VersionMatcher versionMatcher : this.matchers) {
            if (!(versionMatcher instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(ivySettings);
        }
    }

    @Override
    public final boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        LogOptions.checkNotNull(moduleRevisionId, "askedMrid");
        Iterator iterator2 = this.matchers.iterator();
        while (iterator2.hasNext()) {
            if (!((VersionMatcher)iterator2.next()).isDynamic(moduleRevisionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        LogOptions.checkNotNull(moduleRevisionId, "askedMrid");
        LogOptions.checkNotNull(moduleRevisionId2, "foundMrid");
        LogOptions.checkNotNull(comparator, "staticComparator");
        for (VersionMatcher versionMatcher : this.matchers) {
            if (!versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.compare(moduleRevisionId, moduleRevisionId2, comparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + moduleRevisionId);
    }

    @Override
    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        LogOptions.checkNotNull(moduleRevisionId, "askedMrid");
        LogOptions.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator2 = this.matchers.iterator();
        while (iterator2.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator2.next();
            if (iterator2.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    @Override
    public final boolean needModuleDescriptor(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        LogOptions.checkNotNull(moduleRevisionId, "askedMrid");
        LogOptions.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator2 = this.matchers.iterator();
        while (iterator2.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator2.next();
            if (iterator2.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.needModuleDescriptor(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    @Override
    public final boolean accept(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) {
        LogOptions.checkNotNull(moduleRevisionId, "askedMrid");
        LogOptions.checkNotNull(moduleDescriptor, "foundMD");
        Iterator iterator2 = this.matchers.iterator();
        while (iterator2.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator2.next();
            if (iterator2.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleDescriptor);
        }
        return false;
    }
}

