/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.restdocs.internal;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SwaggerService {
    private static final String ALIAS = "/doc";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpService httpService;

    @Reference
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Activate
    protected void activate() {
        try {
            this.httpService.registerResources(ALIAS, "swagger", this.httpService.createDefaultHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Could not start up REST documentation service: {}", (Object)e.getMessage());
        }
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister(ALIAS);
    }
}

