/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.homebuilder.internal;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HomeBuilderServlet {
    public static final String HOMEBUILDER_ALIAS = "/homebuilder";
    private final Logger logger = LoggerFactory.getLogger(HomeBuilderServlet.class);
    protected HttpService httpService;

    @Activate
    protected void activate() {
        try {
            this.httpService.registerResources(HOMEBUILDER_ALIAS, "web", null);
            this.logger.info("Started Home Builder at {}", (Object)HOMEBUILDER_ALIAS);
        }
        catch (NamespaceException e) {
            this.logger.error("Error during Home Builder startup: {}", (Object)e.getMessage());
        }
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister(HOMEBUILDER_ALIAS);
        this.logger.info("Stopped Home Builder");
    }

    @Reference
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

