/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal.render;

import com.google.gson.JsonObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.model.sitemap.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.basic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.basic.render.RenderException;
import org.openhab.ui.basic.render.WidgetRenderer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WidgetRenderer.class})
public class SelectionRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(SelectionRenderer.class);

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Selection;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        String snippet = this.getSnippet("selection");
        snippet = this.preprocessSnippet(snippet, w);
        State state = this.itemUIRegistry.getState(w);
        Selection selection = (Selection)w;
        String mappingLabel = null;
        Item item = null;
        try {
            item = this.itemUIRegistry.getItem(w.getItem());
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("Failed to retrieve item during widget rendering: {}", (Object)e.getMessage());
        }
        JsonObject jsonObject = new JsonObject();
        StringBuilder rowSB = new StringBuilder();
        if (selection.getMappings().size() == 0 && item != null) {
            StateDescription stateDescription = item.getStateDescription();
            if (stateDescription != null) {
                for (StateOption option : stateDescription.getOptions()) {
                    jsonObject.addProperty(option.getValue(), option.getLabel());
                    String rowMappingLabel = this.buildRow(selection, option.getLabel(), option.getValue(), item, state, rowSB);
                    if (rowMappingLabel == null) continue;
                    mappingLabel = rowMappingLabel;
                }
            }
        } else {
            for (Mapping mapping : selection.getMappings()) {
                jsonObject.addProperty(mapping.getCmd(), mapping.getLabel());
                String rowMappingLabel = this.buildRow(selection, mapping.getLabel(), mapping.getCmd(), item, state, rowSB);
                if (rowMappingLabel == null) continue;
                mappingLabel = rowMappingLabel;
            }
        }
        snippet = StringUtils.replace((String)snippet, (String)"%rows%", (String)rowSB.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%value_map%", (String)StringEscapeUtils.escapeHtml((String)jsonObject.toString()));
        snippet = StringUtils.replace((String)snippet, (String)"%label_header%", (String)this.getLabel(w));
        snippet = StringUtils.replace((String)snippet, (String)"%value_header%", (String)(mappingLabel != null ? mappingLabel : ""));
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }

    private String buildRow(Selection w, String lab, String cmd, Item item, State state, StringBuilder rowSB) throws RenderException {
        String mappingLabel = null;
        String rowSnippet = this.getSnippet("selection_row");
        String command = cmd != null ? cmd : "";
        String label = lab;
        if (item instanceof NumberItem && ((NumberItem)item).getDimension() != null) {
            String unit = this.getUnitForWidget((Widget)w);
            command = StringUtils.replace((String)command, (String)"%unit%", (String)unit);
            label = StringUtils.replace((String)label, (String)"%unit%", (String)unit);
        }
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%item%", (String)(w.getItem() != null ? w.getItem() : ""));
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%cmd%", (String)this.escapeHtml(command));
        rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%label%", (String)(label != null ? this.escapeHtml(label) : ""));
        State compareMappingState = state;
        if (state instanceof QuantityType) {
            compareMappingState = this.convertStateToLabelUnit((QuantityType)state, command);
        }
        if (compareMappingState.toString().equals(command)) {
            mappingLabel = label;
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"checked=\"true\"");
        } else {
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"");
        }
        rowSB.append(rowSnippet);
        return mappingLabel;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

