/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal.render;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.basic.internal.WebAppActivator;
import org.openhab.ui.basic.internal.WebAppConfig;
import org.openhab.ui.basic.render.RenderException;
import org.openhab.ui.basic.render.WidgetRenderer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWidgetRenderer
implements WidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(AbstractWidgetRenderer.class);
    public static final String ICON_TYPE = "svg";
    protected ItemUIRegistry itemUIRegistry;
    protected TranslationProvider i18nProvider;
    protected LocaleProvider localeProvider;
    protected WebAppConfig config;
    private BundleContext bundleContext;
    protected static final String SNIPPET_EXT = ".html";
    protected static final String SNIPPET_LOCATION = "snippets/";
    protected static final Map<String, String> SNIPPET_CACHE = new HashMap<String, String>();

    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    protected void activate(BundleContext context) {
        this.bundleContext = context;
    }

    protected void deactivate(BundleContext context) {
        this.bundleContext = null;
    }

    protected String preprocessSnippet(String originalSnippet, Widget w) {
        String snippet = originalSnippet;
        snippet = StringUtils.replace((String)snippet, (String)"%widget_id%", (String)this.itemUIRegistry.getWidgetId(w));
        snippet = StringUtils.replace((String)snippet, (String)"%icon_type%", (String)ICON_TYPE);
        snippet = StringUtils.replace((String)snippet, (String)"%item%", (String)(w.getItem() != null ? w.getItem() : ""));
        String text = this.itemUIRegistry.getLabel(w);
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)this.getLabel(text));
        snippet = StringUtils.replace((String)snippet, (String)"%value%", (String)this.getValue(text));
        snippet = StringUtils.replace((String)snippet, (String)"%has_value%", (String)new Boolean(this.hasValue(text)).toString());
        snippet = StringUtils.replace((String)snippet, (String)"%visibility_class%", (String)(this.itemUIRegistry.getVisiblity(w) ? "" : "mdl-form__row--hidden"));
        String state = this.getState(w);
        snippet = StringUtils.replace((String)snippet, (String)"%state%", (String)(state == null ? "" : this.escapeURL(state)));
        String category = this.getCategory(w);
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.escapeURL(category));
        return snippet;
    }

    protected synchronized String getSnippet(String elementType) throws RenderException {
        String lowerTypeElementType = elementType.toLowerCase();
        String snippet = SNIPPET_CACHE.get(lowerTypeElementType);
        if (snippet == null) {
            String snippetLocation = SNIPPET_LOCATION + lowerTypeElementType + SNIPPET_EXT;
            URL entry = WebAppActivator.getContext().getBundle().getEntry(snippetLocation);
            if (entry != null) {
                try {
                    snippet = IOUtils.toString((InputStream)entry.openStream());
                    SNIPPET_CACHE.put(lowerTypeElementType, snippet);
                }
                catch (IOException e) {
                    this.logger.warn("Cannot load snippet for element type '{}'", (Object)lowerTypeElementType, (Object)e);
                }
            } else {
                throw new RenderException("Cannot find a snippet for element type '" + lowerTypeElementType + "'");
            }
        }
        return snippet;
    }

    public String getLabel(Widget w) {
        return this.getLabel(this.itemUIRegistry.getLabel(w));
    }

    protected String getLabel(String text) {
        int index = text.indexOf(91);
        if (index != -1) {
            return this.escapeHtml(text.substring(0, index));
        }
        return this.escapeHtml(text);
    }

    public String getValue(Widget w) {
        return this.getValue(this.itemUIRegistry.getLabel(w));
    }

    protected String getValue(String text) {
        int index = text.indexOf(91);
        if (index != -1) {
            return this.escapeHtml(text.substring(index + 1, text.length() - 1));
        }
        return "";
    }

    public boolean hasValue(Widget w) {
        return this.hasValue(this.itemUIRegistry.getLabel(w));
    }

    protected boolean hasValue(String text) {
        return text.indexOf(91) != -1;
    }

    protected String escapeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            this.logger.warn("Cannot escape string '{}'. Returning unmodified string.", (Object)string);
            return string;
        }
    }

    protected String processColor(Widget w, String originalSnippet) {
        String style = "";
        String color = "";
        String snippet = originalSnippet;
        color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "style=\"color:" + color + "\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "style=\"color:" + color + "\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valuestyle%", (String)style);
        return snippet;
    }

    protected String getCategory(Widget w) {
        return this.itemUIRegistry.getCategory(w);
    }

    protected String getState(Widget w) {
        State state = this.itemUIRegistry.getState(w);
        if (state != null) {
            return state.toString();
        }
        return "NULL";
    }

    protected String escapeHtml(String s) {
        return StringEscapeUtils.escapeHtml((String)s);
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
    }

    protected String localizeText(String key) {
        String result = "";
        if (I18nUtil.isConstant((String)key)) {
            result = this.i18nProvider.getText(this.bundleContext.getBundle(), I18nUtil.stripConstant((String)key), "", this.localeProvider.getLocale());
        }
        return result;
    }

    protected String getUnitForWidget(Widget widget) {
        return this.itemUIRegistry.getUnitForWidget(widget);
    }

    protected State convertStateToLabelUnit(QuantityType<?> state, String label) {
        return this.itemUIRegistry.convertStateToLabelUnit(state, label);
    }

    protected boolean isValidURL(String url) {
        if (url != null && !url.isEmpty()) {
            try {
                return new URL(url).toURI() != null;
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return false;
    }
}

