/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.jface;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;

public abstract class AbstractDialog
extends Dialog {
    protected Object dataContext;
    protected String title;

    public AbstractDialog(Shell parentShell, String title, Object dataContext) {
        super(parentShell);
        this.dataContext = dataContext;
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            HashMap<String, Object> newOptions = new HashMap<String, Object>();
            this.initOptions(parent, newOptions);
            Object element = XWT.loadWithOptions(this.getContentURL(), newOptions);
            if (!(element instanceof Control)) {
                throw new XWTException("Root element must a control.");
            }
            GridLayoutFactory.fillDefaults().generateLayout(parent);
            parent.layout(true, true);
            Control control = (Control)element;
            return control;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            parent.setVisible(true);
        }
        return null;
    }

    protected void initOptions(Composite parent, HashMap<String, Object> newOptions) {
        newOptions.put("XWT.Container", parent);
        newOptions.put("XWT.DataContext", this.dataContext);
        newOptions.put("XWT.Class", this.geCLR());
    }

    protected abstract URL getContentURL();

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected Object geCLR() {
        return this;
    }
}

