/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ReusableDialog;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.FontRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.AbstractFontPage;
import org.eclipse.wb.internal.swt.model.property.editor.font.ConstructionFontPage;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontPreviewCanvas;
import org.eclipse.wb.internal.swt.model.property.editor.font.RegistryFontPage;
import org.eclipse.wb.internal.swt.support.JFaceSupport;

public final class FontDialog
extends ReusableDialog {
    private final JavaInfo m_javaInfo;
    private FontInfo m_fontInfo;
    private FontPreviewCanvas m_previewCanvas;
    private TabFolder m_tabFolder;
    private final List<AbstractFontPage> m_pages = Lists.newArrayList();

    public FontDialog(Shell parentShell, JavaInfo javaInfo) {
        super(parentShell);
        this.m_javaInfo = javaInfo;
    }

    public void disposeFont() {
        if (this.m_fontInfo != null) {
            this.m_fontInfo.dispose();
            this.m_fontInfo = null;
        }
    }

    public FontInfo getFontInfo() {
        return this.m_fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.disposeFont();
        this.m_fontInfo = fontInfo;
        this.updateGUI();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Group previewGroup = new Group(area, 0);
        GridDataFactory.create((Control)previewGroup).grabH().fillH();
        GridLayoutFactory.create((Composite)previewGroup);
        previewGroup.setText(ModelMessages.FontDialog_previewGroup);
        this.m_previewCanvas = new FontPreviewCanvas((Composite)previewGroup, 0);
        GridDataFactory.create((Control)this.m_previewCanvas).grab().fill();
        this.m_tabFolder = new TabFolder(area, 0);
        GridDataFactory.create((Control)this.m_tabFolder).grab().fill();
        this.addPages((Composite)this.m_tabFolder);
        this.setPageSelection();
        return area;
    }

    protected void onBeforeOpen() {
        this.updateGUI();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.FontDialog_dialogTitle);
    }

    private void updateGUI() {
        if (this.getShell() != null) {
            this.m_previewCanvas.setFontInfo(this.m_javaInfo, this.m_fontInfo);
            for (AbstractFontPage page : this.m_pages) {
                page.setFont(this.m_fontInfo);
            }
        }
    }

    protected final void addPage(String title, AbstractFontPage page) {
        this.m_pages.add(page);
        TabItem tabItem = new TabItem(this.m_tabFolder, 0);
        tabItem.setText(title);
        tabItem.setControl((Control)page);
    }

    protected void addPages(Composite parent) {
        this.addPage(ModelMessages.FontDialog_constructorPage, new ConstructionFontPage(this.m_javaInfo, parent, 0, this));
        if (JFaceSupport.isAvialable()) {
            try {
                List<FontRegistryInfo> registries = RegistryContainerInfo.getRegistries(this.m_javaInfo.getRootJava(), FontRegistryInfo.class);
                if (!registries.isEmpty()) {
                    this.addPage("FontRegistry", new RegistryFontPage(parent, 0, this, registries));
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
    }

    private void setPageSelection() {
        String pageId = this.m_fontInfo.getPageId();
        if (pageId != null) {
            int size = this.m_tabFolder.getItemCount();
            int i = 0;
            while (i < size) {
                TabItem item = this.m_tabFolder.getItem(i);
                if (pageId.equals(item.getText())) {
                    this.m_tabFolder.setSelection(new TabItem[]{item});
                    break;
                }
                ++i;
            }
        }
    }

    public final void closeOk() {
        this.buttonPressed(0);
    }
}

