/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.assistant;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ShellLocationTracker {
    private final IDialogSettings m_settings;
    private final String m_sectionName;
    private Shell m_shell;

    public ShellLocationTracker(IDialogSettings settings, String sectionName) {
        this.m_settings = settings;
        this.m_sectionName = sectionName;
    }

    public void setShell(Shell shell) {
        this.m_shell = shell;
        this.m_shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!ShellLocationTracker.this.m_shell.isDisposed() && !ShellLocationTracker.this.m_shell.getMaximized()) {
                    Point location = ShellLocationTracker.this.m_shell.getLocation();
                    ShellLocationTracker.this.saveLocation(location);
                }
            }
        });
    }

    public Point getInitialLocation(Point initialSize) {
        Point location = this.loadLocation();
        if (location != null) {
            return location;
        }
        Rectangle parentBounds = this.getParentShell().getBounds();
        int x = parentBounds.x + (parentBounds.width - initialSize.x) / 2;
        int y = parentBounds.y + (parentBounds.height - initialSize.y) / 2;
        return new Point(x, y);
    }

    private Shell getParentShell() {
        Shell parent = (Shell)this.m_shell.getParent();
        if (parent != null) {
            return parent;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private Point loadLocation() {
        IDialogSettings settings = this.getLocationSettings();
        try {
            return new Point(settings.getInt("x"), settings.getInt("y"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void saveLocation(Point location) {
        IDialogSettings settings = this.getLocationSettings();
        settings.put("x", location.x);
        settings.put("y", location.y);
    }

    private IDialogSettings getLocationSettings() {
        if (this.m_settings.getSection(this.m_sectionName) == null) {
            return this.m_settings.addNewSection(this.m_sectionName);
        }
        return this.m_settings.getSection(this.m_sectionName);
    }
}

