/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.settings.PathPatternMatcher;
import org.eclipse.lemminx.settings.XMLSymbolExpressionFilter;
import org.eclipse.lemminx.xpath.matcher.IXPathNodeMatcher;

public class XMLSymbolFilter
extends PathPatternMatcher {
    public static final XMLSymbolFilter DEFAULT = new XMLSymbolFilter();
    private XMLSymbolExpressionFilter[] expressions;

    public void setExpressions(XMLSymbolExpressionFilter[] expressions) {
        this.expressions = expressions;
    }

    public XMLSymbolExpressionFilter[] getExpressions() {
        return this.expressions;
    }

    public XMLSymbolExpressionFilter getFilterForInlineAttr(DOMAttr attrNode) {
        if (this.expressions != null && this.expressions.length > 0) {
            for (XMLSymbolExpressionFilter expression : this.expressions) {
                if (!expression.match(attrNode) || !expression.isInlineAttribute()) continue;
                return expression;
            }
        }
        return null;
    }

    public boolean isNodeSymbol(DOMNode node) {
        if (node == null) {
            return false;
        }
        if (this.expressions != null && this.expressions.length > 0) {
            for (XMLSymbolExpressionFilter expression : this.expressions) {
                if (!expression.match(node)) continue;
                return !expression.isExcluded();
            }
        }
        return node.isElement() || node.isDoctype() || node.isProcessingInstruction() || node.isProlog() || node.isDTDElementDecl() || node.isDTDAttListDecl() || node.isDTDEntityDecl() || node.isDTDNotationDecl();
    }

    public boolean hasFilterFor(IXPathNodeMatcher.MatcherType matcherType) {
        if (this.expressions == null) {
            return false;
        }
        for (XMLSymbolExpressionFilter expression : this.expressions) {
            if (!expression.isFilterFor(matcherType)) continue;
            return true;
        }
        return false;
    }
}

