/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.eclipse.wtp.releng.wtpbuilder.Build;
import org.eclipse.wtp.releng.wtpbuilder.IBuildConstants;

public abstract class AbstractBuilder
implements IBuildConstants {
    private static final String URL_BUILD_PUBLIC = "http://www.eclipse.org/external/webtools/downloads/";
    private static final String URL_BUILD_COMMITTER = "http://www.eclipse.org/external/webtools/committers/";
    protected static final String DEFAULT_COMPLETED_BUILDS_FILE = "completed_builds.properties";
    private Properties completedBuilds;
    private String completedBuildsFilename;
    private Build latestBuild;
    protected String baseos;
    protected String basews;
    protected String basearch;
    protected String login;
    private long minTS;

    public AbstractBuilder() {
        this(DEFAULT_COMPLETED_BUILDS_FILE);
    }

    public AbstractBuilder(String completedBuildsFile) {
        this.completedBuildsFilename = completedBuildsFile;
        try {
            File file = new File(this.completedBuildsFilename);
            file.createNewFile();
            this.completedBuilds = new Properties();
            this.completedBuilds.load(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public abstract boolean build(Build var1);

    public void setMinTS(long minTS) {
        this.minTS = minTS;
    }

    public void setBasearch(String basearch) {
        this.basearch = basearch;
    }

    public void setBaseos(String baseos) {
        this.baseos = baseos;
    }

    public void setBasews(String basews) {
        this.basews = basews;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String build() {
        this.latestBuild = null;
        this.build2(URL_BUILD_PUBLIC, true);
        if (this.latestBuild == null && this.acceptCommitterBuilds()) {
            this.build2(URL_BUILD_COMMITTER, false);
        }
        if (this.latestBuild != null && this.build(this.latestBuild)) {
            this.update(this.latestBuild);
            return this.latestBuild.toString();
        }
        return null;
    }

    protected boolean acceptCommitterBuilds() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void build2(String buildURL, boolean publicBuild) {
        BufferedReader br;
        block19: {
            InputStream is = null;
            br = null;
            try {
                try {
                    URL url = new URL(buildURL);
                    is = url.openConnection().getInputStream();
                    br = new BufferedReader(new InputStreamReader(is));
                    String s = br.readLine();
                    block12: while (s != null) {
                        String start = "href=\"drops/";
                        String end = "/";
                        int startIndex = s.indexOf(start);
                        int streamIndex = s.indexOf(end, startIndex + start.length());
                        int endIndex = s.indexOf(end, streamIndex + end.length());
                        while (true) {
                            String[] buildFragments;
                            if (startIndex == -1 || streamIndex == -1 || endIndex == -1) {
                                s = br.readLine();
                                continue block12;
                            }
                            String stream = s.substring(startIndex + start.length(), streamIndex);
                            String buildLabel = s.substring(streamIndex + end.length(), endIndex);
                            if (buildLabel.length() > 0 && !this.completedBuilds.containsKey(buildLabel) && (buildFragments = buildLabel.split("-")).length > 2 && buildFragments[0].length() == 1 && buildFragments[2].length() > 11 && Long.parseLong(buildFragments[2]) >= this.minTS) {
                                Build build = new Build(publicBuild, buildFragments[0], buildFragments[1], buildFragments[2].substring(0, 8), buildFragments[2].substring(8), stream);
                                if (this.latestBuild == null || !this.latestBuild.isNewer(build)) {
                                    this.latestBuild = build;
                                }
                            }
                            startIndex = s.indexOf(start, endIndex + end.length());
                            streamIndex = s.indexOf(end, startIndex + start.length());
                            endIndex = s.indexOf(end, streamIndex + end.length());
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage());
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException(nfe.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var16_20 = null;
                if (is == null) break block19;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (br == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        br.close();
    }

    public void update(Build build) {
        if (build.isPublicBuild()) {
            this.completedBuilds.put(build.toString(), "public");
        } else {
            this.completedBuilds.put(build.toString(), "committer");
        }
        try {
            this.completedBuilds.store(new FileOutputStream(this.completedBuildsFilename), "");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    protected void main() {
        if (this.baseos != null) {
            System.setProperty("baseos", this.baseos);
        }
        if (this.basews != null) {
            System.setProperty("basews", this.basews);
        }
        if (this.basearch != null) {
            System.setProperty("basearch", this.basearch);
        }
        if (this.login != null) {
            System.setProperty("login", this.login);
        }
        System.setProperty("clean", Boolean.TRUE.toString());
        try {
            this.build();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

