/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.Messages;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathView;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathComputer {
    private static final int UPDATE_DELAY = 500;
    private static final byte[] XPATH_LOCK = new byte[0];
    private XPathView xpathView;
    private IModelStateListener modelStateListener = new IModelStateListener(){

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelChanged(IStructuredModel model) {
            XPathComputer.this.updateXPath();
            XPathComputer.this.compute();
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }
    };
    private Node node;
    private IStructuredModel model;
    private String expression;
    private String text;
    private NodeList nodeList;

    public XPathComputer(XPathView xpathView) {
        this.xpathView = xpathView;
    }

    public void setModel(IStructuredModel model) {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
        }
        this.model = model;
        if (model != null) {
            model.addModelStateListener(this.modelStateListener);
            this.updateXPath();
        } else {
            this.node = null;
        }
    }

    private void updateXPath() {
        Document doc = (Document)this.model.getAdapter(Document.class);
        if (doc == null) {
            return;
        }
        try {
            this.updateExpression();
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpression() throws XPathExpressionException {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            if (this.text != null) {
                XSLTXPathHelper.compile((String)this.text);
                this.expression = this.text;
            } else {
                this.expression = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setText(String text) throws XPathExpressionException {
        this.text = text;
        this.updateExpression();
    }

    public void setSelectedNode(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        final String[] xps = new String[1];
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            xps[0] = this.expression;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Job refresh = new Job(Messages.XPathComputer_5){

                protected IStatus run(IProgressMonitor monitor) {
                    if (xps[0] != XPathComputer.this.expression) {
                        return Status.CANCEL_STATUS;
                    }
                    return XPathComputer.this.doCompute(xps[0]);
                }
            };
            refresh.setSystem(true);
            refresh.setPriority(20);
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.xpathView.getSite().getService(IWorkbenchSiteProgressService.class);
            service.schedule(refresh, 500L);
            return;
        }
    }

    private IStatus doCompute(String xp) {
        IStatus status = this.executeXPath(xp);
        this.xpathView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XPathComputer.this.xpathView.xpathRecomputed(XPathComputer.this.nodeList);
            }
        });
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus executeXPath(String xp) {
        try {
            if (xp == null || this.node == null) return Status.OK_STATUS;
            byte[] byArray = XPATH_LOCK;
            synchronized (XPATH_LOCK) {
                this.nodeList = XSLTXPathHelper.selectNodeList((Node)this.node, (String)xp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
        catch (TransformerException transformerException) {
            return Status.CANCEL_STATUS;
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
            this.model = null;
        }
    }
}

