/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class XMLValidatorPreferencePage
extends AbstractPreferencePage {
    private Combo fIndicateNoGrammar;
    private Button fHonourAllSchemaLocations;
    private Button fUseXinclude;

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0064");
        this.createContentsForValidatingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForValidatingGroup(Composite parent) {
        Group validatingGroup = this.createGroup(parent, 2);
        ((GridLayout)validatingGroup.getLayout()).makeColumnsEqualWidth = false;
        validatingGroup.setText(XMLUIMessages.Validating_files);
        if (this.fIndicateNoGrammar == null) {
            this.createLabel((Composite)validatingGroup, XMLUIMessages.Indicate_no_grammar_specified);
            this.fIndicateNoGrammar = this.createCombo((Composite)validatingGroup, StringUtils.unpack((String)XMLUIMessages.Indicate_no_grammar_specified_severities));
        }
        if (this.fUseXinclude == null) {
            this.fUseXinclude = this.createCheckBox((Composite)validatingGroup, XMLUIMessages.Use_XInclude);
            ((GridData)this.fUseXinclude.getLayoutData()).horizontalSpan = 2;
        }
        if (this.fHonourAllSchemaLocations == null) {
            this.fHonourAllSchemaLocations = this.createCheckBox((Composite)validatingGroup, XMLUIMessages.Honour_all_schema_locations);
            ((GridData)this.fHonourAllSchemaLocations.getLayoutData()).horizontalSpan = 2;
        }
    }

    private Combo createCombo(Composite parent, String[] items) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(items);
        GridData data = new GridData(4, 0x1000000, true, true);
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected void initializeValues() {
        this.initializeValuesForValidatingGroup();
    }

    protected void initializeValuesForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        int indicateNoGrammarButtonSelected = modelPreferences.getInt("indicateNoGrammar");
        boolean useXIncludeButtonSelected = modelPreferences.getBoolean("xinclude");
        if (this.fIndicateNoGrammar != null) {
            this.fIndicateNoGrammar.select(2 - indicateNoGrammarButtonSelected);
            this.fIndicateNoGrammar.setText(StringUtils.unpack((String)XMLUIMessages.Indicate_no_grammar_specified_severities)[2 - indicateNoGrammarButtonSelected]);
        }
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(useXIncludeButtonSelected);
        }
        boolean honourAllSelected = modelPreferences.getBoolean("honourAllSchemaLocations");
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(honourAllSelected);
        }
    }

    protected void performDefaultsForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        int indicateNoGrammarButtonSelected = modelPreferences.getDefaultInt("indicateNoGrammar");
        boolean useXIncludeButtonSelected = modelPreferences.getDefaultBoolean("xinclude");
        if (this.fIndicateNoGrammar != null) {
            this.fIndicateNoGrammar.setSelection(new Point(indicateNoGrammarButtonSelected, 2 - indicateNoGrammarButtonSelected));
            this.fIndicateNoGrammar.setText(StringUtils.unpack((String)XMLUIMessages.Indicate_no_grammar_specified_severities)[indicateNoGrammarButtonSelected]);
        }
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(useXIncludeButtonSelected);
        }
        boolean honourAllButtonSelected = modelPreferences.getDefaultBoolean("honourAllSchemaLocations");
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(honourAllButtonSelected);
        }
    }

    protected void storeValuesForValidatingGroup() {
        Preferences modelPreferences = this.getModelPreferences();
        if (this.fIndicateNoGrammar != null) {
            int warnNoGrammarButtonSelected = 2 - this.fIndicateNoGrammar.getSelectionIndex();
            modelPreferences.setValue("indicateNoGrammar", warnNoGrammarButtonSelected);
        }
        if (this.fUseXinclude != null) {
            boolean useXIncludeButtonSelected = this.fUseXinclude.getSelection();
            modelPreferences.setValue("xinclude", useXIncludeButtonSelected);
        }
        if (this.fHonourAllSchemaLocations != null) {
            boolean honourAllButtonSelected = this.fHonourAllSchemaLocations.getSelection();
            modelPreferences.setValue("honourAllSchemaLocations", honourAllButtonSelected);
        }
    }

    protected void storeValues() {
        this.storeValuesForValidatingGroup();
    }

    protected void performDefaults() {
        this.performDefaultsForValidatingGroup();
        super.performDefaults();
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void doSavePreferenceStore() {
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

