/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.wst.server.discovery.internal.PatternInstallableUnitQuery;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUpdateSite {
    private static final List<String> EMPTY_LIST = new ArrayList<String>(0);
    private String url;
    private String featureId;
    private String homepage;
    private String supportUrl;
    private List<String> categories;

    public ExtensionUpdateSite() {
    }

    public ExtensionUpdateSite(String url, String featureId, List<String> categories) {
        this.url = url;
        this.featureId = featureId;
        this.categories = categories;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            return EMPTY_LIST;
        }
        return this.categories;
    }

    public List<Extension> getExtensions(IProgressMonitor monitor) throws CoreException {
        try {
            UpdateSiteMetadataRepositoryFactory mrf = new UpdateSiteMetadataRepositoryFactory();
            URI url2 = new URI(this.url);
            IMetadataRepository repo = mrf.load(url2, 0, monitor);
            PatternInstallableUnitQuery query = new PatternInstallableUnitQuery("org.eclipse.wst.server.core.serverAdapter");
            Collector collector = new Collector();
            repo.query((Query)query, collector, monitor);
            ArrayList<Extension> list = new ArrayList<Extension>();
            for (IInstallableUnit iu : collector) {
                IRequiredCapability[] req = iu.getRequiredCapabilities();
                if (req == null) continue;
                IRequiredCapability[] iRequiredCapabilityArray = req;
                int n = req.length;
                int n2 = 0;
                while (n2 < n) {
                    IRequiredCapability rc = iRequiredCapabilityArray[n2];
                    query = new InstallableUnitQuery(rc.getName(), rc.getRange());
                    Collector collector2 = new Collector();
                    repo.query((Query)query, collector2, monitor);
                    for (IInstallableUnit iu2 : collector2) {
                        if (list.contains(iu2)) continue;
                        Extension ext = new Extension(iu2, url2);
                        list.add(ext);
                    }
                    ++n2;
                }
            }
            return list;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting update info", e);
            return new ArrayList<Extension>(0);
        }
    }
}

