/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIPlugin;

public class SetupProjectsWizzard
implements IObjectActionDelegate,
IActionDelegate {
    IWorkbenchPart fPart;
    Object[] fTarget;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void doInstall(IProject project, boolean openProperties, IProgressMonitor monitor) {
        boolean configured = false;
        JsWebNature nature = new JsWebNature(project, monitor);
        try {
            boolean hadBasicNature = JsWebNature.hasNature((IProject)project);
            nature.configure();
            if (!hadBasicNature) {
                IJavaScriptProject jp = JavaScriptCore.create((IProject)project);
                IIncludePathEntry[] oldEntries = null;
                try {
                    oldEntries = jp.getRawIncludepath();
                }
                catch (JavaScriptModelException ex1) {
                    Logger.log((int)204, null, (Throwable)ex1);
                }
                IIncludePathEntry[] newEntries = new IIncludePathEntry[oldEntries.length + 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
                IPath projectPath = project.getFullPath();
                newEntries[oldEntries.length] = JavaScriptCore.newSourceEntry((IPath)projectPath);
                jp.setRawIncludepath(newEntries, monitor);
            }
            configured = true;
        }
        catch (CoreException ex) {
            Logger.logException((Throwable)ex);
        }
        if (configured && openProperties) {
            this.showPropertiesOn(project);
        }
    }

    private void install(final IProject project, final boolean openProperties) {
        IProgressService service = null;
        if (this.fPart != null) {
            IWorkbenchPartSite iWorkbenchPartSite = this.fPart.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            service = (IProgressService)iWorkbenchPartSite.getService((Class)clazz);
        }
        if (service == null) {
            this.doInstall(project, openProperties, null);
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SetupProjectsWizzard.this.doInstall(project, openProperties, monitor);
                }
            };
            try {
                service.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.logException((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    public void run(IAction action) {
        if (this.fTarget == null) {
            return;
        }
        int i = 0;
        while (i < this.fTarget.length) {
            if (this.fTarget[i] instanceof IResource) {
                IProject project = ((IResource)this.fTarget[i]).getProject();
                if (!JsWebNature.hasNature((IProject)project)) {
                    this.install(project, i == this.fTarget.length - 1);
                } else {
                    IJavaScriptProject jp = JavaScriptCore.create((IProject)project);
                    IIncludePathEntry[] rawClasspath = null;
                    try {
                        rawClasspath = jp.getRawIncludepath();
                    }
                    catch (JavaScriptModelException ex1) {
                        Logger.log((int)204, null, (Throwable)ex1);
                    }
                    boolean browserFound = false;
                    int k = 0;
                    while (rawClasspath != null && !browserFound && k < rawClasspath.length) {
                        if (rawClasspath[k].getPath().equals((Object)JsWebNature.VIRTUAL_BROWSER_CLASSPATH)) {
                            browserFound = true;
                        }
                        ++k;
                    }
                    if (!browserFound) {
                        this.install(project, false);
                    }
                }
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fTarget = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    private void showPropertiesOn(final IProject project) {
        Shell finalShell;
        IWorkbenchWindow activeWorkbenchWindow;
        Shell shell;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        final ArrayList<String> pageIds = new ArrayList<String>(8);
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespaceIdentifier().startsWith("org.eclipse.wst.jsdt.")) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    if ("page".equals(configurationElements[j].getName())) {
                        pageIds.add(configurationElements[j].getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((shell = (Shell)this.fPart.getAdapter((Class)clazz)) == null && (activeWorkbenchWindow = JsUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = activeWorkbenchWindow.getShell();
        }
        if ((finalShell = shell) != null) {
            finalShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PreferencesUtil.createPropertyDialogOn((Shell)finalShell, (IAdaptable)project, (String)"org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", (String[])pageIds.toArray(new String[pageIds.size()]), null).open();
                }
            });
        }
    }
}

