/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.internal.environment.eclipse.FileResourceOutputStream;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;

public final class FileResourceUtils {
    private static IWorkspace workspace_ = null;
    private static IWorkspaceRoot root_ = null;

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static Choice[] getThreeStateFileOptions() {
        Vector<Choice> choices = new Vector<Choice>();
        choices.add(new Choice('Y', Messages.LABEL_YES));
        choices.add(new Choice('A', Messages.LABEL_YES_TO_ALL));
        choices.add(new Choice('C', Messages.LABEL_CANCEL));
        return choices.toArray(new Choice[choices.size()]);
    }

    public static IResource findResource(String absolutePathname) {
        if (absolutePathname == null) {
            return null;
        }
        return FileResourceUtils.findResource((IPath)new Path(absolutePathname));
    }

    public static IResource findResource(IPath absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        return FileResourceUtils.getWorkspaceRoot().findMember(absolutePath);
    }

    public static void copyFile(Plugin plugin, IPath sourcePath, IPath pathname, IPath targetPath, IStatusHandler statusMonitor) throws CoreException {
        try {
            IPath target = targetPath.append(pathname);
            IPath source = sourcePath == null ? pathname : sourcePath.append(pathname);
            InputStream input = plugin.openStream(source);
            FileResourceUtils.createFile(target, input, statusMonitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, Messages.MSG_ERROR_IO, (Throwable)e));
        }
    }

    public static boolean deleteFile(IFile file, IStatusHandler statusMonitor) throws CoreException {
        if (file.exists()) {
            if (file.isReadOnly()) {
                IFile[] files = new IFile[]{file};
                IStatus status = FileResourceUtils.getWorkspace().validateEdit(files, null);
                if (status.getSeverity() == 4) {
                    statusMonitor.reportError(status);
                    return false;
                }
            }
            file.delete(true, null);
        }
        return true;
    }

    public static boolean deleteFolder(IFolder folder, IStatusHandler statusMonitor) throws CoreException {
        if (!folder.exists()) {
            return true;
        }
        boolean deleted = true;
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile) {
                deleted = FileResourceUtils.deleteFile((IFile)resource, statusMonitor);
            }
            if (resource instanceof IFolder) {
                deleted = FileResourceUtils.deleteFolder((IFolder)resource, statusMonitor);
            }
            if (!deleted) break;
            ++i;
        }
        if (deleted) {
            folder.delete(true, true, null);
            return true;
        }
        return false;
    }

    public static IFile createFile(IPath absolutePath, InputStream inputStream, IStatusHandler statusHandler) throws CoreException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)Messages.MSG_ERROR_PATH_NOT_ABSOLUTE, (Object)absolutePath.toString()), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)Messages.MSG_ERROR_PATH_EMPTY, (Object)absolutePath.toString()), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)Messages.MSG_ERROR_PATH_NOT_FOLDER, (Object)absolutePath.toString()), null));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(absolutePath.removeLastSegments(1), statusHandler);
        String fileName = absolutePath.lastSegment();
        return FileResourceUtils.makeFile(parent, fileName, inputStream, statusHandler);
    }

    public static IFile createFile(IProject project, IPath relativePath, InputStream inputStream, IStatusHandler statusMonitor) throws CoreException {
        IPath absolutePath = project.getFullPath().append(relativePath);
        return FileResourceUtils.createFile(absolutePath, inputStream, statusMonitor);
    }

    public static OutputStream newFileOutputStream(IPath file, IStatusHandler statusHandler) {
        return new FileResourceOutputStream(file, statusHandler);
    }

    public static IContainer makeFolderPath(IPath absolutePath, IStatusHandler statusHandler) throws CoreException {
        if (absolutePath.segmentCount() <= 1) {
            return FileResourceUtils.getWorkspaceRoot().getProject(absolutePath.segment(0));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(absolutePath.removeLastSegments(1), statusHandler);
        String folderName = absolutePath.lastSegment();
        return FileResourceUtils.makeFolder(parent, folderName, statusHandler);
    }

    private static IFolder makeFolder(IContainer parent, String folderName, IStatusHandler statusHandler) throws CoreException {
        IResource child = parent.findMember(folderName);
        if (child == null) {
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            folder.create(true, true, null);
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)Messages.MSG_ERROR_RESOURCE_NOT_FOLDER, (Object)parent.getFullPath().append(folderName).toString()), null));
    }

    /*
     * Unable to fully structure code
     */
    private static IFile makeFile(IContainer parent, String fileName, InputStream inputStream, IStatusHandler statusHandler) throws CoreException {
        block11: {
            file = parent.getFile((IPath)new Path(fileName));
            if (!file.exists()) {
                block10: {
                    try {
                        file.create(inputStream, true, null);
                        return file;
                    }
                    catch (CoreException coreException) {
                        if (coreException.getStatus().getCode() != 275) break block10;
                        foundIgnoringCase = false;
                        var10_9 = parent.members();
                        var9_10 = var10_9.length;
                        var8_11 = 0;
                        ** while (var8_11 < var9_10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        resource = var10_9[var8_11];
                        if (resource.getName().equalsIgnoreCase(fileName)) {
                            foundIgnoringCase = true;
                            fileName = resource.getName();
                            file = parent.getFile((IPath)new Path(fileName));
                            break;
                        }
                        ++var8_11;
                        continue;
                    }
lbl21:
                    // 2 sources

                    if (!foundIgnoringCase) {
                        throw coreException;
                    }
                    break block11;
                }
                throw coreException;
            }
        }
        if (file.getType() == 1) {
            if (file.getResourceAttributes().isReadOnly()) {
                files = new IFile[]{file};
                status = FileResourceUtils.getWorkspace().validateEdit(files, null);
                try {
                    statusHandler.report(status);
                }
                catch (StatusException v0) {
                    return null;
                }
            }
            file.setContents(inputStream, true, true, null);
            return file;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)Messages.MSG_ERROR_RESOURCE_NOT_FILE, (Object)parent.getFullPath().append(fileName)), null));
    }
}

