/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.elementedit.html;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.single.SelectEditPartAction;
import org.eclipse.jst.pagedesigner.commands.html.TableDeleteColumnCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableDeleteHeaderFooterCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableDeleteRowCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableInsertColumnCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableInsertHeaderFooterCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableInsertRowCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableResizeColumnCommand;
import org.eclipse.jst.pagedesigner.commands.html.TableResizeRowCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableChildElementPosition;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.elementedit.AbstractElementEdit;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.tableedit.DeleteHeaderFooterAction;
import org.eclipse.jst.pagedesigner.tableedit.DeleteHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.tableedit.DeleteRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.InsertHeaderFooterAction;
import org.eclipse.jst.pagedesigner.tableedit.InsertHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.tableedit.InsertRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.TableInsertRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableResizableEditPolicy;
import org.eclipse.jst.pagedesigner.tableedit.TableResizeRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableRowColumnDeleteRequest;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableElementEdit
extends AbstractElementEdit {
    private static final Action action = new Action(){};
    private static int FAKE_INDEX = -10;

    public void fillContextMenu(IMenuManager contextMenu, Element ele) {
        MenuManager tableMenu = new MenuManager(PDPlugin.getResourceString("ElementEdit.Submenu.Table"));
        tableMenu.add((IAction)action);
        ElementEditPart tablePart = (ElementEditPart)((IDOMElement)ele).getAdapterFor(EditPart.class);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, tablePart){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$tablePart;
            {
                this.val$tableMenu = iMenuManager;
                this.val$tablePart = elementEditPart;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                TableElementEdit.this.fillTableMenu(this.val$tablePart, FAKE_INDEX, FAKE_INDEX, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
    }

    public boolean fillContainerContextMenu(IMenuManager contextMenu, ElementEditPart tablePart, NodeEditPart nodePart, ISelection innerSelection) {
        super.fillContainerContextMenu(contextMenu, tablePart, nodePart, innerSelection);
        Element table = (Element)tablePart.getModel();
        Node node = (Node)nodePart.getModel();
        TableChildElementPosition position = new TableUtil(table).getPosition(node);
        int cellRow = position.getRowIndex();
        int cellColumn = position.getColumnIndex();
        MenuManager tableMenu = new MenuManager(PDPlugin.getResourceString("ElementEdit.Submenu.Table"));
        tableMenu.add((IAction)action);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, tablePart, cellRow, cellColumn){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$tablePart;
            private final /* synthetic */ int val$cellRow;
            private final /* synthetic */ int val$cellColumn;
            {
                this.val$tableMenu = iMenuManager;
                this.val$tablePart = elementEditPart;
                this.val$cellRow = n;
                this.val$cellColumn = n2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                TableElementEdit.this.fillTableMenu(this.val$tablePart, this.val$cellRow, this.val$cellColumn, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
        return true;
    }

    private void fillTableMenu(ElementEditPart tablePart, int cellRow, int cellColumn, IMenuManager tableMenu) {
        SelectEditPartAction action1 = SelectEditPartAction.create(PDPlugin.getResourceString("ElementEdit.Submenu.SelectTable"), (EditPart)tablePart);
        tableMenu.add((IAction)action1);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertRowBeforeAction = new InsertRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertRowBefore"), (EditPart)tablePart, cellRow, true, true);
        tableMenu.add((IAction)insertRowBeforeAction);
        InsertRowColumnAction insertRowAfterAction = new InsertRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertRowAfter"), (EditPart)tablePart, cellRow, true, false);
        tableMenu.add((IAction)insertRowAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertColumnBeforeAction = new InsertRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertColumnBefore"), (EditPart)tablePart, cellColumn, false, true);
        tableMenu.add((IAction)insertColumnBeforeAction);
        InsertRowColumnAction insertColumnAfterAction = new InsertRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertColumnAfter"), (EditPart)tablePart, cellColumn, false, false);
        tableMenu.add((IAction)insertColumnAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        DeleteRowColumnAction deleteRowAction = new DeleteRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.DeleteRow"), (EditPart)tablePart, cellRow, true);
        tableMenu.add((IAction)deleteRowAction);
        DeleteRowColumnAction deleteColumnAction = new DeleteRowColumnAction(PDPlugin.getResourceString("ElementEdit.Submenu.DeleteColumn"), (EditPart)tablePart, cellColumn, false);
        tableMenu.add((IAction)deleteColumnAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertHeaderFooterAction headerAction = new InsertHeaderFooterAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertHeader"), (EditPart)tablePart, true);
        tableMenu.add((IAction)headerAction);
        InsertHeaderFooterAction footerAction = new InsertHeaderFooterAction(PDPlugin.getResourceString("ElementEdit.Submenu.InsertFooter"), (EditPart)tablePart, false);
        tableMenu.add((IAction)footerAction);
        DeleteHeaderFooterAction delHeaderAction = new DeleteHeaderFooterAction(PDPlugin.getResourceString("ElementEdit.Submenu.DeleteHeader"), (EditPart)tablePart, true);
        tableMenu.add((IAction)delHeaderAction);
        DeleteHeaderFooterAction delFooterAction = new DeleteHeaderFooterAction(PDPlugin.getResourceString("ElementEdit.Submenu.DeleteFooter"), (EditPart)tablePart, false);
        tableMenu.add((IAction)delFooterAction);
    }

    public void createEditPolicies(ElementEditPart part) {
        part.installEditPolicy("Selection Feedback", (EditPolicy)new TableResizePolicy(part));
    }

    static class TableResizePolicy
    extends TableResizableEditPolicy {
        ElementEditPart _part;

        public TableResizePolicy(ElementEditPart part) {
            this._part = part;
        }

        public Command getCommand(Request request) {
            IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this._part.getViewer();
            Element table = (Element)this._part.getIDOMNode();
            if (request instanceof TableResizeRequest) {
                TableResizeRequest trq = (TableResizeRequest)request;
                if (trq.isRow()) {
                    return new TableResizeRowCommand(viewer, table, trq.getIndex(), trq.getDelta());
                }
                return new TableResizeColumnCommand(viewer, table, trq.getIndex(), trq.getDelta());
            }
            if (request instanceof TableInsertRequest) {
                TableInsertRequest tableInsertRequest = (TableInsertRequest)request;
                int index = tableInsertRequest.getIndex() + (tableInsertRequest.isBefore() ? 0 : 1);
                if (tableInsertRequest.isRow()) {
                    return new TableInsertRowCommand(viewer, table, index, tableInsertRequest.isBefore());
                }
                return new TableInsertColumnCommand(viewer, table, index);
            }
            if (request instanceof TableRowColumnDeleteRequest) {
                TableRowColumnDeleteRequest deleteReq = (TableRowColumnDeleteRequest)request;
                if (deleteReq.isRow()) {
                    return new TableDeleteRowCommand(viewer, table, deleteReq.getIndex());
                }
                return new TableDeleteColumnCommand(viewer, table, deleteReq.getIndex());
            }
            if (request instanceof InsertHeaderFooterRequest) {
                InsertHeaderFooterRequest hfRequest = (InsertHeaderFooterRequest)request;
                return new TableInsertHeaderFooterCommand(viewer, table, hfRequest.isHeader());
            }
            if (request instanceof DeleteHeaderFooterRequest) {
                DeleteHeaderFooterRequest hfRequest = (DeleteHeaderFooterRequest)request;
                return new TableDeleteHeaderFooterCommand(viewer, table, hfRequest.isHeader());
            }
            return super.getCommand(request);
        }
    }
}

