/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadManagedBeanTestCase
extends BaseReadTestCase {
    public ReadManagedBeanTestCase(String name) {
        super(name);
    }

    public void testManagedBean() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadManagedBeanTestCase.assertNotNull((Object)this.getManagedBean("managedBean1", edit.getFacesConfig()));
            ReadManagedBeanTestCase.assertNotNull((Object)this.getManagedBean("mapBean1", edit.getFacesConfig()));
            ReadManagedBeanTestCase.assertNotNull((Object)this.getManagedBean("listBean1", edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    ManagedBeanType getManagedBean(String name, FacesConfigType facesConfig) {
        return (ManagedBeanType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getManagedBean(), name);
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedBeanType managedBean1 = this.getManagedBean("managedBean1", edit.getFacesConfig());
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)managedBean1.getDescription(), "managedBean1Description");
            ReadManagedBeanTestCase.assertNotNull((Object)descType);
            ReadManagedBeanTestCase.assertEquals((String)"managed-bean-description", (String)descType.getTextContent());
            DisplayNameType displayName = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)managedBean1.getDisplayName(), "managedBean1DisplayName");
            ReadManagedBeanTestCase.assertNotNull((Object)displayName);
            ReadManagedBeanTestCase.assertEquals((String)"managed-bean-display-name", (String)displayName.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)managedBean1.getIcon(), "managedBean1Icon");
            ReadManagedBeanTestCase.assertNotNull((Object)iconType);
            ReadManagedBeanTestCase.assertEquals((String)"managedBean1-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"managedBean1-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSingleValuedProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedBeanType managedBean1 = this.getManagedBean("managedBean1", edit.getFacesConfig());
            ReadManagedBeanTestCase.assertEquals((String)"managedBeanName", (String)managedBean1.getManagedBeanName().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"managed-bean-class", (String)managedBean1.getManagedBeanClass().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"request", (String)managedBean1.getManagedBeanScope().getTextContent());
            ManagedBeanType mapBean1 = this.getManagedBean("mapBean1", edit.getFacesConfig());
            ReadManagedBeanTestCase.assertEquals((String)"mapBean1", (String)mapBean1.getManagedBeanName().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"mapBean1-class", (String)mapBean1.getManagedBeanClass().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"request", (String)mapBean1.getManagedBeanScope().getTextContent());
            ManagedBeanType listBean1 = this.getManagedBean("listBean1", edit.getFacesConfig());
            ReadManagedBeanTestCase.assertEquals((String)"listBean1", (String)listBean1.getManagedBeanName().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"listBean1-class", (String)listBean1.getManagedBeanClass().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"request", (String)listBean1.getManagedBeanScope().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testMapBeanProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedBeanType bean = this.getManagedBean("mapBean1", edit.getFacesConfig());
            ReadManagedBeanTestCase.assertNotNull((Object)bean);
            MapEntriesType mapEntries = bean.getMapEntries();
            ReadManagedBeanTestCase.assertEquals((String)"mapBeanEntryKey", (String)mapEntries.getKeyClass().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"mapBeanEntryValueClass", (String)mapEntries.getValueClass().getTextContent());
            MapEntryType mapEntry = (MapEntryType)FacesConfigModelUtil.findEObjectElementById((List)mapEntries.getMapEntry(), "mapBeanEntryWithValue");
            ReadManagedBeanTestCase.assertNotNull((Object)mapEntry);
            ReadManagedBeanTestCase.assertEquals((String)"mapBeanKey1", (String)mapEntry.getKey().getTextContent());
            ReadManagedBeanTestCase.assertEquals((String)"mapBeanValue1", (String)mapEntry.getValue().getTextContent());
            ReadManagedBeanTestCase.assertNull((Object)mapEntry.getNullValue());
            mapEntry = (MapEntryType)FacesConfigModelUtil.findEObjectElementById((List)mapEntries.getMapEntry(), "mapBeanEntryWithNullValue");
            ReadManagedBeanTestCase.assertNotNull((Object)mapEntry);
            ReadManagedBeanTestCase.assertEquals((String)"mapBeanKey2", (String)mapEntry.getKey().getTextContent());
            ReadManagedBeanTestCase.assertNotNull((Object)mapEntry.getNullValue());
            ReadManagedBeanTestCase.assertNull((Object)mapEntry.getValue());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testListBeanProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedBeanType bean = this.getManagedBean("listBean1", edit.getFacesConfig());
            ReadManagedBeanTestCase.assertNotNull((Object)bean);
            ListEntriesType listEntries = bean.getListEntries();
            ReadManagedBeanTestCase.assertEquals((String)"listBeanListPropertyClass", (String)listEntries.getValueClass().getTextContent());
            ReadManagedBeanTestCase.assertEquals((int)1, (int)listEntries.getValue().size());
            ReadManagedBeanTestCase.assertEquals((int)1, (int)listEntries.getNullValue().size());
            ValueType valueType = (ValueType)FacesConfigModelUtil.findEObjectElementById((List)listEntries.getValue(), "listBeanListProperty_value");
            ReadManagedBeanTestCase.assertNotNull((Object)valueType);
            ReadManagedBeanTestCase.assertEquals((String)"listBeanListPropertyValue", (String)valueType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

