/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.webapplication.WelcomeFile;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.model.internal.mergers.JNDIRefsMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class WebAppMerger
extends ModelElementMerger {
    public WebAppMerger(JavaEEObject _base, JavaEEObject merge, int kind) {
        super(_base, merge, kind);
    }

    WebApp getBaseWebApp() {
        return (WebApp)this.getBase();
    }

    WebApp getToMergeWebApp() {
        return (WebApp)this.getToMerge();
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        if (this.getToMergeWebApp() == null || this.getBaseWebApp() == null) {
            return warnings;
        }
        try {
            this.mergeServlets(warnings);
            this.mergeFilters(warnings);
            this.mergeListeners(warnings);
            this.copyGeneralData(warnings);
            this.mergeRunAs(warnings);
            this.mergeJNDIRefs(warnings);
            this.mergeSecurityRoles(warnings);
            this.mergeSecurityConstraints(warnings);
        }
        catch (Exception e) {
            throw new ModelException(e);
        }
        return warnings;
    }

    private void mergeFilters(List warnings) {
        if (this.getToMergeWebApp().getFilters() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getFilters(), this.getBaseWebApp().getFilters());
        }
        if (this.getToMergeWebApp().getFilterMappings() != null) {
            this.copyAllContentInBase(this.getToMergeWebApp().getFilterMappings(), this.getBaseWebApp().getFilterMappings());
        }
    }

    private void mergeListeners(List warnings) {
        if (this.getToMergeWebApp().getListeners() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getListeners(), this.getBaseWebApp().getListeners());
        }
    }

    private void mergeServlets(List warnings) {
        if (this.getToMergeWebApp().getServlets() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getServlets(), this.getBaseWebApp().getServlets());
        }
        if (this.getToMergeWebApp().getServletMappings() != null) {
            this.copyAllContentInBase(this.getToMergeWebApp().getServletMappings(), this.getBaseWebApp().getServletMappings());
        }
    }

    private void mergeJNDIRefs(List warnings) throws ModelException {
        JNDIRefsMerger jndiRefsMerger = new JNDIRefsMerger((JavaEEObject)this.getBaseWebApp(), (JavaEEObject)this.getToMergeWebApp(), this.getKind());
        warnings.addAll(jndiRefsMerger.process());
    }

    private void mergeRunAs(List warnings) throws ModelException {
        List baseServlets = this.getBaseWebApp().getServlets();
        List toMergeServlets = this.getToMergeWebApp().getServlets();
        for (Object object : toMergeServlets) {
            Servlet servlet = (Servlet)object;
            Servlet servletInBase = this.findServletInBase(servlet.getServletName(), baseServlets);
            if (servletInBase == null) continue;
            RunAs baseSecId = servletInBase.getRunAs();
            RunAs toMergeSecId = servlet.getRunAs();
            if (baseSecId != null || toMergeSecId == null) continue;
            servletInBase.setRunAs((RunAs)EcoreUtil.copy((EObject)((EObject)toMergeSecId)));
        }
    }

    private Servlet findServletInBase(String servletName, List baseServlets) {
        for (Object object : baseServlets) {
            Servlet servlet = (Servlet)object;
            if (servlet.getServletName() == null || !servlet.getServletName().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    private void mergeSecurityRoles(List warnings) {
        List securityRolesBase = this.getBaseWebApp().getSecurityRoles();
        List securityRolesToMerge = this.getToMergeWebApp().getSecurityRoles();
        if (securityRolesToMerge == null) {
            return;
        }
        for (Object sRoles : securityRolesToMerge) {
            if (this.containsSecRole((SecurityRole)sRoles, securityRolesBase)) continue;
            securityRolesBase.add(EcoreUtil.copy((EObject)((EObject)sRoles)));
        }
    }

    private void mergeSecurityConstraints(List warnings) {
        List securityConstraints = this.getBaseWebApp().getSecurityConstraints();
        List securityConstraintsToMerge = this.getToMergeWebApp().getSecurityConstraints();
        if (securityConstraintsToMerge == null) {
            return;
        }
        this.copyMissingContentInBase(securityConstraintsToMerge, securityConstraints);
    }

    private boolean containsSecRole(SecurityRole secRole, List secRoles) {
        for (Object sRoles : secRoles) {
            if (((SecurityRole)sRoles).getRoleName() == null || secRole.getRoleName() == null) {
                return ((SecurityRole)sRoles).getRoleName() == secRole.getRoleName();
            }
            if (!((SecurityRole)sRoles).getRoleName().equals(secRole.getRoleName())) continue;
            return true;
        }
        return false;
    }

    private void copyGeneralData(List warnings) {
        this.copyJavaEEGroup();
        if (this.getToMergeWebApp().getContextParams() != null && this.getToMergeWebApp().getContextParams().size() > 0) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getContextParams(), this.getBaseWebApp().getContextParams());
        }
        if (this.getToMergeWebApp().getDistributables() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getDistributables(), this.getBaseWebApp().getDistributables());
        }
        if (this.getToMergeWebApp().getErrorPages() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getErrorPages(), this.getBaseWebApp().getErrorPages());
        }
        if (this.getToMergeWebApp().getJspConfigs() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getJspConfigs(), this.getBaseWebApp().getJspConfigs());
        }
        if (this.getToMergeWebApp().getLocalEncodingMappingsLists() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getLocalEncodingMappingsLists(), this.getBaseWebApp().getLocalEncodingMappingsLists());
        }
        if (this.getToMergeWebApp().getLoginConfigs() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getLoginConfigs(), this.getBaseWebApp().getLoginConfigs());
        }
        if (this.getToMergeWebApp().getMessageDestinations() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getMessageDestinations(), this.getBaseWebApp().getMessageDestinations());
        }
        if (this.getToMergeWebApp().getMimeMappings() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getMimeMappings(), this.getBaseWebApp().getMimeMappings());
        }
        if (this.getToMergeWebApp().getSessionConfigs() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getSessionConfigs(), this.getBaseWebApp().getSessionConfigs());
        }
        if (this.getToMergeWebApp().getWelcomeFileLists() != null) {
            this.copyMissingContentInBase(this.getToMergeWebApp().getWelcomeFileLists(), this.getBaseWebApp().getWelcomeFileLists());
        }
    }

    private void copyAllContentInBase(List listSource, List target) {
        for (Object object : listSource) {
            if (!this.artifactIsValid(object)) continue;
            target.add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }

    private void copyMissingContentInBase(List listSource, List target) {
        for (Object object : listSource) {
            if (!this.artifactIsValid(object) || this.artifactExists(object, target)) continue;
            target.add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }

    private boolean artifactIsValid(Object javaEEObject) {
        if (javaEEObject instanceof Servlet) {
            return ((Servlet)javaEEObject).getServletName() != null;
        }
        if (javaEEObject instanceof Listener) {
            return ((Listener)javaEEObject).getListenerClass() != null;
        }
        if (javaEEObject instanceof Filter) {
            return ((Filter)javaEEObject).getFilterName() != null;
        }
        return true;
    }

    private boolean artifactExists(Object javaEEObject, List target) {
        for (Object targetArtifact : target) {
            if (!this.artifactIsValid(targetArtifact) || !(javaEEObject instanceof Servlet ? ((Servlet)targetArtifact).getServletName().equals(((Servlet)javaEEObject).getServletName()) : (javaEEObject instanceof Listener ? ((Listener)targetArtifact).getListenerClass().equals(((Listener)javaEEObject).getListenerClass()) : (javaEEObject instanceof Filter ? ((Filter)targetArtifact).getFilterName().equals(((Filter)javaEEObject).getFilterName()) : (javaEEObject instanceof Description ? ((Description)targetArtifact).getValue().equals(((Description)javaEEObject).getValue()) : javaEEObject instanceof WelcomeFile && ((WelcomeFile)targetArtifact).getWelcomeFile().equals(((WelcomeFile)javaEEObject).getWelcomeFile())))))) continue;
            return true;
        }
        return false;
    }

    private void copyJavaEEGroup() {
        if (this.getToMergeWebApp().getDescriptions() != null) {
            this.copyAllContentInBase(this.getToMergeWebApp().getDescriptions(), this.getBaseWebApp().getDescriptions());
        }
        if (this.getToMergeWebApp().getDisplayNames() != null) {
            this.copyAllContentInBase(this.getToMergeWebApp().getDisplayNames(), this.getBaseWebApp().getDisplayNames());
        }
        if (this.getToMergeWebApp().getIcons() != null) {
            this.copyAllContentInBase(this.getToMergeWebApp().getIcons(), this.getBaseWebApp().getIcons());
        }
        if (this.getToMergeWebApp().isSetVersion()) {
            this.getBaseWebApp().setVersion(this.getToMergeWebApp().getVersion());
        }
    }
}

