/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameToolsTests
extends TestCase {
    public NameToolsTests(String name) {
        super(name);
    }

    public void testStringAbsentIgnoreCase() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameForIgnoreCase((String)"Taupe", colorCollection);
        NameToolsTests.assertEquals((String)"Taupe", (String)returned);
    }

    public void testStringPresentCaseDiffers() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameFor((String)"green", colorCollection);
        NameToolsTests.assertEquals((String)"green", (String)returned);
    }

    public void testStringPresentIgnoreCase() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameForIgnoreCase((String)"green", colorCollection);
        NameToolsTests.assertEquals((String)"green2", (String)returned);
    }

    public void testStringPresentWithAppendices() {
        List<String> colorCollection = this.buildColorCollection();
        colorCollection.add("Red1");
        colorCollection.add("red2");
        String returned = NameTools.uniqueNameForIgnoreCase((String)"red", colorCollection);
        colorCollection.remove("Red1");
        colorCollection.remove("red2");
        NameToolsTests.assertEquals((String)"red3", (String)returned);
    }

    private List<String> buildColorCollection() {
        ArrayList<String> colorCollection = new ArrayList<String>();
        colorCollection.add("Red");
        colorCollection.add("Orange");
        colorCollection.add("Yellow");
        colorCollection.add("Green");
        colorCollection.add("Blue");
        colorCollection.add("Indigo");
        colorCollection.add("Violet");
        return colorCollection;
    }

    public void testUniqueNameForCollection1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
    }

    public void testUniqueNameForIterator1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings.iterator()));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings.iterator()));
    }

    public void testUniqueNameForIterator2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings.iterator()));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings.iterator()));
    }

    public void testUniqueNameForIterator3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
    }

    public void testBuildQualifiedDatabaseObjectName() {
        NameToolsTests.assertEquals((String)"catalog.schema.name", (String)NameTools.buildQualifiedDatabaseObjectName((String)"catalog", (String)"schema", (String)"name"));
        NameToolsTests.assertEquals((String)"catalog..name", (String)NameTools.buildQualifiedDatabaseObjectName((String)"catalog", null, (String)"name"));
        NameToolsTests.assertEquals((String)"schema.name", (String)NameTools.buildQualifiedDatabaseObjectName(null, (String)"schema", (String)"name"));
        NameToolsTests.assertEquals((String)"name", (String)NameTools.buildQualifiedDatabaseObjectName(null, null, (String)"name"));
    }

    public void testJavaReservedWords() {
        NameToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"class"));
        NameToolsTests.assertFalse((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"Class"));
        NameToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"private"));
    }

    public void testconvertToJavaIdentifierString() {
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo"));
        NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1"));
        NameToolsTests.assertEquals((String)"private_", (String)NameTools.convertToJavaIdentifier((String)"private"));
        NameToolsTests.assertEquals((String)"throw_", (String)NameTools.convertToJavaIdentifier((String)"throw"));
        NameToolsTests.assertEquals((String)"_foo", (String)NameTools.convertToJavaIdentifier((String)"1foo"));
        NameToolsTests.assertEquals((String)"foo_", (String)NameTools.convertToJavaIdentifier((String)"foo%"));
        NameToolsTests.assertEquals((String)"foo__bar__", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  "));
    }

    public void testconvertToJavaIdentifierStringChar() {
        boolean exCaught;
        block8: {
            String s;
            block7: {
                block6: {
                    NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1", (char)'$'));
                    NameToolsTests.assertEquals((String)"private$", (String)NameTools.convertToJavaIdentifier((String)"private", (char)'$'));
                    NameToolsTests.assertEquals((String)"throwss", (String)NameTools.convertToJavaIdentifier((String)"throw", (char)'s'));
                    NameToolsTests.assertEquals((String)"$foo", (String)NameTools.convertToJavaIdentifier((String)"1foo", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo$", (String)NameTools.convertToJavaIdentifier((String)"foo%", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo$$bar$$", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  ", (char)'$'));
                    exCaught = false;
                    try {
                        s = NameTools.convertToJavaIdentifier((String)"1foo", (char)'7');
                        NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage().indexOf(55) == -1) break block6;
                        exCaught = true;
                    }
                }
                NameToolsTests.assertTrue((boolean)exCaught);
                exCaught = false;
                try {
                    s = NameTools.convertToJavaIdentifier((String)"foo%", (char)'^');
                    NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().indexOf(94) == -1) break block7;
                    exCaught = true;
                }
            }
            NameToolsTests.assertTrue((boolean)exCaught);
            exCaught = false;
            try {
                s = NameTools.convertToJavaIdentifier((String)"private", (char)'^');
                NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().indexOf(94) == -1) break block8;
                exCaught = true;
            }
        }
        NameToolsTests.assertTrue((boolean)exCaught);
    }

    public void testStringIsLegalJavaIdentifier() {
        NameToolsTests.assertFalse((boolean)NameTools.stringIsLegalJavaIdentifier((String)"class"));
        NameToolsTests.assertTrue((boolean)NameTools.stringIsLegalJavaIdentifier((String)"clasS"));
        NameToolsTests.assertFalse((boolean)NameTools.stringIsLegalJavaIdentifier((String)"7foo"));
        NameToolsTests.assertFalse((boolean)NameTools.stringIsLegalJavaIdentifier((String)"foo@bar"));
        NameToolsTests.assertTrue((boolean)NameTools.stringIsLegalJavaIdentifier((String)"_foo"));
    }
}

