/*******************************************************************************
 * Copyright (c) 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.db.internal.vendor;

import java.util.List;

import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

/**
 * Handle the variety of catalog (and schema) configurations generated by DTP.
 */
interface CatalogStrategy {

	/**
	 * Return whether the DTP database has real catalogs.
	 */
	boolean supportsCatalogs(Database database);

	/**
	 * Return the specified database's catalogs.
	 */
	List<Catalog> getCatalogs(Database database);

	/**
	 * Return the specified database's schemas.
	 */
	List<Schema> getSchemas(Database database);

}
